/*******************************************************************************
 * \file              spi_tclOnCarSessionCbs.cpp
 * \brief             Class implementing callbacks from OnCarAPI
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Class implementing callbacks from OnCarAPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
08.03.2017  |  Dhiraj Asopa                | Initial Version
16.04.2018  |  Unmukt Jain                 | Added implementation for Session state cb

 \endverbatim
 ******************************************************************************/
/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclOnCarMsgQInterface.h"
#include "spi_tclOnCarSessionDispatcher.h"
#include "spi_tclOnCarSessionCbs.h"
#include "SPI_OnCarTypes.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarSessionCbs.cpp.trc.h"
#endif
#endif


//! OnCarAPI callbacks
/*****************************************************************************************************
 ** FUNCTION:  void spi_tclOnCarSessionCbs::onCarSessionStatusCallback(const ONCARSESSION_STATE state)
 ******************************************************************************************************/
void spi_tclOnCarSessionCbs::onCarSessionStatusCallback(const ONCARSESSION_STATE state)
{
   ETG_TRACE_USR1(("spi_tclOnCarSessionCbs::onCarSessionStatusCallback entered state=%d",state));
   tenOnCarSessionState enOnCarSessionState = e8_ONCAR_SESSION_STATE_UNKNOWN;
   enOnCarSessionState = static_cast<tenOnCarSessionState>(state);

   OnCarSessionStateMsg oOnCarSessionStateMsg;
   oOnCarSessionStateMsg.m_OnCarSessionState = enOnCarSessionState;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarSessionStateMsg, sizeof(oOnCarSessionStateMsg));
   }//if (NULL != poMsgQinterface)
}

/****************************************************************************************************
 ** FUNCTION:  t_Bool spi_tclOnCarSessionCbs::onCarSessionErrorCallbacks(const ONCARSINKERROR error)
 ****************************************************************************************************/
void spi_tclOnCarSessionCbs::onCarSessionErrorCallbacks(const ONCARSINKERROR error)
{
   ETG_TRACE_ERR(("[ERR]:spi_tclOnCarSessionCbs::onCarSessionErrorCallbacks entered error=%d",error));
   tenOnCarSinkError enOnCarSinkError = e32_ONCAR_SINK_NO_ERROR;
   enOnCarSinkError = static_cast<tenOnCarSinkError>(error);

   OnCarSessionErrorMsg oOnCarSessionErrorMsg;
   oOnCarSessionErrorMsg.m_enOnCarSinkError = enOnCarSinkError;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarSessionErrorMsg, sizeof(oOnCarSessionErrorMsg));
   }//if (NULL != poMsgQinterface)
}

/***********************************************************************************************************************
 ** FUNCTION:  void spi_tclOnCarSessionCbs::onCarSinkAppStateCallbacks (const ONCARSINK_APP_STATE NavigationAppState,
                               const ONCARSINK_APP_STATE SpeechAppState,
                               const ONCARSINK_APP_STATE PhoneAppState)
 ************************************************************************************************************************/
void spi_tclOnCarSessionCbs::onCarSinkAppStateCallbacks (const ONCARSINK_APP_STATE NavigationAppState,
                                                         const ONCARSINK_APP_STATE SpeechAppState,
                                                         const ONCARSINK_APP_STATE PhoneAppState)
{
   ETG_TRACE_USR1(("spi_tclOnCarSessionCbs::onCarSinkAppStateCallbacks entered , NavigationAppState : %d, "
      "SpeechAppState : %d, PhoneAppState : %d", NavigationAppState, SpeechAppState, PhoneAppState)); 
   tenNavAppState enNavAppState = e8SPI_NAV_UNKNOWN;

   if(eONCARSINK_APP_STATE_PROJECTION == NavigationAppState)
   {
       enNavAppState = e8SPI_NAV_ACTIVE;
       //enNavAppState = static_cast<tenNavAppState> (NavigationAppState);
   }
   else if(eONCARSINK_APP_STATE_NATIVE == NavigationAppState)
   {
       enNavAppState = e8SPI_NAV_NOT_ACTIVE;
   }
   
   OnCarSinkAppStateMsg oOnCarSinkAppStateMsg;
   oOnCarSinkAppStateMsg.m_enNavAppState = enNavAppState;
   oOnCarSinkAppStateMsg.m_enSpeechAppState = e8SPI_SPEECH_UNKNOWN;
   oOnCarSinkAppStateMsg.m_enPhoneAppState = e8SPI_PHONE_UNKNOWN;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarSinkAppStateMsg, sizeof(oOnCarSinkAppStateMsg));
   }//if (NULL != poMsgQinterface)
}
