/*!
 *******************************************************************************
 * \file              spi_tclOnCarCmdSession.cpp
 * \brief             Device session wrapper for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Device session wrapper for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.02.2018 |  Unmukt Jain                 | Initial Version

 \endverbatim
 ******************************************************************************/
/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclOnCarCmdSession.h"
#include "spi_tclOnCarDataIntf.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarCmdSession.cpp.trc.h"
#endif
#endif


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarCmdSession::spi_tclOnCarCmdSession();
 ***************************************************************************/
spi_tclOnCarCmdSession::spi_tclOnCarCmdSession()
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdSession::spi_tclOnCarCmdSession()"));
}

/***************************************************************************
 ** FUNCTION:  virtual spi_tclOnCarCmdSession::~spi_tclOnCarCmdSession()
 ***************************************************************************/
spi_tclOnCarCmdSession::~spi_tclOnCarCmdSession()
{
   ETG_TRACE_USR1((" spi_tclOnCarCmdSession::~spi_tclOnCarCmdSession() entered"));
   m_spoSessionCbs = nullptr;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclOnCarCmdSession::bInitializeSession()
 ***************************************************************************/
t_Bool spi_tclOnCarCmdSession::bInitializeSession(OnCarConfig config)
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdSession::bInitializeSession() entered"));
   t_Bool bRetval =  false;
   spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
   OnCarAPI *poOnCarAPI = NULL;
   if(NULL != poOnCarDataIntf)
   {
       poOnCarAPI = poOnCarDataIntf->poGetOnCarAPIInstance();
   }
   if(NULL != poOnCarAPI)
   {
	   poOnCarAPI->setOnCarAPIConfig(config);
	   t_U32 u32ret = poOnCarAPI->init("");
	   if(u32ret != eONCARSINK_NO_ERROR && poOnCarDataIntf != NULL)
	   {
		   ETG_TRACE_ERR(("spi_tclOnCarCmdSession::bInitializeSession() init method failed!!"));
		   bRetval = false;
	   }
	   else
	   {
		   m_spoSessionCbs = std::make_shared<spi_tclOnCarSessionCbs>();
		   if(m_spoSessionCbs != nullptr)
		   {
			   poOnCarAPI->registerSessionCallbacks(m_spoSessionCbs);
			   bRetval = true;
		   }
	   }
   }
   ETG_TRACE_USR1(("spi_tclOnCarCmdSession::bInitializeSession() returned with bRetval=%d",bRetval));
   return bRetval;
}


/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarCmdSession:: vUnInitializeSession( )
 ***************************************************************************/
t_Void spi_tclOnCarCmdSession::vUnInitializeSession()
{
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::vUnInitializeSession() entered"));
    spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
    OnCarAPI *poOnCarAPI = NULL;
    if(NULL != poOnCarDataIntf)
    {
        poOnCarAPI = poOnCarDataIntf->poGetOnCarAPIInstance();
        if(NULL != poOnCarAPI)
        {
            poOnCarAPI->deinit();
        }
        poOnCarDataIntf->vDestroyOnCarAPIInstance();
    }
}


/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclOnCarCmdSession:: bStartTransport(const t_String &corfszDeviceSerial)
 ***************************************************************************/
t_Bool spi_tclOnCarCmdSession::bStartTransport(const t_String &corfszDeviceSerial)
{
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::bStartTransport() entered corfszDeviceSerial=%s",corfszDeviceSerial.c_str()));
    t_Bool bRetval =  false;
    spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
    OnCarAPI *poOnCarAPI = NULL;
    if(NULL != poOnCarDataIntf)
    {
        poOnCarAPI = poOnCarDataIntf->poGetOnCarAPIInstance();
    }
    if(NULL != poOnCarAPI)
    {
        AoapAccessory oAccessory;
        oAccessory.szSerialNumber = corfszDeviceSerial;
        ONCARSINKERROR error = poOnCarAPI->createConnection(oAccessory);
        bRetval = (eONCARSINK_NO_ERROR == error);
        if(!bRetval)
            ETG_TRACE_ERR(("create connection failed with error =%d",error));
    }
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::bStartTransport() left with bRetval=%d",bRetval));
    return bRetval;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarCmdSession:: bStopTransport( )
 ***************************************************************************/
t_Bool spi_tclOnCarCmdSession::bStopTransport(const t_String &corfszDeviceSerial)
{
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::bStopTransport() corfszDeviceSerial=%s",corfszDeviceSerial.c_str()));
    t_Bool bRetval =  false;
    spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
    OnCarAPI *poOnCarAPI = NULL;
    if(NULL != poOnCarDataIntf)
    {
        poOnCarAPI = poOnCarDataIntf->poGetOnCarAPIInstance();
    }
    if(NULL != poOnCarAPI)
    {
        AoapAccessory oAccessory;
        oAccessory.szSerialNumber = corfszDeviceSerial;
        ONCARSINKERROR error = poOnCarAPI->destroyConnection(oAccessory);
        bRetval = (eONCARSINK_NO_ERROR == error);
    }
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::bStopTransport() left with bRetval=%d",bRetval));
    return bRetval;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarCmdSession:: vSetHeadUnitInfo( )
 ***************************************************************************/
t_Void spi_tclOnCarCmdSession::vSetHeadUnitInfo()
{
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::vSetHeadUnitInfo() entered"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclOnCarCmdSession::vSetNavigationFocus()
 ***************************************************************************/
t_Void spi_tclOnCarCmdSession::vSetNavigationFocus(tenNavAppState enAccNavAppState)
{
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::vSetNavigationFocus() entered : NavState : %d", 
                  ETG_ENUM(NAV_APP_STATE, enAccNavAppState)));
    spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
    OnCarAPI *poOnCarAPI = NULL;
    if(NULL != poOnCarDataIntf)
    {
       poOnCarAPI = poOnCarDataIntf->poGetOnCarAPIInstance();
       if(NULL != poOnCarAPI)
       {
          NAVIGATION_FOCUS enNavFocusType = (e8SPI_NAV_ACTIVE == enAccNavAppState)
                    ? (eNAVIGATION_FOCUS_NATIVE) : (eNAVIGATION_FOCUS_PROJECTED);
          ETG_TRACE_USR1(("Update Navigation focus to Device : %d ", enNavFocusType));
          poOnCarAPI->setNavigationFocus(enNavFocusType);
      }
    }
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclOnCarCmdSession::vSetAudioFocus()
 ***************************************************************************/
t_Void spi_tclOnCarCmdSession::vSetAudioFocus()
{
    ETG_TRACE_USR1(("spi_tclOnCarCmdSession::vSetAudioFocus() entered"));
}


