/***********************************************************************/
/*!
 * \file  spi_tclOnCarSessionDispatcher.h
 * \brief Message Dispatcher for Session Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Session Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 23.02.2018  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef SPI_TCLONCARSESSIONDISPATCHER_H_
#define SPI_TCLONCARSESSIONDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPI_OnCarTypes.h"

/**************Forward Declarations******************************************/
class spi_tclOnCarSessionDispatcher;

/****************************************************************************/
/*!
 * \class OnCarSessionMsgBase
 * \brief Base Message type for all Session messages
 ****************************************************************************/
class OnCarSessionMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  OnCarSessionMsgBase::OnCarSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      OnCarSessionMsgBase()
       * \brief   Default constructor
       **************************************************************************/
       OnCarSessionMsgBase();

      /***************************************************************************
       ** FUNCTION:  OnCarSessionMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarSessionDispatcher* poSessionDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param   poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      virtual t_Void vDispatchMsg(
               spi_tclOnCarSessionDispatcher* poSessionDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  OnCarSessionMsgBase::~OnCarSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~OnCarSessionMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarSessionMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  OnCarSessionMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle(){return m_u32DeviceHandle;}

      /***************************************************************************
       ** FUNCTION:  OnCarSessionMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(const t_U32 cou32DevHndle) {m_u32DeviceHandle = cou32DevHndle;};

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class OnCarSessionStateMsg
 * \brief OnCar session state message
 ****************************************************************************/
class OnCarSessionStateMsg : public OnCarSessionMsgBase
{
   public:
      tenOnCarSessionState m_OnCarSessionState;

      /***************************************************************************
       ** FUNCTION:  OnCarSessionStateMsg::OnCarSessionStateMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarSessionStateMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarSessionStateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarSessionStateMsg::~OnCarSessionStateMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarSessionStateMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarSessionStateMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarSessionStateMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarSessionStateMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarSessionStateMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};

/****************************************************************************/
/*!
 * \class OnCarSessionErrorMsg
 * \brief OnCar session error message
 ****************************************************************************/
class OnCarSessionErrorMsg : public OnCarSessionMsgBase
{
   public:
      tenOnCarSinkError m_enOnCarSinkError;

      /***************************************************************************
       ** FUNCTION:  OnCarSessionErrorMsg::OnCarSessionErrorMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarSessionErrorMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarSessionErrorMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarSessionErrorMsg::~OnCarSessionErrorMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarSessionErrorMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarSessionErrorMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarSessionErrorMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarSessionErrorMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarSessionErrorMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};

/****************************************************************************/
/*!
 * \class OnCarSinkAppStateMsg
 * \brief OnCar session state message
 ****************************************************************************/
class OnCarSinkAppStateMsg : public OnCarSessionMsgBase
{
   public:
      tenNavAppState m_enNavAppState;
      tenSpeechAppState m_enSpeechAppState;	  
      tenPhoneAppState m_enPhoneAppState; 
	  
      /***************************************************************************
       ** FUNCTION:  OnCarSinkAppStateMsg::OnCarSinkAppStateMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarSinkAppStateMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarSinkAppStateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarSinkAppStateMsg::~OnCarSinkAppStateMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarSinkAppStateMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarSinkAppStateMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarSinkAppStateMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarSinkAppStateMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarSinkAppStateMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};

/****************************************************************************/
/*!
 * \class spi_tclOnCarSessionDispatcher
 * \brief Message Dispatcher for Session Messages
 ****************************************************************************/
class spi_tclOnCarSessionDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarSessionDispatcher::spi_tclOnCarSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarSessionDispatcher()
       * \brief   Default constructor
       **************************************************************************/
       spi_tclOnCarSessionDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarSessionDispatcher::~spi_tclOnCarSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclOnCarSessionDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclOnCarSessionDispatcher();
	  
      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSessionStateMsg* poOnCarSessionStateMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(OnCarSessionStateMsg* poOnCarSessionStateMsg)
       * \param   poOnCarSessionStateMsg : pointer to OnCarSessionStateMsg.
       **************************************************************************/	  
      t_Void vHandleSessionMsg(OnCarSessionStateMsg* poOnCarSessionStateMsg) const;	 	  

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSessionErrorMsg* poOnCarSessionErrorMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(OnCarSessionErrorMsg* poOnCarSessionErrorMsg)
       * \param   poOnCarSessionErrorMsg : pointer to OnCarSessionErrorMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(OnCarSessionErrorMsg* poOnCarSessionErrorMsg) const; 
	  
      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSinkAppStateMsg* poOnCarSinkAppStateMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(OnCarSinkAppStateMsg* poOnCarSinkAppStateMsg)
       * \param   poOnCarSinkAppStateMsg : pointer to OnCarSinkAppStateMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(OnCarSinkAppStateMsg* poOnCarSinkAppStateMsg) const;	  

};

#endif /* SPI_TCLONCARSESSIONDISPATCHER_H_ */
