/***********************************************************************/
/*!
* \file  spi_tclOnCarRespSession.h
* \brief OnCar Session Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    OnCar Session Output Interface
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                   | Modification
22.03.2018  | Unmukt Jain              | Initial Version
\endverbatim
*************************************************************************/

#ifndef SPI_TCLONCARRESPSESSION_H_
#define SPI_TCLONCARRESPSESSION_H_

#include "RespBase.h"
#include "SPI_OnCarTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclOnCarRespSession
* \brief OnCar Session Output Interface
*
* updates all the registered clients, whenever there is
* an update on OnCar session
*
****************************************************************************/
class spi_tclOnCarRespSession:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespSession::spi_tclOnCarRespSession()
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespSession()
   * \brief   Constructor
   * \sa      ~spi_tclOnCarRespSession()
   **************************************************************************/
    spi_tclOnCarRespSession():RespBase(e16ONCAR_SESSION_REGID)
   {

   }

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespSession::~spi_tclOnCarRespSession()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclOnCarRespSession()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclOnCarRespSession(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclOnCarRespSession(){}

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespSession::vPostOnCarSessionStateMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarSessionStateMsg()
   * \brief   Invoked to provide information about OnCar session state
   * \param   enOnCarSessionState: OnCar session state
   **************************************************************************/
   virtual t_Void vPostOnCarSessionStateMsg(const tenOnCarSessionState enOnCarSessionState)
   {
       SPI_INTENTIONALLY_UNUSED(enOnCarSessionState);
   }

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespSession::vPostOnCarAppStateMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarAppStateMsg()
   * \brief   Invoked to provide information about OnCar app states
   * \param   enNavAppState: OnCar nav app state
   * \param   enSpeechAppState: OnCar speech app state
   * \param   enPhoneAppState: OnCar phone app state
   **************************************************************************/
   virtual t_Void vPostOnCarAppStateMsg(const tenNavAppState enNavAppState,
                                        const tenSpeechAppState enSpeechAppState,
										const tenPhoneAppState enPhoneAppState)
   {
       SPI_INTENTIONALLY_UNUSED(enNavAppState);
       SPI_INTENTIONALLY_UNUSED(enSpeechAppState);
       SPI_INTENTIONALLY_UNUSED(enPhoneAppState);
   }

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespSession::vPostOnCarSessionErrorMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarSessionErrorMsg()
   * \brief   Invoked to provide information about OnCar session error
   * \param   enOnCarSinkError: OnCar session error
   **************************************************************************/
   virtual t_Void vPostOnCarSessionErrorMsg(const tenOnCarSinkError enOnCarSinkError)
   {
       SPI_INTENTIONALLY_UNUSED(enOnCarSinkError);
   }

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespSession::spi_tclOnCarRespSession()
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespSession(
   *                          const spi_tclOnCarRespSession& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclOnCarRespSession(RegID enRegId)
   **************************************************************************/
   spi_tclOnCarRespSession(const spi_tclOnCarRespSession& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespSession& operator=( const spi_tclMLV...
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespSession& operator=(
   *                          const spi_tclOnCarRespSession& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclOnCarRespSession(const spi_tclOnCarRespSession& otrSrc)
   ***************************************************************************/
   spi_tclOnCarRespSession& operator=(const spi_tclOnCarRespSession& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

};

#endif /* SPI_TCLONCARRESPSESSION_H_ */
