/*!
 *******************************************************************************
 * \file              spi_tclOnCarCmdSession.h
 * \brief             Device session wrapper for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Device session wrapper for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.02.2018 |  Unmukt Jain                 | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLONCARCMDSESSION_H_
#define SPI_TCLONCARCMDSESSION_H_

/******************************************************************************
 | includes:
 | 1)AAP - includes
 | 2)Typedefines
 |----------------------------------------------------------------------------*/

#include "SPI_OnCarTypes.h"
#include "spi_tclOnCarSessionCbs.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclOnCarCmdSession
 * \brief
 */

class spi_tclOnCarCmdSession
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarCmdSession::spi_tclOnCarCmdSession();
       ***************************************************************************/
      /*!
       * \fn     spi_tclOnCarCmdSession()
       * \brief  Default Constructor
       * \sa      ~spi_tclOnCarCmdSession()
       **************************************************************************/
       spi_tclOnCarCmdSession();

      /***************************************************************************
       ** FUNCTION:  virtual spi_tclOnCarCmdSession::~spi_tclOnCarCmdSession()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclOnCarCmdSession()
       * \brief   Destructor
       * \sa      spi_tclOnCarCmdSession()
       **************************************************************************/
      virtual ~spi_tclOnCarCmdSession();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarCmdSession::bInitializeSession()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitializeSession()
       * \brief   Initializes session by creating OnCarAPI
       * \retval  true : initialized successfull.
       * \retval  false : initialization failed
       * \sa      vUnInitializeSession()
       **************************************************************************/
      t_Bool bInitializeSession(const OnCarConfig config);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarCmdSession:: vUnInitializeSession( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vUnInitializeSession()
       * \brief   UnInitializes session by destroying OnCarAPI
       * \sa      bIntializeSession
       **************************************************************************/
      t_Void vUnInitializeSession();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarCmdSession:: bStartTransport(const t_String & )
       ***************************************************************************/
      /*!
       * \fn      t_Bool bStartTransport(const t_String &)
       * \brief   Start transport (communication between MD and HU
       * \param   corfszDeviceSerial: Serial of the device
       * \sa      vStopTransport
       **************************************************************************/
      t_Bool bStartTransport(const t_String &corfszDeviceSerial);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarCmdSession:: bStopTransport(const t_String &)
       ***************************************************************************/
      /*!
       * \fn      t_Bool bStopTransport()
       * \brief   Stop transport
       * \param   corfszDeviceSerial: Serial of the device
       * \sa      bStartTransport
       **************************************************************************/
      t_Bool bStopTransport(const t_String &corfszDeviceSerial);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarCmdSession:: vSetHeadUnitInfo( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetHeadUnitInfo()
       * \brief   Sets info about the head unit for authentication
       * \param   rfrHeadUnitInfo : Head unit information
       **************************************************************************/
      t_Void vSetHeadUnitInfo();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarCmdSession::vSetNavigationFocus()
       ***************************************************************************/
      /*!
       * \fn      vSetNavigationFocus(tenAAPNavFocusType enNavFocusType)
       * \brief   Set Navigation Focus type
       * \param   enNavFocusType : Navigation focus type
       **************************************************************************/
      t_Void vSetNavigationFocus(tenNavAppState enAccNavAppState);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarCmdSession::vSetAudioFocus()
       ***************************************************************************/
      /*!
       * \fn      vSetAudioFocus(AudioFocusStateType focusState, bool unsolicited)
       * \brief   Set Audio Focus type
       * \param
       **************************************************************************/
      t_Void vSetAudioFocus();

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION: spi_tclOnCarCmdSession(const spi_tclOnCarCmdSession &rfcoobjCRCBResp)
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarCmdSession(const spi_tclOnCarCmdSession &rfcoobjCRCBResp)
       * \brief   Copy constructor not implemented hence made protected
       **************************************************************************/
       spi_tclOnCarCmdSession(const spi_tclOnCarCmdSession &rfcoobjCRCBResp);

      /***************************************************************************
       ** FUNCTION: const spi_tclOnCarCmdSession & operator=(
       **                                 const spi_tclOnCarCmdSession &rfcoobjCRCBResp);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclOnCarCmdSession & operator=(const spi_tclOnCarCmdSession &objCRCBResp);
       * \brief   assignment operator not implemented hence made protected
       **************************************************************************/
      const spi_tclOnCarCmdSession & operator=(
               const spi_tclOnCarCmdSession &rfcoobjCRCBResp);

      //! shared pointer for OnCar session callbacks
      std::shared_ptr<IOnCarSessionCallbacks> m_spoSessionCbs;

};

#endif /* SPI_TCLONCARCMDSESSION_H_ */
