/*!
 *******************************************************************************
 * \file              spi_tclOnCarCmdSensor.h
 * \brief             Sensor wrapper for OnCar
 *******************************************************************************
 \verbatim
 PROJECT		:	Gen3
 SW-COMPONENT	:	Smart Phone Integration
 DESCRIPTION	:	Sensor wrapper for OnCar
 COPYRIGHT		:	&copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 26.04.2018  | Rishav Sardar	     | Initial Version
 
 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLONCARCMDSENSOR_H_
#define _SPI_TCLONCARCMDSENSOR_H_

#include "OnCarSensorEndpoint.h"
#include "OnCarAPI.h"
#include "SPI_OnCarTypes.h"

#include "Lock.h"
#include "SPITypes.h"
#include "SPI_OnCarTypes.h"


/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclAAPCmdSensor
 * \brief
 */

class spi_tclOnCarCmdSensor
{
   public:

  /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

  /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdSensor::spi_tclOnCarCmdSensor();
   ***************************************************************************/
  /*!
   * \fn     spi_tclOnCarCmdSensor()
   * \brief  Default Constructor
   * \sa      spi_tclOnCarCmdSensor()
   **************************************************************************/
	spi_tclOnCarCmdSensor();

  /***************************************************************************
   ** FUNCTION:  virtual spi_tclOnCarCmdSensor::~spi_tclOnCarCmdSensor()
   ***************************************************************************/
  /*!
   * \fn      virtual ~spi_tclOnCarCmdSensor()
   * \brief   Virtual Destructor
   * \sa      spi_tclOnCarCmdSensor()
   **************************************************************************/
  virtual  ~spi_tclOnCarCmdSensor();

  /***************************************************************************
   ** FUNCTION:  virtual spi_tclOnCarCmdSensor::bInitializeSensorEndpoint(const trDataServiceConfigData& rfrDataServiceConfigData)
   ***************************************************************************/
  /*!
   * \fn      bInitializeSensorEndpoint(const trDataServiceConfigData& rfrDataServiceConfigData)
   * \brief   Initializes the Sensor Endpoint, registers keycodes and touch
   *            screen.
   * \param   rDataServiceConfigData : the structure consists of values TRUE for location data, dead reckoning data
   *          environment data, gear status, accelerometer data and gyroscope data if available FALSE if not.
   * \sa      bUnInitializeSensorEndpoint()
   **************************************************************************/
  t_Bool  bInitializeSensorEndpoint(const trDataServiceConfigData& rfrDataServiceConfigData);

  /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdSensor::spi_tclOnCarCmdSensor()
   ***************************************************************************/
  /*!
   * \fn      bUnInitializeSensorEndpoint()
   * \brief   Uninitializes the SensorSource Endpoint.
   * \sa      bInitializeSensorEndpoint()
   **************************************************************************/
  t_Void   bUnInitializeSensorEndpoint();
  
  /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdSensor::vReportLocationData(...)
   ***************************************************************************/
  /*!
   * \fn    vReportLocationData()
   * \brief	Use this method to report a GPS location. 
   *        The eX multiplication is to allow for fixed point representation of decimal values using an int32. 
   *        For example, the value 3.1415 becomes 31415000 in E7 notation and can be represented as an integer. 
   *\param  rfrcGpsData  Contains all GPS related data
   * \sa    vReportLocationData()
   **************************************************************************/  
  t_Void vReportLocationData(const trSensorData& rfrcSensorGpsData);
  
   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdSensor::vReportSpeedData(s32speedE3)
   ***************************************************************************/
  /*!
   * \fn    vReportSpeedData(s32speedE3)
   * \brief	Use this function to report the current speed of the vehicle. 
            The value reported here might be used in dead reckoning the position of the vehicle in the event of a GPS signal loss. 
   * \param s32speedE3	The speed in m/s absolute velocity multiplied by 1e3.
   * \sa    vReportSpeedData()
   **************************************************************************/
  t_Void vReportSpeedData(t_S32 s32speedE3);

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdSensor::vReportDayNightMode(...)
   ***************************************************************************/
  /*!
   * \fn    vReportDayNightMode()
   * \brief	Use this to report the value of the day-night sensor. 
   *        The value of this sensor will affect the UI of projected applications.
   * \param night_mode	true if night mode is enabled, false otherwise.
   * \sa    vReportDayNightMode()
   **************************************************************************/
  t_Void vReportDayNightMode(tenOnCarDayNightMode enMode);
 
   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdSensor::vSetDriveModeRestriction(...)
   ***************************************************************************/
  /*!
   * \fn    vSetDriveModeRestriction(t_S32 s32RestrictionInfo)
   * \brief	Use this call to report driving status change. 
   * \param s32RestrictionInfo	Indicates the level of restrictions available and is defined as a bitmask.
   *        The available options are: DRIVE_STATUS_UNRESTRICTED, DRIVE_STATUS_NO_VIDEO,
   *        DRIVE_STATUS_NO_KEYBOARD_INPUT, DRIVE_STATUS_NO_VOICE_INPUT,
   *        DRIVE_STATUS_NO_CONFIG, DRIVE_STATUS_LIMIT_MESSAGE_LEN
   * \sa    vSetDriveModeRestriction()
   **************************************************************************/
  t_Void vSetDriveModeRestriction(t_S32 s32RestrictionInfo);

  /***************************************************************************
     ** FUNCTION:  spi_tclOnCarCmdSensor::vReportVehicleDrivingState(...)
     ***************************************************************************/
    /*!
     * \fn    vReportVehicleDrivingState()
     * \brief	Use this to report the value of driving status.
     *        The value of this sensor will affect the UI of projected applications.
     * \param enStatus	Report vehicle movement state.
     * \sa    vReportVehicleDrivingState()
     **************************************************************************/
    t_Void vReportVehicleDrivingState(tenOnCarDrivingState enState);


private:

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdSensor(const spi_tclOnCarCmdSensor...
   ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarCmdSensor(
    *                             const spi_tclOnCarCmdSensor& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \retval
    * \sa      spi_tclOnCarCmdSensor()
    ***************************************************************************/
   spi_tclOnCarCmdSensor(const spi_tclOnCarCmdSensor& corfoSrc);


   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarCmdSensor& operator=( const spi_tclOnCarCmdSensor...
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarCmdSensor& operator=(
    *                          const spi_tclOnCarCmdSensor& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \retval
    * \sa      spi_tclOnCarCmdSensor(const spi_tclOnCarCmdSensor& otrSrc)
    ***************************************************************************/
    spi_tclOnCarCmdSensor& operator=(const spi_tclOnCarCmdSensor& corfoSrc);

    //! Sensor Endpoint Pointer
    OnCarSensorEndpoint* m_poOnCarSensorEndpoint;

    //! Lock to prevent accessing sensor endpoint from different thread after deleting the endpoint
    Lock m_oSensorEndPointLock;

    //Vehicle speed used to determine heading validity
    //if vehicle speed is zero then heading can't be calculated
    t_S32 m_s32speed;
};
#endif /* _SPI_TCLONCARCMDSENSOR_H_ */
