/*!
 *******************************************************************************
 * \file              spi_tclOnCarMetadataCbs.cpp
 * \brief             Metadata Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Metadata Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 20.03.2018 |  Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclOnCarMsgQInterface.h"
#include "spi_tclOnCarMetadataDispatcher.h"
#include "spi_tclOnCarMetadataCbs.h"
#include<vector>

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarMetadataCbs.cpp.trc.h"
#endif
#endif


/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate(...)
***************************************************************************/
void spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate(const OnCarMediaMetadata &metadata)
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate() entered "));
   OnCarMediaMetadataUpdateMsg oMediaMetadataUpdateMsg;
   if(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata)
   {
       if(metadata.song.length() < STR_ONCAR_METADATA_LENGTH)
       {
           //memset(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cSong, 0, STR_ONCAR_METADATA_LENGTH);
           strncpy(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cSong,metadata.song.c_str(),STR_ONCAR_METADATA_LENGTH-1);
       }//if(metadata.song.length() < STR_ONCAR_METADATA_LENGTH)
       if(metadata.album.length() < STR_ONCAR_METADATA_LENGTH)
       {
           //memset(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cAlbum, 0, STR_ONCAR_METADATA_LENGTH);
           strncpy(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cAlbum,metadata.album.c_str(),STR_ONCAR_METADATA_LENGTH-1);
       }//if(metadata.album.length() < STR_ONCAR_METADATA_LENGTH)
       if(metadata.artist.length() < STR_ONCAR_METADATA_LENGTH)
       {
          // memset(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cArtist, 0, STR_ONCAR_METADATA_LENGTH);
           strncpy(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cArtist,metadata.artist.c_str(),STR_ONCAR_METADATA_LENGTH-1);
       }//if(metadata.artist.length() < STR_ONCAR_METADATA_LENGTH)
       if(metadata.playlist.length() < STR_ONCAR_METADATA_LENGTH)
       {
           //memset(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cPlaylist, 0, STR_ONCAR_METADATA_LENGTH);
           strncpy(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cPlaylist,metadata.playlist.c_str(),STR_ONCAR_METADATA_LENGTH-1);
       }//if(metadata.playlist.length() < STR_ONCAR_METADATA_LENGTH)
       if(!metadata.album_art.empty())
       {
         copy(metadata.album_art.begin(),metadata.album_art.end(),back_inserter( oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->u8AlbumArt));
       }//if(!metadata.album_art.empty())
       oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->u32DurationSeconds = metadata.duration_seconds;
       oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->u32Rating = metadata.rating;

       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate() : Call backs Song = %s"
                       ,oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cSong));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate() : Call backs Album = %s",
                       oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cAlbum));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate() : Call backs Artist = %s",
                       oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cArtist));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate() : Call backs Playlist = %s",
                       oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->cPlaylist));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate() : Duration = %d, Rating = %d",
                       oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->u32DurationSeconds ,
                       oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata->u32Rating));

       spi_tclOnCarMsgQInterface *poMsgQInterface = spi_tclOnCarMsgQInterface::getInstance();
       if(poMsgQInterface)
       {
           poMsgQInterface->bWriteMsgToQ(&oMediaMetadataUpdateMsg,sizeof(oMediaMetadataUpdateMsg));
       }//if(poMsgQInterface)
   }//if(oMediaMetadataUpdateMsg.m_prOnCarMediaMetadata)
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate() left "));
}//!end of onCarMediaMetadataUpdate()

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate(...)
***************************************************************************/
void spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate(const OnCarMediaPlaybackStatus &playbackstatus)
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate() entered "));
   OnCarMediaPlaybackStatusUpdateMsg oMediaPlaybackStatusUpdateMsg;
   if(oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus)
   {
       if(playbackstatus.media_source.length() < STR_ONCAR_METADATA_LENGTH)
       {
           memset(oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->cMediaSource, 0, STR_ONCAR_METADATA_LENGTH);
           strncpy(oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->cMediaSource,playbackstatus.media_source.c_str(),STR_ONCAR_METADATA_LENGTH-1);
       }//if(playbackstatus.media_source.length() < STR_ONCAR_METADATA_LENGTH)
       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->enState = static_cast<tenOnCarMediaPlaybackState> (playbackstatus.state);
       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->u32PlaybackSeconds = playbackstatus.playback_seconds;
       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->bShuffle = playbackstatus.shuffle;
       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->bRepeatAll = playbackstatus.repeat_all;
       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->bRepeatOne = playbackstatus.repeat_one;

       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate() : Call backs MediaSource = %s",
                       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->cMediaSource));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate() : Call backs State = %d",
                       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->enState));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate() : Call backs PlaybackSeconds = %d",
                       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->u32PlaybackSeconds));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate() : Call backs Shuffle = %d",
                       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->bShuffle));
       ETG_TRACE_USR4(("[DESC]:spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate() : RepeatAll = %d, RepeatOne = %d",
                       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->bRepeatAll ,
                       oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus->bRepeatOne));

       spi_tclOnCarMsgQInterface *poMsgQInterface = spi_tclOnCarMsgQInterface::getInstance();
       if(poMsgQInterface)
       {
           poMsgQInterface->bWriteMsgToQ(&oMediaPlaybackStatusUpdateMsg,sizeof(oMediaPlaybackStatusUpdateMsg));
       }//if(poMsgQInterface)
   }//if(oMediaPlaybackStatusUpdateMsg.m_prOnCarMediaPlaybackStatus)
}//!end of onCarMediaPlaybackStatusUpdate()


