/***************************************************************************/
/*!
* \file  spi_tclOnCarCmdMetadata.cpp
* \brief Interface to interact with OnCar Metadata Endpoint
****************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface to interact with OnCar Metadata Endpoint
AUTHOR:         irh1kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
31.05.2018  | Rishav Sardar         | Initial Version

\endverbatim
*****************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "OnCarTypes.h"
#include "spi_tclOnCarDataIntf.h"
#include "spi_tclOnCarCmdMetadata.h"
#include "OnCarAPI.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
      #include "trcGenProj/Header/spi_tclOnCarCmdMetadata.cpp.trc.h"
   #endif
#endif
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/

/***************************************************************************
** FUNCTION:  spi_tclOnCarCmdMetadata::spi_tclOnCarCmdMetadata()
***************************************************************************/

spi_tclOnCarCmdMetadata::spi_tclOnCarCmdMetadata() :
m_poOnCarMetadataEndpoint(NULL)
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarCmdMetadata::spi_tclOnCarCmdMetadata() entered "));
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarCmdMetadata::spi_tclOnCarCmdMetadata() left "));
}//!end of spi_tclOnCarCmdMetadata()

/***************************************************************************
** FUNCTION:  spi_tclOnCarCmdMetadata::~spi_tclOnCarCmdMetadata()
***************************************************************************/
spi_tclOnCarCmdMetadata::~spi_tclOnCarCmdMetadata()
{
   ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarCmdMetadata::~spi_tclOnCarCmdMetadata() entered "));
   m_oMetadataEndpointLock.s16Lock();
   m_spoMetadataCbs = nullptr;
   m_oMetadataEndpointLock.vUnlock();
   ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarCmdMetadata::~spi_tclOnCarCmdMetadata() left "));
}//!end of spi_tclOnCarCmdMetadata()

/***************************************************************************
** FUNCTION:  t_Bool spi_tclOnCarCmdMetadata::bInitialiseMetadataEndpoint()
***************************************************************************/
t_Bool spi_tclOnCarCmdMetadata::bInitialiseMetadataEndpoint()
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarCmdMetadata::bInitialiseMetadataEndpoint() entered"));
   spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
   OnCarAPI *poOnCarAPI = NULL;
   if(poOnCarDataIntf)
   {
	   m_poOnCarMetadataEndpoint = poOnCarDataIntf->poGetMetadataEndpointInstance();
	   poOnCarAPI = poOnCarDataIntf->poGetOnCarAPIInstance();
   }//if(poOnCarDataIntf)

   t_Bool bRegSuccess = false;
   m_oMetadataEndpointLock.s16Lock();
   if ((m_poOnCarMetadataEndpoint) && (poOnCarAPI))
   {
      ETG_TRACE_USR1(("[DESC]:spi_tclOnCarCmdMetadata::bInitialiseMetadataEndpoint() : Creating Metadata Endpoint "));
      m_spoMetadataCbs = std::make_shared<spi_tclOnCarMetadataCbs>();
      if(m_spoMetadataCbs != nullptr)
      {
    	  m_poOnCarMetadataEndpoint->registerCallbacks(m_spoMetadataCbs);
      }//if(m_spoMetadataCbs != nullptr)
      m_poOnCarMetadataEndpoint->init();
      bRegSuccess = poOnCarAPI->registerService(m_poOnCarMetadataEndpoint);
      ETG_TRACE_USR2(("[DESC]:spi_tclOnCarCmdMetadata::bInitialiseMetadataEndpoint() : "
    		  	  	  "Metadata Endpoint intialization result: %d",ETG_ENUM(BOOL, bRegSuccess)));
   }// if ((m_poOnCarMetadataEndpoint) && (poOnCarAPI))
   m_oMetadataEndpointLock.vUnlock();
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarCmdMetadata::bInitialiseMetadataEndpoint() left with bRegSuccess = %d",bRegSuccess));
   return bRegSuccess;
}//!end of bInitialiseMetadataEndpoint()

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdBluetooth::vUninitialiseMetadataEndpoint()
***************************************************************************/
t_Void spi_tclOnCarCmdMetadata::vUninitialiseMetadataEndpoint()
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarCmdMetadata::vUninitialiseMetadataEndpoint() entered "));
   m_oMetadataEndpointLock.s16Lock();
   if(m_poOnCarMetadataEndpoint)
   {
	   m_poOnCarMetadataEndpoint->deinit();
   }//if(m_poOnCarMetadataEndpoint)
   m_oMetadataEndpointLock.vUnlock();
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarCmdMetadata::vUninitialiseMetadataEndpoint() left "));
}//!end of vUninitialiseMetadataEndpoint()

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdMetadata::DestroyMetadataEndpointInstance()
***************************************************************************/
t_Void spi_tclOnCarCmdMetadata::DestroyMetadataEndpointInstance()
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarCmdMetadata::DestroyMetadataEndpointInstance() entered "));
   m_oMetadataEndpointLock.s16Lock();
   spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
   if((m_poOnCarMetadataEndpoint) &&  (poOnCarDataIntf))
   {
	   poOnCarDataIntf->vDestroyEndpointInstance(m_poOnCarMetadataEndpoint,e8_ONCAR_OBJECTFACTORY_METADATA_ENDPOINT);
	   m_poOnCarMetadataEndpoint = NULL;
   }//if((m_poOnCarMetadataEndpoint) &&  (poOnCarDataIntf))
   m_spoMetadataCbs = nullptr;
   m_oMetadataEndpointLock.vUnlock();
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarCmdMetadata::DestroyMetadataEndpointInstance() left "));
}//!end of DestroyMetadataEndpointInstance()

// <EOF>
