/***********************************************************************/
/*!
* \file  spi_tclOnCarCmdMetadata.h
* \brief Interface to interact with OnCar Metadata Endpoint
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface to interact with  OnCar Metadata Endpoint
AUTHOR:         irh1kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
31.05.2018  | Rishav Sardar         | Initial Version

\endverbatim
*************************************************************************/

#ifndef _SPI_TCLONCARCMDMETADATA_H_
#define _SPI_TCLONCARCMDMETADATA_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "BaseTypes.h"
#include "SPI_OnCarTypes.h"
#include "spi_tclOnCarMetadataCbs.h"
#include "Lock.h"

//class OnCarAPI;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/* Forward declaration */

/******************************************************************************/
/*!
* \class spi_tclOnCarCmdMetadata
* \brief Interface to interact with Metadata Endpoint
*
* It provides an interface to interact with OnCar API.
* It is responsible for creation & initialization of Metadata Endpoint.
*******************************************************************************/
class spi_tclOnCarCmdMetadata
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdMetadata::spi_tclOnCarCmdMetadata()
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarCmdMetadata()
   * \brief   Default Constructor
   * \sa      ~spi_tclOnCarCmdMetadata()
   ***************************************************************************/
	spi_tclOnCarCmdMetadata();

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarCmdMetadata::~spi_tclOnCarCmdMetadata()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclOnCarCmdMetadata()
   * \brief   Destructor
   * \sa      spi_tclOnCarCmdMetadata()
   ***************************************************************************/
   ~spi_tclOnCarCmdMetadata();

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclOnCarCmdMetadata::bInitialiseMetadataEndpoint()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bInitialiseMetadataEndpoint()
   * \brief   Creates and initialises an instance of Metadata Endpoint
   * \retval  t_Bool  :  True if the Metadata Endpoint is initialised, else False
   * \sa      vUninitialiseMetadataEndpoint()
   ***************************************************************************/
   t_Bool bInitialiseMetadataEndpoint();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclOnCarCmdMetadata::vUninitialiseMetadataEndpoint()
   ***************************************************************************/
   /*!
   * \fn      t_Void vUninitialiseMetadataEndpoint()
   * \brief   Uninitialises an instance of Metadata Endpoint
   * \retval  t_Void
   * \sa      vUninitialiseMetadataEndpoint()
   ***************************************************************************/
   t_Void vUninitialiseMetadataEndpoint();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclOnCarCmdMetadata::DestroyMetadataEndpointInstance()
   ***************************************************************************/
   /*!
   * \fn      t_Void DestroyMetadataEndpointInstance()
   * \brief   Destroys an instance of Metadata Endpoint
   * \retval  t_Void
   * \sa      DestroyMetadataEndpointInstance()
   ***************************************************************************/
   t_Void DestroyMetadataEndpointInstance();

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: spi_tclOnCarCmdMetadata(const spi_tclOnCarCmdMetadata &rfcoCmdMetadata)
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarCmdMetadata(const spi_tclOnCarCmdMetadata &rfcoCmdMetadata)
    * \brief   Copy constructor not implemented hence made private
    **************************************************************************/
   spi_tclOnCarCmdMetadata(const spi_tclOnCarCmdMetadata &rfcoCmdBluetooth);

   /***************************************************************************
    ** FUNCTION: const spi_tclOnCarCmdMetadata & operator=(
    **                      const spi_tclOnCarCmdMetadata &rfcoCmdMetadata);
    ***************************************************************************/
   /*!
    * \fn      const spi_tclOnCarCmdMetadata & operator=(
    *             const spi_tclOnCarCmdMetadata &rfcoCmdMetadata);
    * \brief   assignment operator not implemented hence made private
    **************************************************************************/
   const spi_tclOnCarCmdMetadata & operator=(
            const spi_tclOnCarCmdMetadata &rfcoCmdMetadata);

   //! Metadata Endpoint pointer
   OnCarMetadataEndpoint* m_poOnCarMetadataEndpoint;

   //! shared pointer for OnCar BT callbacks
   std::shared_ptr<IOnCarMediaMetadataCallbacks> m_spoMetadataCbs;

   //! Lock object for Metadata endpoint
   Lock  m_oMetadataEndpointLock;

};

#endif // _SPI_TCLONCARCMDMETADATA_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
