/*!
 *******************************************************************************
 * \file              spi_tclOnCarRespInput.h
 * \brief            OnCar Wrapper Response class for Input
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   OnCar Wrapper Response class for Input
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author                     | Modifications
14.05.2018  | Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLONCARRESPINPUT_H_
#define _SPI_TCLONCARRESPINPUT_H_

#include "SPI_OnCarTypes.h"
#include "RespBase.h"

class spi_tclOnCarRespInput: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarRespInput::spi_tclOnCarRespInput()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarRespInput()
    * \brief   Constructor
    * \sa      spi_tclOnCarRespInput()
    **************************************************************************/
    spi_tclOnCarRespInput(): RespBase(e16ONCAR_INPUT_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarRespInput::~spi_tclOnCarRespInput()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclOnCarRespInput()
    * \brief   Destructor
    * \sa      spi_tclOnCarRespInput()
    **************************************************************************/
   virtual ~spi_tclOnCarRespInput() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespInput::vPostNotifyErrorRequest()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostNotifyErrorRequest()
    * \brief   Called to notify about error cases.
    *          Mandatory interface to be implemented.
    * \param   [IN] enOnCarSinkError: Error code
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostNotifyErrorRequest(tenOnCarSinkError enOnCarSinkError) = 0;

};

#endif /* _SPI_TCLAAPRESPBLUETOOTH_H_ */
