/***********************************************************************/
/*!
 * \file  spi_tclOnCarInputDispatcher.h
 * \brief Message Dispatcher for Input Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Input Messages
 AUTHOR:         Rishav Sardar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 14.05.2018  | Rishav Sardar         | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLONCARINPUTDISPATCHER_H_
#define _SPI_TCLONCARINPUTDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPI_OnCarTypes.h"

/**************Forward Declarations******************************************/
class spi_tclOnCarInputDispatcher;

/****************************************************************************/
/*!
 * \class OnCarInputMsgBase
 * \brief Base Message type for all BT messages
 ****************************************************************************/
class OnCarInputMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  OnCarInputMsgBase::OnCarInputMsgBase
    ***************************************************************************/
   /*!
    * \fn      OnCarInputMsgBase()
    * \brief   Default constructor
    **************************************************************************/
    OnCarInputMsgBase();

   /***************************************************************************
    ** FUNCTION:  OnCarInputMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclOnCarInputDispatcher* poInputDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poBTDispatcher : pointer to Message dispatcher for BT
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclOnCarInputDispatcher* poInputDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  OnCarInputMsgBase::~OnCarInputMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~OnCarInputMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OnCarInputMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class OnCarNotifyErrorRequestMsg
 * \brief Notify Error Request msg
 ****************************************************************************/
class OnCarNotifyErrorRequestMsg: public OnCarInputMsgBase
{
   public:

    tenOnCarSinkError enOnCarSinkError;

   /***************************************************************************
    ** FUNCTION:  OnCarNotifyErrorRequestMsg::OnCarNotifyErrorRequestMsg
    ***************************************************************************/
   /*!
    * \fn      OnCarNotifyErrorRequestMsg()
    * \brief   Default constructor
    **************************************************************************/
    OnCarNotifyErrorRequestMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarNotifyErrorRequestMsg::~OnCarNotifyErrorRequestMsg
    ***************************************************************************/
   /*!
    * \fn      ~OnCarNotifyErrorRequestMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OnCarNotifyErrorRequestMsg(){}

   /***************************************************************************
    ** FUNCTION:  OnCarNotifyErrorRequestMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclOnCarInputDispatcher* poInputDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poInputDispatcher : pointer to Message dispatcher for Input
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclOnCarInputDispatcher* poInputDispatcher);

   /***************************************************************************
    ** FUNCTION:  OnCarNotifyErrorRequestMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarNotifyErrorRequestMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclOnCarInputDispatcher
 * \brief Message Dispatcher for BT Messages
 ****************************************************************************/
class spi_tclOnCarInputDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarInputDispatcher::spi_tclOnCarInputDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarInputDispatcher()
    * \brief   Default constructor
    **************************************************************************/
    spi_tclOnCarInputDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarInputDispatcher::~spi_tclOnCarInputDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclOnCarInputDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclOnCarInputDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarInputDispatcher::vHandleInputMsg(OnCarNotifyErrorRequestMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleInputMsg(OnCarNotifyErrorRequestMsg* poInputDispatcher)
    * \brief   Handles Messages of OnCarNotifyErrorRequestMsg type
    * \param   poInputDispatcher : pointer to OnCarBTPairingRequestMsg.
    **************************************************************************/
   t_Void vHandleInputMsg(OnCarNotifyErrorRequestMsg* poInputDispatcher) const;

};

#endif /* _SPI_TCLONCARINPUTDISPATCHER_H_ */
