/*!
 *******************************************************************************
 * \file              spi_tclOnCarInputCbs.h
 * \brief             Input Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Input Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 20.03.2018 |  Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLONCARINPUTCBS_H_
#define _SPI_TCLONCARINPUTCBS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "OnCarInputEndpoint.h"
#include "BaseTypes.h"

/* This class includes a general set of IOnCarInputSourceCallbacks that must be set up for the Input Endpoint */
class spi_tclOnCarInputCbs : public IOnCarInputSourceCallbacks
{
public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarInputCbs::spi_tclOnCarInputCbs()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarInputCbs()
    * \brief   Constructor
    * \sa      ~spi_tclOnCarInputCbs()
    **************************************************************************/
    spi_tclOnCarInputCbs() { }

    /***************************************************************************
     ** FUNCTION:  virtual spi_tclOnCarInputCbs::~spi_tclOnCarInputCbs()
     ***************************************************************************/
    /*!
     * \fn      virtual ~spi_tclOnCarInputCbs()
     * \brief   Destructor
     * \sa      spi_tclOnCarInputCbs()
     **************************************************************************/
    virtual ~spi_tclOnCarInputCbs() {}

    /**********Start of functions overridden from IOnCarInputSourceCallbacks**********/

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarInputCbs::notifyErrorCallback()
    ***************************************************************************/
    /*!
    * Called when an error happens in the underlying layer.
    * The callback is introduced to inform the upper layer about error cases,
    * for which another notification, such as return values, is not possible.
    * @param error Error code
    */
    void notifyErrorCallback(ONCARSINKERROR error);

    /***********End of functions overridden from IOnCarVideoSinkCallbacks**********/


private:

    /***************************************************************************
     ** FUNCTION: spi_tclOnCarInputCbs(const spi_tclOnCarInputCbs &rfcoObject)
     ***************************************************************************/
    /*!
     * \fn      spi_tclOnCarInputCbs(const spi_tclOnCarInputCbs &rfcoObject)
     * \brief   Copy constructor not implemented hence made private
     **************************************************************************/
    spi_tclOnCarInputCbs(const spi_tclOnCarInputCbs& rfcoObject);

    /***************************************************************************
     ** FUNCTION: const spi_tclOnCarInputCbs & operator=(
     **                                 const spi_tclOnCarInputCbs &rfcoObject);
     ***************************************************************************/
    /*!
     * \fn      const spi_tclOnCarInputCbs & operator=(const spi_tclOnCarInputCbs &rfcoObject);
     * \brief   assignment operator not implemented hence made private
     **************************************************************************/
    const spi_tclOnCarInputCbs& operator=(const spi_tclOnCarInputCbs& rfcoObject);
};


#endif /* _SPI_TCLONCARINPUTCBS_H_ */
