/***********************************************************************/
/*!
* \file  spi_tclOnCarDataIntf.cpp
* \brief OnCar Data Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    OnCar Data Interface
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
20.03.2018  | Unmukt Jain           | Initial Version
\endverbatim
**************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "spi_tclOnCarDataIntf.h"
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)//for unit testing
  #include "Mock_OnCarObjectFactory.h"
#else
  #include "DynamicLibHandler.h"
#endif
#include "OnCarAPI.h"
#include "OnCarEndPointBase.h"
#include "OnCarAudioSinkEndpoint.h"
#include "OnCarBluetoothEndpoint.h"
#include "OnCarInputEndpoint.h"
#include "OnCarMetadataEndpoint.h"
#include "OnCarSensorEndpoint.h"
#include "OnCarVideoEndpoint.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
      #include "trcGenProj/Header/spi_tclOnCarDataIntf.cpp.trc.h"
   #endif
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported  
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
** FUNCTION:  spi_tclOnCarDataIntf::spi_tclOnCarDataIntf()
***************************************************************************/
spi_tclOnCarDataIntf::spi_tclOnCarDataIntf():m_poOnCarAPI(NULL)
{
   ETG_TRACE_USR1(("spi_tclOnCarDataIntf::spi_tclOnCarDataIntf entered"));
}

/***************************************************************************
** FUNCTION:  spi_tclAAPSessionDataIntf::~spi_tclAAPSessionDataIntf()
***************************************************************************/
spi_tclOnCarDataIntf::~spi_tclOnCarDataIntf()
{
   ETG_TRACE_USR1(("spi_tclOnCarDataIntf::~spi_tclOnCarDataIntf entered"));
}

/***************************************************************************
 ** FUNCTION:  OnCarAPI* spi_tclOnCarDataIntf::poGetOnCarAPIInstance()
 ***************************************************************************/
OnCarAPI* spi_tclOnCarDataIntf::poGetOnCarAPIInstance()
{
   ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetOnCarAPIInstance entered"));

   if(NULL == m_poOnCarAPI)
   {
       ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetOnCarAPIInstance creating new OnCarAPI instance"));
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
       m_poOnCarAPI = static_cast<OnCarAPI*>(createInstanceOf(eONCAR_OBJECTFACTORY_ONCARAPI));
#else
       DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
       t_Void *vpoFunc = NULL;
       if( oDynamicLibHandler.u32GetSymbol("createInstanceOf",&vpoFunc) > 0 )
       {
           fvCreateInstanceOf createInstanceOf = (fvCreateInstanceOf)vpoFunc;
           vpoFunc = NULL;
           m_poOnCarAPI = static_cast<OnCarAPI*>(createInstanceOf(e8_ONCAR_OBJECTFACTORY_ONCARAPI));
       }
#endif
     
   }
   return m_poOnCarAPI;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarDataIntf::vDestroyOnCarAPIInstance()
 ***************************************************************************/
t_Void spi_tclOnCarDataIntf::vDestroyOnCarAPIInstance()
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::vDestroyOnCarAPIInstance entered"));
    if(NULL != m_poOnCarAPI)
    {
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
        destroyInstance((void*)m_poOnCarAPI,eONCAR_OBJECTFACTORY_ONCARAPI);
        m_poOnCarAPI = NULL;
#else
        DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
        t_Void *vpoFunc = NULL;
        if( oDynamicLibHandler.u32GetSymbol("destroyInstance",&vpoFunc) > 0 )
        {
            fvDestroyInstance destroyInstance = (fvDestroyInstance)vpoFunc;
            vpoFunc = NULL;
            destroyInstance(m_poOnCarAPI,e8_ONCAR_OBJECTFACTORY_ONCARAPI);
            m_poOnCarAPI = NULL;
        }
#endif
    }
}

/***************************************************************************
 ** FUNCTION:  OnCarAudioSinkEndpoint spi_tclOnCarDataIntf::poGetAudioEndpointInstance()
 ***************************************************************************/
OnCarAudioSinkEndpoint* spi_tclOnCarDataIntf::poGetAudioEndpointInstance()
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetAudioEndpointInstance entered"));
    OnCarAudioSinkEndpoint *poEndpoint = NULL;
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
    poEndpoint = static_cast<OnCarAudioSinkEndpoint*>(createInstanceOf(eONCAR_OBJECTFACTORY_AUDIO_ENDPOINT));
#else
    DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
    t_Void *vpoFunc = NULL;
    if( oDynamicLibHandler.u32GetSymbol("createInstanceOf",&vpoFunc) > 0 )
    {
        fvCreateInstanceOf createInstanceOf = (fvCreateInstanceOf)vpoFunc;
        vpoFunc = NULL;
        poEndpoint = static_cast<OnCarAudioSinkEndpoint*>(createInstanceOf(e8_ONCAR_OBJECTFACTORY_AUDIO_ENDPOINT));
    }
#endif
    return poEndpoint;
}

/***************************************************************************
 ** FUNCTION:  OnCarVideoEndpoint spi_tclOnCarDataIntf::poGetVideoEndpointInstance()
 ***************************************************************************/
OnCarVideoEndpoint* spi_tclOnCarDataIntf::poGetVideoEndpointInstance()
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetVideoEndpointInstance entered"));
    OnCarVideoEndpoint *poEndpoint = NULL;
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
    poEndpoint = static_cast<OnCarVideoEndpoint*>(createInstanceOf(eONCAR_OBJECTFACTORY_VIDEO_ENDPOINT));
#else
    DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
    t_Void *vpoFunc = NULL;
    if( oDynamicLibHandler.u32GetSymbol("createInstanceOf",&vpoFunc) > 0 )
    {
        fvCreateInstanceOf createInstanceOf = (fvCreateInstanceOf)vpoFunc;
        vpoFunc = NULL;
        poEndpoint = static_cast<OnCarVideoEndpoint*>(createInstanceOf(e8_ONCAR_OBJECTFACTORY_VIDEO_ENDPOINT));
    }
#endif
    return poEndpoint;
}

/***************************************************************************
 ** FUNCTION:  OnCarBluetoothEndpoint spi_tclOnCarDataIntf::poGetBluetoothEndpointInstance()
 ***************************************************************************/
OnCarBluetoothEndpoint* spi_tclOnCarDataIntf::poGetBluetoothEndpointInstance()
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetBluetoothEndpointInstance entered"));
    OnCarBluetoothEndpoint *poEndpoint = NULL;
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
    poEndpoint = static_cast<OnCarBluetoothEndpoint*>(createInstanceOf(eONCAR_OBJECTFACTORY_BLUETOOTH_ENDPOINT));
#else
    DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
    t_Void *vpoFunc = NULL;
    if( oDynamicLibHandler.u32GetSymbol("createInstanceOf",&vpoFunc) > 0 )
    {
        fvCreateInstanceOf createInstanceOf = (fvCreateInstanceOf)vpoFunc;
        vpoFunc = NULL;
        poEndpoint = static_cast<OnCarBluetoothEndpoint*>(createInstanceOf(e8_ONCAR_OBJECTFACTORY_BLUETOOTH_ENDPOINT));
    }
#endif
    return poEndpoint;
}

/***************************************************************************
 ** FUNCTION:  OnCarMetadataEndpoint spi_tclOnCarDataIntf::poGetMetadataEndpointInstance()
 ***************************************************************************/
OnCarMetadataEndpoint* spi_tclOnCarDataIntf::poGetMetadataEndpointInstance()
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetMetadataEndpointInstance entered"));
    OnCarMetadataEndpoint *poEndpoint = NULL;
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
    poEndpoint = static_cast<OnCarMetadataEndpoint*>(createInstanceOf(eONCAR_OBJECTFACTORY_METADATA_ENDPOINT));
#else
    DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
    t_Void *vpoFunc = NULL;
    if( oDynamicLibHandler.u32GetSymbol("createInstanceOf",&vpoFunc) > 0 )
    {
        fvCreateInstanceOf createInstanceOf = (fvCreateInstanceOf)vpoFunc;
        vpoFunc = NULL;
        poEndpoint = static_cast<OnCarMetadataEndpoint*>(createInstanceOf(e8_ONCAR_OBJECTFACTORY_METADATA_ENDPOINT));
    }
#endif
    return poEndpoint;
}

/***************************************************************************
 ** FUNCTION:  OnCarInputEndpoint spi_tclOnCarDataIntf::poGetInputEndpointInstance()
 ***************************************************************************/
OnCarInputEndpoint* spi_tclOnCarDataIntf::poGetInputEndpointInstance()
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetInputEndpointInstance entered"));
    OnCarInputEndpoint *poEndpoint = NULL;
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
    poEndpoint = static_cast<OnCarInputEndpoint*>(createInstanceOf(eONCAR_OBJECTFACTORY_INPUT_ENDPOINT));
#else
    DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
    t_Void *vpoFunc = NULL;
    if( oDynamicLibHandler.u32GetSymbol("createInstanceOf",&vpoFunc) > 0 )
    {
        fvCreateInstanceOf createInstanceOf = (fvCreateInstanceOf)vpoFunc;
        vpoFunc = NULL;
        poEndpoint = static_cast<OnCarInputEndpoint*>(createInstanceOf(e8_ONCAR_OBJECTFACTORY_INPUT_ENDPOINT));
    }
#endif
    return poEndpoint;
}

/***************************************************************************
 ** FUNCTION:  OnCarSensorEndpoint spi_tclOnCarDataIntf::poGetSensorEndpointInstance()
 ***************************************************************************/
OnCarSensorEndpoint* spi_tclOnCarDataIntf::poGetSensorEndpointInstance()
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::poGetSensorEndpointInstance entered"));
    OnCarSensorEndpoint *poEndpoint = NULL;
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
    poEndpoint = static_cast<OnCarSensorEndpoint*>(createInstanceOf(eONCAR_OBJECTFACTORY_SENSOR_ENDPOINT));
#else
    DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
    t_Void *vpoFunc = NULL;
    if( oDynamicLibHandler.u32GetSymbol("createInstanceOf",&vpoFunc) > 0 )
    {
        fvCreateInstanceOf createInstanceOf = (fvCreateInstanceOf)vpoFunc;
        vpoFunc = NULL;
        poEndpoint = static_cast<OnCarSensorEndpoint*>(createInstanceOf(e8_ONCAR_OBJECTFACTORY_SENSOR_ENDPOINT));
    }
#endif
    return poEndpoint;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarDataIntf::vDestroyEndpointInstance()
 ***************************************************************************/
t_Void spi_tclOnCarDataIntf::vDestroyEndpointInstance(OnCarEndPointBase *poEndpoint, tenOnCarObjectFactory id)
{
    ETG_TRACE_USR1(("spi_tclOnCarDataIntf::vDestroyEndpointInstance entered id = %d",id));
    if(NULL != poEndpoint)
    {
#if defined( _LINUXX86MAKE_) || defined(_LINUXX86_64_)
        destroyInstance((void*)poEndpoint,static_cast<ONCAR_OBJECTFACTORY>(id));
#else
        DynamicLibHandler oDynamicLibHandler(scoszOnCarLibPath);
        t_Void *vpoFunc = NULL;
        if( oDynamicLibHandler.u32GetSymbol("destroyInstance",&vpoFunc) > 0 )
        {
            fvDestroyInstance destroyInstance = (fvDestroyInstance)vpoFunc;
            vpoFunc = NULL;
            destroyInstance(poEndpoint,id);
        }
#endif
    }
}
//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>
