/***********************************************************************/
/*!
 * \file  spi_tclOnCarMsgQInterface.h
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for OnCar Wrapper
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
 threading model for OnCar Wrapper
 AUTHOR:         jun5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 05.02.2018  | Unmukt Jain           | Initial version


 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLONCARMSGQINTERFACE_H_
#define SPI_TCLONCARMSGQINTERFACE_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "MsgQThreader.h"
#include "spi_tclOnCarMsgQThreadable.h"
#include "GenericSingleton.h"

using namespace shl::thread;

/****************************************************************************/
/*!
 * \class spi_tclOnCarMsgQInterface
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for OnCar Wrapper
 ****************************************************************************/
class spi_tclOnCarMsgQInterface: public GenericSingleton<spi_tclOnCarMsgQInterface>
{
   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarMsgQInterface::spi_tclOnCarMsgQInterface()
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarMsgQInterface()
       * \brief   Default Constructor
       * \sa      ~spi_tclOnCarMsgQInterface()
       **************************************************************************/
       spi_tclOnCarMsgQInterface();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarMsgQInterface::~spi_tclOnCarMsgQInterface()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclOnCarMsgQInterface()
       * \brief   Destructor
       * \sa      spi_tclOnCarMsgQInterface()
       **************************************************************************/
      ~spi_tclOnCarMsgQInterface();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarMsgQInterface::bWriteMsgToQ
       ***************************************************************************/
      /*!
       * \fn      bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
       * \brief   Write Msg to Q for dispatching the message by a seperate thread
       * \param prMsgBase : Pointer to Base Message type
       * \param u32MsgSize :  size of the message to be written to the MsgQ
       * \retval t_Bool
       **************************************************************************/
      t_Bool bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclOnCarMsgQInterface> ;

   private:

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarMsgQInterface(const spi_tclOnCarMsgQInterface...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarMsgQInterface(const spi_tclOnCarMsgQInterface& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarMsgQInterface()
       ***************************************************************************/
      spi_tclOnCarMsgQInterface(const spi_tclOnCarMsgQInterface& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarMsgQInterface& operator=( const spi_tclOnCarMsgQInterface...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarMsgQInterface& operator=(const spi_tclOnCarMsgQInterface& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarMsgQInterface(const spi_tclOnCarMsgQInterface& otrSrc)
       ***************************************************************************/
      spi_tclOnCarMsgQInterface& operator=(const spi_tclOnCarMsgQInterface& corfoSrc);

      //! Pointer to the overridden MsgQThreadable class
      spi_tclOnCarMsgQThreadable *m_poOnCarMsgQThreadable;

      //! pointer to MsgQThreader
      MsgQThreader *m_poOnCarMsgQThreader;

};

#endif /* SPI_TCLONCARMSGQINTERFACE_H_ */
