/***********************************************************************/
/*!
 * \file  spi_tclOnCarManager.h
 * \brief  Implementation of the Class spi_tclOnCarManager
 *************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         jun5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 01.02.2018  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLONCARMANAGER_H_
#define _SPI_TCLONCARMANAGER_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "GenericSingleton.h"
#include "spi_tclOnCarCmdSession.h"
#include "spi_tclOnCarCmdBluetooth.h"
#include "spi_tclOnCarCmdVideo.h"
#include "spi_tclOnCarCmdAudio.h"
#include "spi_tclOnCarCmdInput.h"
#include "spi_tclOnCarCmdMetadata.h"
#include "spi_tclOnCarCmdSensor.h"
#include "RespRegister.h"
//#include "spi_tclMySPINCmdVehicleData.h"

//#include "spi_tclAOAPCmdDiscoverer.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclOnCarManager
 * \brief Manager class  to provide interface for SPI to interact with
 *        OnCarWrapper classes
 *
 */

class spi_tclOnCarManager: public GenericSingleton<spi_tclOnCarManager>
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclOnCarManager::~spi_tclOnCarManager()
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclOnCarManager()
       * \brief Destructor for spi_tclOnCarManager class
       **************************************************************************/
      virtual ~spi_tclOnCarManager();

      /***************************************************************************
       ** FUNCTION: spi_tclOnCarManager::spi_tclOnCarCmdAudio* poGetAudioInstance()
       **************************************************************************
      !
       * \fn    spi_tclOnCarCmdAudio* poGetAudioInstance()
       * \brief Method for getting audio instance
       *************************************************************************/
      spi_tclOnCarCmdAudio* poGetAudioInstance();

      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::spi_tclOnCarCmdInput* poGetInputInstance()
       *************************************************************************
       * \fn    spi_tclOnCarCmdInput* poGetInputInstance()
       * \brief Method to get input instance
       * \retval spi_tclOnCarCmdInput*
       *************************************************************************/
      spi_tclOnCarCmdInput* poGetInputInstance();

      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::spi_tclOnCarCmdSession* poGetSessionInstance()
       **************************************************************************
       * \fn    spi_tclOnCarCmdSession* poGetSessionInstance()
       * \brief Method to get session instance
       * \retval spi_tclOnCarCmdSession*
       *************************************************************************/
      spi_tclOnCarCmdSession* poGetSessionInstance();

      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::spi_tclOnCarCmdBluetooth* poGetBluetoothInstance()
       **************************************************************************
       * \fn    spi_tclOnCarCmdBluetooth* poGetBluetoothInstance()
       * \brief Method to get BT instance
       * \retval spi_tclOnCarCmdBluetooth*
       *************************************************************************/
      spi_tclOnCarCmdBluetooth* poGetBluetoothInstance();

      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::spi_tclOnCarCmdVideo* poGetVideoInstance()
       **************************************************************************
       * \fn    spi_tclOnCarCmdVideo* poGetVideoInstance()
       * \brief Method to get the video instance
       * \retval spi_tclOnCarCmdVideo*
       *************************************************************************/
      spi_tclOnCarCmdVideo* poGetVideoInstance();

      /**************************************************************************
      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::spi_tclOnCarCmdMetadata* poGetMetadataInstance()
       **************************************************************************
       * \fn    spi_tclOnCarCmdMetadata* poGetMetadataInstance()
       * \brief Method to get the metadata instance
       * \retval spi_tclOnCarCmdMetadata*
       *************************************************************************/
      spi_tclOnCarCmdMetadata* poGetMetadataInstance();

      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::spi_tclOnCarCmdSensor* poGetSensorInstance()
       **************************************************************************
       * \fn    spi_tclOnCarCmdSensor* poGetSensorInstance()
       * \brief Method to get the Sensor instance
       * \retval spi_tclOnCarCmdSensor*
       *************************************************************************/
      spi_tclOnCarCmdSensor* poGetSensorInstance();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclMySPINCmdVehicleData* poGetVehDataInstance()
       **************************************************************************
      !
       * \fn    spi_tclMySPINCmdVehicleData* poGetVehDataInstance();
       * \brief Method to get vehicle data instance
       * \retval spi_tclMySPINCmdVehicleData
       *************************************************************************
      spi_tclMySPINCmdVehicleData* poGetVehDataInstance();*/

      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::t_Bool bRegisterObject(...)
       **************************************************************************
      /*!
       * \fn    t_Bool bRegisterObject(RespBase *poRespBase)
       * \brief Method to register an object
       * \param poRespBase: [IN]
       * \ret   t_Bool
       *************************************************************************/
      t_Bool bRegisterObject(RespBase *poRespBase);

      /**************************************************************************
       ** FUNCTION: spi_tclOnCarManager::t_Bool bUnRegisterObject(...)
       **************************************************************************
      /*!
       * \fn    t_Bool bUnRegisterObject(RespBase *poRespBase)
       * \brief Method to unregister an object
       * \param poRespBase: [IN]
       * \ret   t_Bool
       *************************************************************************/
      t_Bool bUnRegisterObject(RespBase *poRespBase);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclOnCarManager> ;

   private:

    /***************************************************************************
       ** FUNCTION:  spi_tclOnCarManager(const spi_tclOnCarManager...
       ***************************************************************************/
      /*!
       * \fn    spi_tclOnCarManager()
       * \brief Constructor of spi_tclOnCarManager class
       **************************************************************************/
      spi_tclOnCarManager();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarManager(const spi_tclOnCarManager...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarManager(const spi_tclOnCarManager& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarManager()
       ***************************************************************************/
       spi_tclOnCarManager(const spi_tclOnCarManager& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarManager& operator=( const spi_tclOnCarManager...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarManager& operator=(const spi_tclOnCarManager& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclAAPManager(const spi_tclOnCarManager& otrSrc)
       ***************************************************************************/
       spi_tclOnCarManager& operator=(const spi_tclOnCarManager& corfoSrc);

      //! Session command class pointer
      spi_tclOnCarCmdSession      *m_poCmdSession;

      //! Bluetooth command class pointer
      spi_tclOnCarCmdBluetooth    *m_poCmdBluetooth;

      //! Video command class pointer
      spi_tclOnCarCmdVideo        *m_poCmdVideo;

      //! Audio command class pointer
      spi_tclOnCarCmdAudio        *m_poCmdAudio;

      //! Input command class pointer
      spi_tclOnCarCmdInput        *m_poCmdInput;

      //! Metadata command class pointer
      spi_tclOnCarCmdMetadata      *m_poCmdMetadata;
  
      //! Sensor command class pointer
      spi_tclOnCarCmdSensor        *m_poCmdSensor;
};
#endif /* _SPI_TCLONCARMANAGER_H_ */
