
/***********************************************************************/
/*!
* \file  spi_tclOnCarDataIntf.h
* \brief OnCar Data Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    OnCar Data Interface
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
20.03.2018  | Unmukt Jain           | Initial Version

\endverbatim
**************************************************************************/

#ifndef _SPI_TCLONCARDATAINTF_H_
#define _SPI_TCLONCARDATAINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "GenericSingleton.h"
#include "BaseTypes.h"
#include "OnCarTypes.h"
#include "SPI_OnCarTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
class OnCarAPI;
class OnCarEndPointBase;
class OnCarAudioSinkEndpoint;
class OnCarVideoEndpoint;
class OnCarBluetoothEndpoint;
class OnCarMetadataEndpoint;
class OnCarInputEndpoint;
class OnCarSensorEndpoint;

/****************************************************************************/
/*!
* \class spi_tclOnCarDataIntf
* \brief OnCar Data Interface
*
* It provides an interface to get the OnCarAPI and endpoint instances.
****************************************************************************/

class spi_tclOnCarDataIntf : public GenericSingleton<spi_tclOnCarDataIntf>
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarDataIntf::~spi_tclOnCarDataIntf()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclOnCarDataIntf()
    * \brief   Destructor
    * \param
    * \sa      spi_tclOnCarDataIntf()
    **************************************************************************/
    ~spi_tclOnCarDataIntf();

    /***************************************************************************
    ** FUNCTION:  OnCarAPI* spi_tclOnCarDataIntf::poGetOnCarAPIInstance();
    ***************************************************************************/
    /*!
    * \fn      OnCarAPI* poGetOnCarAPIInstance()
    * \brief   Provides OnCarAPI pointer to other components
    * \retval  OnCarAPI*  : Pointer to OnCarAPI. To be used by other OnCar
    *          classes for creating and registering endpoints.
    **************************************************************************/
    OnCarAPI* poGetOnCarAPIInstance();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarDataIntf::vDestroyOnCarAPIInstance();
    ***************************************************************************/
    /*!
    * \fn      t_Void vDestroyOnCarAPIInstance()
    * \brief   destroys OnCarAPI Instance.
    **************************************************************************/
    t_Void vDestroyOnCarAPIInstance();

    /***************************************************************************
    ** FUNCTION:  OnCarAudioSinkEndpoint* spi_tclOnCarDataIntf::poGetAudioEndpointInstance();
    ***************************************************************************/
    /*!
    * \fn      OnCarAudioSinkEndpoint* poGetAudioEndpointInstance()
    * \brief   creates the oncar audio endpoint returns its instance.
    **************************************************************************/
    OnCarAudioSinkEndpoint* poGetAudioEndpointInstance();

    /***************************************************************************
    ** FUNCTION:  OnCarVideoEndpoint* spi_tclOnCarDataIntf::poGetVideoEndpointInstance();
    ***************************************************************************/
    /*!
    * \fn      OnCarVideoEndpoint* poGetVideoEndpointInstance()
    * \brief   creates the oncar video endpoint returns its instance.
    **************************************************************************/
    OnCarVideoEndpoint* poGetVideoEndpointInstance();

    /***************************************************************************
    ** FUNCTION:  OnCarBluetoothEndpoint* spi_tclOnCarDataIntf::poGetBluetoothEndpointInstance();
    ***************************************************************************/
    /*!
    * \fn      OnCarBluetoothEndpoint* poGetBluetoothEndpointInstance()
    * \brief   creates the oncar bluetooth endpoint returns its instance.
    **************************************************************************/
    OnCarBluetoothEndpoint* poGetBluetoothEndpointInstance();

    /***************************************************************************
    ** FUNCTION:  OnCarMetadataEndpoint* spi_tclOnCarDataIntf::poGetMetadataEndpointInstance();
    ***************************************************************************/
    /*!
    * \fn      OnCarMetadataEndpoint* poGetMetadataEndpointInstance()
    * \brief   creates the oncar metadata endpoint returns its instance.
    **************************************************************************/
    OnCarMetadataEndpoint* poGetMetadataEndpointInstance();

    /***************************************************************************
    ** FUNCTION:  OnCarInputEndpoint* spi_tclOnCarDataIntf::poGetInputEndpointInstance();
    ***************************************************************************/
    /*!
    * \fn      OnCarInputEndpoint* poGetInputEndpointInstance()
    * \brief   creates the oncar input endpoint returns its instance.
    **************************************************************************/
    OnCarInputEndpoint* poGetInputEndpointInstance();

    /***************************************************************************
    ** FUNCTION:  OnCarSensorEndpoint* spi_tclOnCarDataIntf::poGetSensorEndpointInstance();
    ***************************************************************************/
    /*!
    * \fn      OnCarSensorEndpoint* poGetSensorEndpointInstance()
    * \brief   creates the oncar sensor endpoint returns its instance.
    **************************************************************************/
    OnCarSensorEndpoint* poGetSensorEndpointInstance();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarDataIntf::vDestroyEndpointInstance();
    ***************************************************************************/
    /*!
    * \fn      t_Void vDestroyEndpointInstance()
    * \brief  destroy the oncar endpoint based on endpoint id.
    * \param  poEndpoint: pointer to Oncar endpoint
    * \param   id: enumeration of ONCAR_OBJECTFACTORY
    **************************************************************************/
    t_Void vDestroyEndpointInstance(OnCarEndPointBase *poEndpoint, tenOnCarObjectFactory id);

    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarDataIntf(const spi_tclOnCarDataIntf...
    ***************************************************************************/
    /*!
    * \fn      spi_tclOnCarDataIntf(const spi_tclOnCarDataIntf& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \retval
    * \sa      spi_tclOnCarDataIntf()
    ***************************************************************************/
    spi_tclOnCarDataIntf(const spi_tclOnCarDataIntf& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarDataIntf& operator=( const spi_tclMLV...
    ***************************************************************************/
    /*!
    * \fn      spi_tclOnCarDataIntf& operator=(const spi_tclOnCarDataIntf& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \retval
    * \sa      spi_tclOnCarDataIntf(const spi_tclOnCarDataIntf& otrSrc)
    ***************************************************************************/
    spi_tclOnCarDataIntf& operator=(const spi_tclOnCarDataIntf& otrSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/

    friend class GenericSingleton<spi_tclOnCarDataIntf>;

    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarDataIntf::spi_tclOnCarDataIntf()
    ***************************************************************************/
    /*!
    * \fn      spi_tclOnCarDataIntf()
    * \brief   Constructor
    * \param
    * \sa      ~spi_tclOnCarDataIntf()
    **************************************************************************/
    spi_tclOnCarDataIntf();

    OnCarAPI *m_poOnCarAPI;

    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/

};// class spi_tclAAPSessionDataIntf


#endif   //_SPI_TCLONCARDATAINTF_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
