/*!
 *******************************************************************************
 * \file              spi_tclOnCarBluetoothCbs.cpp
 * \brief             BT Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    BT Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI
 AUTHOR:         irh1kor
 HISTORY:
 Date       |  Author                      | Modifications
 12.03.2018 |  Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclOnCarMsgQInterface.h"
#include "spi_tclOnCarBTDispatcher.h"
#include "spi_tclOnCarBluetoothCbs.h"

//! Includes for Trace files
#include "Trace.h"
#include <algorithm>
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarBluetoothCbs.cpp.trc.h"
#endif
#endif


/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarBluetoothCbs::onBTPairingRequestCallback(...)
***************************************************************************/
void spi_tclOnCarBluetoothCbs::onBTPairingRequestCallback(const string &btAddress, BTPAIRING_METHOD btPairingMethod)
{
    ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarBluetoothCbs::onBTPairingRequestCallback() entered "));
    ETG_TRACE_USR2(("[DESC]:Bluetooth Pairing Request received with PairingMethod = %d, BTAddress = %s ",
         btPairingMethod, btAddress.c_str()));
    spi_tclOnCarMsgQInterface* poMsgQInterface = spi_tclOnCarMsgQInterface::getInstance();
    t_String szBTAddress = btAddress.c_str();
    if(false == szBTAddress.empty())
    {
        szBTAddress.erase(std::remove(szBTAddress.begin(), szBTAddress.end(), ':'), szBTAddress.end());
        std::transform(szBTAddress.begin(), szBTAddress.end(), szBTAddress.begin(), ::toupper);
    }//if(false == szBTAddress.empty())
    if ((poMsgQInterface) && (false == szBTAddress.empty()))
    {
        OnCarBTPairingRequestMsg oPairingReqMsg;
        if (oPairingReqMsg.poszOnCarBTAddress)
        {
            t_String szOnCarBTAddr = szBTAddress.c_str();
            ETG_TRACE_USR4(("[PARAM]::onPairingRequest - OnCarBTAddress = %s ", szOnCarBTAddr.c_str()));
            *(oPairingReqMsg.poszOnCarBTAddress) = szOnCarBTAddr;
        }//if (oPairingReqMsg.poszOnCarBTAddress)
        oPairingReqMsg.enOnCarPairingMethod = static_cast<tenOnCarBTPairingMethod>(btPairingMethod);
        poMsgQInterface->bWriteMsgToQ(&oPairingReqMsg, sizeof(oPairingReqMsg));
    }//if ((poMsgQInterface) && (false == szBTAddress.empty()))
    ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarBluetoothCbs::onBTPairingRequestCallback() left "));
}//!end of onBTPairingRequestCallback()


