/***********************************************************************/
/*!
 * \file  spi_tclOnCarBTDispatcher.cpp
 * \brief Message Dispatcher for Bluetooth Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Bluetooth Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 23.02.2018  | Unmukt Jain           | Initial Version
 12.03.2018  | Rishav Sardar         | Message Dispatch Mechanism for BT

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclOnCarBTDispatcher.h"
#include "spi_tclOnCarRespBluetooth.h"
#include "RespRegister.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclOnCarBTDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleBTMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  OnCarBTMsgBase::OnCarBTMsgBase
 ***************************************************************************/
OnCarBTMsgBase::OnCarBTMsgBase()
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarBTMsgBase::OnCarBTMsgBase() entered "));
   vSetServiceID(e32MODULEID_ONCARBLUETOOTH);
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarBTMsgBase::OnCarBTMsgBase() left "));
}//!end of onBTPairingRequestCallback()

/***************************************************************************
 ** FUNCTION:  OnCarBTPairingRequestMsg::OnCarBTPairingRequestMsg
 ***************************************************************************/
OnCarBTPairingRequestMsg::OnCarBTPairingRequestMsg():
      poszOnCarBTAddress(NULL),
      enOnCarPairingMethod(scenPreferredOnCarBTPairingMethod)
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarBTPairingRequestMsg::OnCarBTPairingRequestMsg() entered "));
   vAllocateMsg();
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarBTPairingRequestMsg::OnCarBTPairingRequestMsg() left "));
}//!end of OnCarBTPairingRequestMsg()

/***************************************************************************
 ** FUNCTION:  OnCarBTPairingRequestMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarBTPairingRequestMsg, spi_tclOnCarBTDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarBTPairingRequestMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarBTPairingRequestMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarBTPairingRequestMsg::vAllocateMsg() entered "));
   poszOnCarBTAddress = new t_String;
   SPI_NORMAL_ASSERT(NULL == poszOnCarBTAddress);
   ETG_TRACE_USR1(("[FUNC]:OnCarBTPairingRequestMsg::vAllocateMsg() entered "));
}//!end of vAllocateMsg()

/***************************************************************************
 ** FUNCTION:  OnCarBTPairingRequestMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarBTPairingRequestMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarBTPairingRequestMsg::vDeAllocateMsg() entered "));
   RELEASE_MEM(poszOnCarBTAddress);
   ETG_TRACE_USR1(("[FUNC]:OnCarBTPairingRequestMsg::vDeAllocateMsg() left "));
}//!end of vDeAllocateMsg()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarBTDispatcher::spi_tclOnCarBTDispatcher
 ***************************************************************************/
spi_tclOnCarBTDispatcher::spi_tclOnCarBTDispatcher()
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarBTDispatcher::spi_tclOnCarBTDispatcher() entered "));
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarBTDispatcher::spi_tclOnCarBTDispatcher() left "));
}//!end of spi_tclOnCarBTDispatcher()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarBTDispatcher::~spi_tclOnCarBTDispatcher
 ***************************************************************************/
spi_tclOnCarBTDispatcher::~spi_tclOnCarBTDispatcher()
{
   ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarBTDispatcher::~spi_tclOnCarBTDispatcher() entered "));
   ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarBTDispatcher::~spi_tclOnCarBTDispatcher() left "));
}//!end of ~spi_tclOnCarBTDispatcher()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarBTDispatcher::vHandleBTMsg(OnCarBTPairingRequestMsg...)
 ***************************************************************************/
t_Void spi_tclOnCarBTDispatcher::
      vHandleBTMsg(OnCarBTPairingRequestMsg* poBTPairingRequest)const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarBTDispatcher::vHandleBTMsg() entered "));
   if ((poBTPairingRequest) && (poBTPairingRequest->poszOnCarBTAddress))
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespBluetooth,
         e16ONCAR_BLUETOOTH_REGID,
         vPostBTPairingRequest(*(poBTPairingRequest->poszOnCarBTAddress),
               poBTPairingRequest->enOnCarPairingMethod));
   }//if ((poBTPairingRequest) && (poBTPairingRequest->poszOnCarBTAddress))
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarBTDispatcher::vHandleBTMsg() left "));
}//!end of vHandleBTMsg()

// <EOF>
