/***********************************************************************/
/*!
 * \file  spi_tclOnCarBTDispatcher.h
 * \brief Message Dispatcher for Bluetooth Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Bluetooth Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 23.02.2018  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLONCARBTDISPATCHER_H_
#define _SPI_TCLONCARBTDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPI_OnCarTypes.h"

/**************Forward Declarations******************************************/
class spi_tclOnCarBTDispatcher;

/****************************************************************************/
/*!
 * \class OnCarBTMsgBase
 * \brief Base Message type for all BT messages
 ****************************************************************************/
class OnCarBTMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  OnCarBTMsgBase::OnCarBTMsgBase
    ***************************************************************************/
   /*!
    * \fn      OnCarBTMsgBase()
    * \brief   Default constructor
    **************************************************************************/
    OnCarBTMsgBase();

   /***************************************************************************
    ** FUNCTION:  OnCarBTMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclOnCarBTDispatcher* poBTDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poBTDispatcher : pointer to Message dispatcher for BT
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclOnCarBTDispatcher* poBTDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  OnCarBTMsgBase::~OnCarBTMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~OnCarBTMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OnCarBTMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class OnCatBTPairingRequestMsg
 * \brief BT Pairing Request msg
 ****************************************************************************/
class OnCarBTPairingRequestMsg: public OnCarBTMsgBase
{
   public:

   t_String* poszOnCarBTAddress;
   tenOnCarBTPairingMethod enOnCarPairingMethod;

   /***************************************************************************
    ** FUNCTION:  OnCarBTPairingRequestMsg::OnCarBTPairingRequestMsg
    ***************************************************************************/
   /*!
    * \fn      OnCarBTPairingRequestMsg()
    * \brief   Default constructor
    **************************************************************************/
   OnCarBTPairingRequestMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarBTPairingRequestMsg::~OnCarBTPairingRequestMsg
    ***************************************************************************/
   /*!
    * \fn      ~OnCarBTPairingRequestMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OnCarBTPairingRequestMsg(){}

   /***************************************************************************
    ** FUNCTION:  OnCarBTPairingRequestMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclOnCarBTDispatcher* poBTDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBTDispatcher : pointer to Message dispatcher for BT
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclOnCarBTDispatcher* poBTDispatcher);

   /***************************************************************************
    ** FUNCTION:  OnCarBTPairingRequestMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarBTPairingRequestMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclOnCarBTDispatcher
 * \brief Message Dispatcher for BT Messages
 ****************************************************************************/
class spi_tclOnCarBTDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarBTDispatcher::spi_tclOnCarBTDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarBTDispatcher()
    * \brief   Default constructor
    **************************************************************************/
    spi_tclOnCarBTDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarBTDispatcher::~spi_tclOnCarBTDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclOnCarBTDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclOnCarBTDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarBTDispatcher::vHandleBTMsg(OnCarBTPairingRequestMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBTMsg(OnCarBTPairingRequestMsg* poBTPairingRequest)
    * \brief   Handles Messages of OnCarBTPairingRequestMsg type
    * \param   poBTPairingRequest : pointer to OnCarBTPairingRequestMsg.
    **************************************************************************/
   t_Void vHandleBTMsg(OnCarBTPairingRequestMsg* poBTPairingRequest) const;

};

#endif /* _SPI_TCLONCARBTDISPATCHER_H_ */
