/***********************************************************************/
/*!
 * \file              spi_tclOnCarAudioDispatcher.cpp
 * \brief             Message Dispatcher for Audio Messages. implemented using
 *                    double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Audio Messages
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author              | Modifications
 19.04.2018 |  Rishav Sardar       | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclOnCarAudioDispatcher.h"
#include "spi_tclOnCarRespAudio.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclOnCarAudioDispatcher.cpp.trc.h"
#endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleAudioMsg(this);                  \
   }                                                        \
   vDeAllocateMsg();                                        \
}


/***************************************************************************
 ** FUNCTION:  OnCarAudioMsgBase::OnCarAudioMsgBase
 ***************************************************************************/
OnCarAudioMsgBase::OnCarAudioMsgBase()
{
   ETG_TRACE_USR1(("OnCarAudioMsgBase::OnCarAudioMsgBase Entered"));
   vSetServiceID (e32MODULEID_ONCARAUDIO);
}

//! Class OnCarstartAudioPlaybackRequestMsg
/***************************************************************************
 ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::OnCarstartAudioPlaybackRequestMsg
 ***************************************************************************/
OnCarstartAudioPlaybackRequestMsg::OnCarstartAudioPlaybackRequestMsg() :
      m_enStreamType(e8_ONCAR_AUDIOSTREAM_TYPE_UNKNOWN)
{
   ETG_TRACE_USR1(("OnCarstartAudioPlaybackRequestMsg::OnCarstartAudioPlaybackRequestMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarstartAudioPlaybackRequestMsg,spi_tclOnCarAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarstartAudioPlaybackRequestMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarstartAudioPlaybackRequestMsg::vDeAllocateMsg()
{

}

//! Class OnCarstopAudioPlaybackRequestMsg

/***************************************************************************
 ** FUNCTION:  OnCarstopAudioPlaybackRequestMsg::OnCarstopAudioPlaybackRequestMsg
 ***************************************************************************/
OnCarstopAudioPlaybackRequestMsg::OnCarstopAudioPlaybackRequestMsg() :
      m_enStreamType(e8_ONCAR_AUDIOSTREAM_TYPE_UNKNOWN)
{
   ETG_TRACE_USR1(("OnCarstopAudioPlaybackRequestMsg::OnCarstopAudioPlaybackRequestMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCarstopAudioPlaybackRequestMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarstopAudioPlaybackRequestMsg,spi_tclOnCarAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarstopAudioPlaybackRequestMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarstopAudioPlaybackRequestMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  OnCarstopAudioPlaybackRequestMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarstopAudioPlaybackRequestMsg::vDeAllocateMsg()
{

}

//! Class OnCaraudioFocusRequestMsg

/***************************************************************************
 ** FUNCTION:  OnCaraudioFocusRequestMsg::OnCaraudioFocusRequestMsg
 ***************************************************************************/
OnCaraudioFocusRequestMsg::OnCaraudioFocusRequestMsg() :
      m_enStreamType(e8_ONCAR_AUDIOSTREAM_TYPE_UNKNOWN),m_enFocusRequest(e8_ONCAR_AUDIOFOCUS_REQUEST_UNKNOWN)
{
   ETG_TRACE_USR1(("OnCaraudioFocusRequestMsg::OnCaraudioFocusRequestMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCaraudioFocusRequestMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCaraudioFocusRequestMsg,spi_tclOnCarAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCaraudioFocusRequestMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCaraudioFocusRequestMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  OnCaraudioFocusRequestMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCaraudioFocusRequestMsg::vDeAllocateMsg()
{

}

//! Class OnCaraudioErrorMsg

/***************************************************************************
 ** FUNCTION:  OnCaraudioErrorMsg::OnCaraudioErrorMsg
 ***************************************************************************/
OnCaraudioErrorMsg::OnCaraudioErrorMsg() :
      m_enSinkError(e32_ONCAR_SINK_NO_ERROR)
{
   ETG_TRACE_USR1(("OnCaraudioErrorMsg::OnCaraudioErrorMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCaraudioErrorMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCaraudioErrorMsg,spi_tclOnCarAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCaraudioErrorMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCaraudioErrorMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  OnCaraudioErrorMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCaraudioErrorMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarAudioDispatcher::spi_tclOnCarAudioDispatcher
 ***************************************************************************/
spi_tclOnCarAudioDispatcher::spi_tclOnCarAudioDispatcher()
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioDispatcher::spi_tclOnCarAudioDispatcher Entered"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarAudioDispatcher::~spi_tclOnCarAudioDispatcher
 ***************************************************************************/
spi_tclOnCarAudioDispatcher::~spi_tclOnCarAudioDispatcher()
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioDispatcher::~spi_tclOnCarAudioDispatcher Entered"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
 ** OnCarstartAudioPlaybackRequestMsg* poOnCarstartAudioPlaybackRequestMsg)
 ***************************************************************************/
t_Void spi_tclOnCarAudioDispatcher::vHandleAudioMsg(OnCarstartAudioPlaybackRequestMsg* poOnCarstartAudioPlaybackRequestMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioDispatcher::vHandleAudioMsg: OnCarstartAudioPlaybackRequest Entered \n"));
   if (NULL != poOnCarstartAudioPlaybackRequestMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespAudio,
              e16ONCAR_AUDIO_REGID,
              vPoststartAudioPlaybackRequest(poOnCarstartAudioPlaybackRequestMsg->m_enStreamType));
   }// if (NULL != poOnCarstartAudioPlaybackRequestMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
 ** OnCarstopAudioPlaybackRequestMsg* poOnCarstopAudioPlaybackRequestMsg)
 ***************************************************************************/
t_Void spi_tclOnCarAudioDispatcher::vHandleAudioMsg(OnCarstopAudioPlaybackRequestMsg* poOnCarstopAudioPlaybackRequestMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioDispatcher::vHandleAudioMsg: OnCarstopAudioPlaybackRequest Entered \n"));
   if (NULL != poOnCarstopAudioPlaybackRequestMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespAudio,
              e16ONCAR_AUDIO_REGID,
              vPoststopAudioPlaybackRequest(poOnCarstopAudioPlaybackRequestMsg->m_enStreamType));
   }// if (NULL != poOnCarstopAudioPlaybackRequestMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
 ** OnCaraudioFocusRequestMsg* poOnCaraudioFocusRequestMsg)
 ***************************************************************************/
t_Void spi_tclOnCarAudioDispatcher::vHandleAudioMsg(OnCaraudioFocusRequestMsg* poOnCaraudioFocusRequestMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioDispatcher::vHandleAudioMsg: OnCaraudioFocusRequest Entered \n"));
   if (NULL != poOnCaraudioFocusRequestMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespAudio,
              e16ONCAR_AUDIO_REGID,
              vPostaudioFocusRequestCallback(poOnCaraudioFocusRequestMsg->m_enStreamType,
              poOnCaraudioFocusRequestMsg->m_enFocusRequest));
   }// if (NULL != poOnCaraudioFocusRequestMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
 ** OnCaraudioErrorMsg* poOnCaraudioErrorMsg)
 ***************************************************************************/
t_Void spi_tclOnCarAudioDispatcher::vHandleAudioMsg(OnCaraudioErrorMsg* poOnCaraudioErrorMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioDispatcher::vHandleAudioMsg: OnCaraudioError Entered \n"));
   if (NULL != poOnCaraudioErrorMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespAudio,
              e16ONCAR_AUDIO_REGID,
              vPostaudioErrorCallback(poOnCaraudioErrorMsg->m_enSinkError));
   }// if (NULL != poOnCaraudioErrorMsg)
}

