/*!
 *******************************************************************************
 * \file              spi_tclOnCarAudioCbs.cpp
 * \brief             Audio Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Audio Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 20.03.2018 |  Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclOnCarMsgQInterface.h"
#include "spi_tclOnCarAudioDispatcher.h"
#include "spi_tclOnCarAudioCbs.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarAudioCbs.cpp.trc.h"
#endif
#endif


/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarAudioCbs::startAudioPlaybackRequestCallback(...)
***************************************************************************/
void spi_tclOnCarAudioCbs::startAudioPlaybackRequestCallback(const AUDIOSTREAM_TYPE type)
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioCbs::startAudioPlaybackRequestCallback entered"));
   ETG_TRACE_USR2(("[DESC]::Start Audio Playback request received with AUDIOSTREAM_TYPE = %d",type));
   spi_tclOnCarMsgQInterface* poMsgQInterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQInterface)
   {
       OnCarstartAudioPlaybackRequestMsg oOnCarstartAudioPlaybackRequestMsg;
       oOnCarstartAudioPlaybackRequestMsg.m_enStreamType = static_cast<tenOnCarAudioStreamType> (type);
       poMsgQInterface->bWriteMsgToQ(&oOnCarstartAudioPlaybackRequestMsg, sizeof(oOnCarstartAudioPlaybackRequestMsg));
   }//if (NULL != poMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarAudioCbs::stopAudioPlaybackRequestCallback(...)
***************************************************************************/
void spi_tclOnCarAudioCbs::stopAudioPlaybackRequestCallback(const AUDIOSTREAM_TYPE type)
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioCbs::stopAudioPlaybackRequestCallback entered"));
   ETG_TRACE_USR2(("[DESC]::Stop Audio Playback request received with AUDIOSTREAM_TYPE = %d",type));
   spi_tclOnCarMsgQInterface* poMsgQInterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQInterface)
   {
       OnCarstopAudioPlaybackRequestMsg oOnCarstopAudioPlaybackRequestMsg;
       oOnCarstopAudioPlaybackRequestMsg.m_enStreamType = static_cast<tenOnCarAudioStreamType> (type);
       poMsgQInterface->bWriteMsgToQ(&oOnCarstopAudioPlaybackRequestMsg, sizeof(oOnCarstopAudioPlaybackRequestMsg));
   }//if (NULL != poMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarAudioCbs::audioFocusRequestCallback(...)
***************************************************************************/
void spi_tclOnCarAudioCbs::audioFocusRequestCallback(const AUDIOSTREAM_TYPE streamtype,const AUDIOFOCUS_REQUEST request)
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioCbs::audioFocusRequestCallback entered"));
   ETG_TRACE_USR2(("[DESC]::Audio Focus request received with AUDIOSTREAM_TYPE = %d,"
                 "AUDIOFOCUS_REQUEST = %d",streamtype,request));
   spi_tclOnCarMsgQInterface* poMsgQInterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQInterface)
   {
       OnCaraudioFocusRequestMsg oOnCaraudioFocusRequestMsg;
       oOnCaraudioFocusRequestMsg.m_enStreamType = static_cast<tenOnCarAudioStreamType> (streamtype);
       oOnCaraudioFocusRequestMsg.m_enFocusRequest = static_cast<tenOnCarAudioFocusRequest> (request);
       poMsgQInterface->bWriteMsgToQ(&oOnCaraudioFocusRequestMsg, sizeof(oOnCaraudioFocusRequestMsg));
   }//if (NULL != poMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarAudioCbs::requestVideoFocusCallback(...)
***************************************************************************/
void spi_tclOnCarAudioCbs::audioErrorCallback(const ONCARSINKERROR enError)
{
   ETG_TRACE_USR1(("spi_tclOnCarAudioCbs::audioErrorCallback entered"));
   tenOnCarSinkError enOnCarSinkError = e32_ONCAR_SINK_NO_ERROR;
   enOnCarSinkError = static_cast<tenOnCarSinkError>(enError);

   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      OnCaraudioErrorMsg oOnCaraudioErrorMsg;
      oOnCaraudioErrorMsg.m_enSinkError = enOnCarSinkError;
      poMsgQinterface->bWriteMsgToQ(&oOnCaraudioErrorMsg, sizeof(oOnCaraudioErrorMsg));
   }//if (NULL != poMsgQinterface)
}


