/*!
 *******************************************************************************
 * \file              spi_tclOnCarCmdAudio.h
 * \brief             Audio Endpoint Wrapper for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Audio Endpoint Wrapper for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                | Modifications
 19.04.2018 |  Rishav Sardar         | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLONCARCMDAUDIO_H_
#define SPI_TCLONCARCMDAUDIO_H_

/******************************************************************************
 | includes:
 | 1)AAP - includes
 | 2)Typedefines
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPI_OnCarTypes.h"
#include "spi_tclOnCarAudioCbs.h"
#include "Lock.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/



/*!
 * \class spi_tclOnCarCmdAudio
 * \brief
 */

class spi_tclOnCarCmdAudio
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarCmdAudio::spi_tclOnCarCmdAudio();
       ***************************************************************************/
      /*!
       * \fn     spi_tclOnCarCmdAudio()
       * \brief  Default Constructor
       * \sa      ~spi_tclOnCarCmdAudio()
       **************************************************************************/
      spi_tclOnCarCmdAudio();

      /***************************************************************************
       ** FUNCTION:  virtual spi_tclOnCarCmdAudio::~spi_tclOnCarCmdAudio()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclOnCarCmdAudio()
       * \brief   Destructor
       * \sa      spi_tclOnCarCmdAudio()
       **************************************************************************/
      virtual ~spi_tclOnCarCmdAudio();

      /***************************************************************************
      ** FUNCTION:  t_Bool spi_tclOnCarCmdAudio::bInitialize()
      ***************************************************************************/
      /*!
      * \fn      t_Bool bInitialize()
      * \brief   method to create and initialize audio sink
      * \param   tvectrOnCarAudioConfig : [IN] Audio configuration
      * \sa      vUninitialize()
      * \retval  t_Bool
      **************************************************************************/
      t_Bool bInitialize(const tvectrOnCarAudioConfig& covtrOnCarAudioConfig);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclOnCarCmdAudio::vUninitialize()
      ***************************************************************************/
      /*!
      * \fn      t_Void vUninitialize()
      * \brief   method to destroy audio sink
      * \sa      None
      * \retval  t_Void
      **************************************************************************/
      t_Void vUninitialize();

       /***************************************************************************
        ** FUNCTION:  t_Void spi_tclOnCarCmdAudio::vSetAudioFocus()
        ***************************************************************************/
       /*!
        * \fn      t_Void vSetAudioFocus()
        * \brief   Set the Audio focus.
        * \param   enStreamType: Audio stream type.
        * \param   enAudioFocusState :Audio Focus state.
        **************************************************************************/
       t_Void vSetAudioFocus(const tenOnCarAudioStreamType enStreamType,const tenOnCarDeviceAudioFocusState enAudioFocusState);
       
       /***************************************************************************
        ** FUNCTION:  t_Void spi_tclOnCarCmdAudio::vStopALSAStreaming()
        ***************************************************************************/
       /*!
        * \fn      t_Void vStopALSAStreaming()
        * \brief   Stop ALSA streaming
        * \param   enStreamType: Audio stream type.
        **************************************************************************/
       t_Void vStopALSAStreaming(const tenOnCarAudioStreamType enStreamType);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclOnCarCmdAudio::vDestroyAudioEndpointInstance()
      ***************************************************************************/
      /*!
      * \fn      t_Void vDestroyAudioEndpointInstance()
      * \brief   method to destroy audio sink
      * \sa      None
      * \retval  t_Void
      **************************************************************************/
      t_Void vDestroyAudioEndpointInstance();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vAcknowledgeStartAudioRequest()
       ***************************************************************************/
       /*!
       * \fn      t_Void vAcknowledgeStartAudioRequest(tenOnCarAudioStreamType enOnCarAudStreamType)
       * \brief   method to acknowledge the start audio request from Oncar
       * \param   enOnCarAudStreamType : [IN] Audio Stream Type
       * \retval  t_Void
       **************************************************************************/
      t_Void vAcknowledgeStartAudioRequest(tenOnCarAudioStreamType enOnCarAudStreamType);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vAcknowledgeStopAudioRequest()
       ***************************************************************************/
       /*!
       * \fn      t_Void vAcknowledgeStopAudioRequest(tenOnCarAudioStreamType enOnCarAudStreamType)
       * \brief   method to acknowledge the stop audio request from Oncar
       * \param   enOnCarAudStreamType : [IN] Audio Stream Type
       * \retval  t_Void
       **************************************************************************/
      t_Void vAcknowledgeStopAudioRequest(tenOnCarAudioStreamType enOnCarAudStreamType);


   protected:

      /***************************************************************************
       *********************************PROTECTED************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION: spi_tclOnCarCmdAudio(const spi_tclOnCarCmdAudio &rfcoobjCRCBResp)
       ***************************************************************************/
      /*!
      * \fn      spi_tclOnCarCmdAudio(const spi_tclOnCarCmdAudio& corfoSrc)
      * \brief   Copy constructor - Do not allow the creation of copy constructor
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclOnCarCmdAudio()
       **************************************************************************/
      spi_tclOnCarCmdAudio(const spi_tclOnCarCmdAudio& corfoSrc);

      /***************************************************************************
       ** FUNCTION: spi_tclOnCarCmdAudio& operator=(const spi_tclOnCarCmdAudio& corfoSrc)
       ***************************************************************************/
      /*!
      * \fn      spi_tclOnCarCmdAudio& operator=(const spi_tclOnCarCmdAudio& corfoSrc))
      * \brief   Assignment operator
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclOnCarCmdAudio(const spi_tclOnCarCmdAudio& otrSrc)
       **************************************************************************/
      spi_tclOnCarCmdAudio& operator=(const spi_tclOnCarCmdAudio& corfoSrc);

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclOnCarCmdAudio::vSetAudioConfig()
      ***************************************************************************/
      /*!
      * \fn      t_Void vSetAudioConfig(const trAAPVideoConfig& corfrAAPVideoConfig)
      * \brief   method to set the audio configuration for Audio Sink
      * \param   corfrOnCarAudioConfig : [IN] Audio configuration
      * \retval  t_Void
      **************************************************************************/
      t_Void vSetAudioConfig(const trOnCarAudioConfig& corfrOnCarAudioConfig);

      //! shared pointer for OnCar Audio callbacks
      std::shared_ptr<IOnCarAudioSinkCallbacks> m_spoAudioCbs;

      //! Audio Endpoint pointer
      OnCarAudioSinkEndpoint* m_poOnCarAudioEndpoint;

      //! Map to store audio pipeline configuration for different audio streams
      tmapAudioPipeConfig m_mapAudioPipeConfig;

      //! Lock object for Audio endpoint
      Lock  m_oEndpointLock;
};

#endif /* SPI_TCLONCARCMDAUDIO_H_ */
