/*!
 *******************************************************************************
 * \file              spi_tclOnCarInputHandler.h
 * \brief             SPI input handler for OnCar devices
 *******************************************************************************
 \verbatim
 PROJECT:       Gen3
 SW-COMPONENT:  Smart Phone Integration
 DESCRIPTION:   Input handler class to send input events from Headunit to
                OnCar Device
 AUTHOR:         Rishav Sardar
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH

 HISTORY:
 Date        | Author                | Modification
 16.05.2018  | Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLONCARINPUTHANDLER_H_
#define SPI_TCLONCARINPUTHANDLER_H_

/******************************************************************************
 | includes:
 | 1)RealVNC sdk - includes
 | 2)Typedefines
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclInputDevBase.h"
#include "spi_tclOnCarRespInput.h"
#include "spi_tclOnCarCmdInput.h"
 

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
//! Forward declarations
class spi_tclCmdInput;
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
class spi_tclInputRespIntf;

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclOnCarInputHandler
 * \brief Input handler class to send input events from Headunit to
 OnCar Device
 *
 */

class spi_tclOnCarInputHandler: public spi_tclInputDevBase, public spi_tclOnCarRespInput
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarInputHandler::spi_tclOnCarInputHandler()
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarInputHandler()
       * \brief   Default constructor
       * \sa      ~spi_tclOnCarInputHandler()
       **************************************************************************/
       spi_tclOnCarInputHandler();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarInputHandler::~spi_tclOnCarInputHandler()
       ***************************************************************************/
      /*!
       * \fn     ~ spi_tclOnCarInputHandler()
       * \brief   destructor
       * \sa      spi_tclOnCarInputHandler()
       **************************************************************************/
      ~spi_tclOnCarInputHandler();

      /*********Start of functions overridden from spi_tclInputDevBase*******/

      /***************************************************************************
       ** FUNCTION: virtual t_Void spi_tclOnCarInputHandler::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSelectDevice(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq)
       * \brief   To setup input related info when a device is selected or
       *          de selected.
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Type.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq);

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclOnCarInputHandler::vRegisterVideoCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterInputCallbacks(const trVideoCallbacks& corfrVideoCallbacks)
       * \brief   To Register for the asynchronous responses that are required from
       *          OnCar Video
       * \param   corfrVideoCallbacks : [IN] Video callabcks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegisterInputCallbacks(const trInputCallbacks& corfrInputCallbacks);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarInputHandler::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarInputHandler::bInitialise()
       ***************************************************************************/
      /*!
       * \fn      bInitialise()
       * \brief   Method to initialises the service handler. (Performs initialisations which
       *          are not device specific.)
       *          Optional interface to be implemented.
       * \retval  t_Bool: TRUE - If ServiceHandler is initialised successfully, else FALSE.
       * \sa      bUninitialise()
       ***************************************************************************/
      t_Bool bInitialise();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarInputHandler::vProcessTouchEvent()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vProcessTouchEvent(t_U32, trTouchData&) const
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarInputHandler::vProcessKeyEvents()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vProcessKeyEvents(t_U32, tenKeyMode, tenKeyCode) const;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarInputHandler::vProcessKnobKeyEvents()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vProcessKnobKeyEvents(t_U32, t_S8) const
      {
      }

      /*********End of functions overridden from spi_tclInputDevBase*******/

      /*********Start of functions overridden from spi_tclOnCarRespInput*******/

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarInputHandler::vPostNotifyErrorRequest()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostNotifyErrorRequest()
       * \brief   Called to notify about error cases.
       *          Mandatory interface to be implemented.
       * \param   [IN] enOnCarSinkError: Error code
       * \sa      None
       **************************************************************************/
       t_Void vPostNotifyErrorRequest(tenOnCarSinkError enOnCarSinkError);

      /*********End of functions overridden from spi_tclOnCarRespInput*******/

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarInputHandler::spi_tclOnCarInputHandler(const spi_tclOnCarInputHandler..
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarInputHandler(const spi_tclOnCarInputHandler &corfrSrc)
       * \brief   Copy constructor, will not be implemented.
       * \note    This is a technique to disable the Copy constructor for this class.
       * \param   corfrSrc : [IN] Source Object
       **************************************************************************/
       spi_tclOnCarInputHandler(const spi_tclOnCarInputHandler& corfrSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarInputHandler& spi_tclOnCarInputHandler::operator= (const..
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarInputHandler& operator= (const spi_tclOnCarInputHandler &corfrSrc)
       * \brief   Assignment Operator, will not be implemented.
       * \note    This is a technique to disable the assignment operator for this class.
       *          So if an attempt for the assignment is made linker complains.
       * \param   corfrSrc : [IN] Source Object
       **************************************************************************/
       spi_tclOnCarInputHandler& operator=(const spi_tclOnCarInputHandler& corfrSrc);

       /***************************************************************************
        ** FUNCTION: t_Bool spi_tclOnCarInputHandler::bInitInputSession()
        ***************************************************************************/
       /*!
        * \fn      t_Bool bInitializeInputSession()
        * \brief   To initialize Input Session with display properties
        * \pram    None
        * \retval  t_Bool
        **************************************************************************/
        t_Bool bInitializeInputSession();

       //! Input Command class pointer
       spi_tclOnCarCmdInput* m_poOnCarCmdInput;
       //! Input Callbacks structure
       trInputCallbacks m_rInputCallbacks;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

};

#endif /* SPI_TCLONCARINPUTHANDLER_H_ */
