/*!
 *******************************************************************************
 * \file         spi_tclOnCarConnMngr.h
 * \brief        OnCar connection class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    
 AUTHOR:         jun5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 01.02.2018  | Unmukt Jain           | Initial Version
 \endverbatim
 07.12.2018  | Ashwini Savadi        | Session error Handling adaptation
 ******************************************************************************/
#ifndef SPI_TCL_ONCARCONNMNGR_H_
#define SPI_TCL_ONCARCONNMNGR_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclConnection.h"
#include "spi_tclOnCarRespSession.h"
#include "Timer.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

class spi_tclOnCarConnMngr: public spi_tclConnection, public spi_tclOnCarRespSession
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::spi_tclOnCarConnMngr
       ***************************************************************************/
      /*!
       * \fn     spi_tclOnCarConnMngr()
       * \brief  Default Constructor
       * \sa      ~spi_tclOnCarConnMngr()
       **************************************************************************/
      spi_tclOnCarConnMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::~spi_tclOnCarConnMngr
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclOnCarConnMngr()
       * \brief  Destructor
       * \sa     spi_tclOnCarConnMngr()
       **************************************************************************/
      ~spi_tclOnCarConnMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks()
       * \brief  interface for the creator class to register for the required
       *        callbacks.
       *         Mandatory interface
       * \param rfrConnCallbacks : reference to the callback structure
       *        populated by the caller
       * \retval t_Void
       **************************************************************************/
      t_Void vRegisterCallbacks(trConnCallbacks &rfrConnCallbacks);

      /**************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::bInitializeConnection
       **************************************************************************/
      /*!
       * \fn     bInitializeConnection()
       * \brief  Initialization of device detection and
       *         any other required initializations
       * \retval returns true on successful initialization and false on failure
       *************************************************************************/
      t_Bool bInitializeConnection();

      /**************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::vOnLoadSettings
       **************************************************************************
      !*
       * \fn     vOnLoadSettings()
       * \brief  Called on loadsettings
       *         Optional interface
       * \param rfrheadUnitInfo : Head unit information
       * \retval t_Void
       *************************************************************************/
      t_Void vOnLoadSettings(trHeadUnitInfo &rfrheadUnitInfo, tenCertificateType enCertificateType);

/*      **************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::vUnInitializeConnection
       **************************************************************************
      !
       * \fn     vUnInitializeConnection()
       * \brief  Uninitialization of sdk's etc
       *         Mandatory interface
       * \retval t_Void
       *************************************************************************
      t_Void vUnInitializeConnection();

      **************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::vOnSaveSettings
       **************************************************************************
      !
       * \fn     vOnSaveSettings()
       * \brief  Called on savesettings
       *         Optional interface
       * \retval none
       *************************************************************************
      t_Void vOnSaveSettings();

      /**************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarConnMngr::vOnSelectDevice()
       **************************************************************************/
      /*!
       * \fn     t_Void vOnSelectDevice()
       * \brief  Function to get the device selection.
       * \param  cou32DevID : [IN] Unique device ID
       * \param  enDevConnType : [IN] Device connection type
       * \param  enDevSelectType : [IN] Device select type
       * \param  enDAPUsage : [IN] DAP usage is selected as preference
       * \param  enCDBUsage : [IN] CDB usage is selected as preference
       * \param  enSelectReason   :  [IN] Describes whether the device Selection or Deselection is
       *               triggered due to a user action.
       * \param  corfrUsrCntxt : [IN] Stores user context info
       * \retval t_Void
       *************************************************************************/
      t_Void vOnSelectDevice(const t_U32 cou32DevID, tenDeviceConnectionType enDevConnType,
               tenDeviceConnectionReq enDevSelectType, tenEnabledInfo enDAPUsage, tenEnabledInfo enCDBUsage,
               tenSelectReason enSelectionReason, const trUserContext corfrUsrCntxt, tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE);

      /**************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarConnMngr::vOnSelectDeviceResult()
       **************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \param  cou32DevID  : [IN] Uniquely identifies the device ID
       * \param  enDevSelReq : [IN] Identifies the Connection Request.
       * \param  coenRespCode: [IN] Response code. Success/Failure
       * \param  enDevCat    : [IN] Device Category. ML/DiPo
       * \param  enSelectReason   :  [IN] Describes whether the device Selection or Deselection is
       *               triggered due to a user action.
       * \retval  t_Void
       *************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevID, const tenDeviceConnectionReq enDevSelectType,
               const tenResponseCode coenRespCode, tenDeviceCategory enDevCat, tenSelectReason enSelectionReason,
               tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE);

/*
      **************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarConnMngr::vSetSelectErrorCb()
       **************************************************************************
      !
       * \fn     t_Void vSetSelectErrorCb(t_U32 u32DevID,
       *                                  tenErrorCode enErrorCode)
       * \brief  Method to set the selection error
       * \param  u32DevID : [IN] Unique device ID
       * \param  enErrorCode : [IN] identifies different error codes
       * \retval t_Void
       *************************************************************************
      t_Void vSetSelectErrorCb(t_U32 u32DevID, tenErrorCode enErrorCode);

      **************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarConnMngr::vOnDeviceConnection()
       **************************************************************************
      !
       * \fn     t_Void vOnDeviceConnection(t_U32, const trDeviceInfo&)
       * \brief  Method called on device connection
       * \retval t_Void
       *************************************************************************
      t_Void vOnDeviceConnection(t_U32, const trDeviceInfo&)
      {
      }

      **************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarConnMngr::vOnDeviceDisconnection()
       **************************************************************************
      !
       * \fn     t_Void vOnDeviceDisconnection(t_U32)
       * \brief  Method called on device disconnection
       * \retval t_Void
       *************************************************************************
      t_Void vOnDeviceDisconnection(t_U32)
      {
      }
      **************************************************************************
       ** FUNCTION:  spi_tclOnCarConnMngr::bSetDevProjUsage
       **************************************************************************
      !
       * \fn     bSetDevProjUsage()
       * \brief  Called when the SPI featured is turned ON or OFF by the user.
       *         Mandatory interface
       * \param  enServiceStatus : Sets the particular SPI service ON or OFF
       *************************************************************************
      t_Bool bSetDevProjUsage(tenEnabledInfo enServiceStatus);

      **************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarConnMngr::vSetRoleSwitchRequestedInfo()
       **************************************************************************
      !
       * \fn    t_Void vSetRoleSwitchRequestedInfo(const t_U32 cou32DeviceHandle)
       * \brief Method to set the role switch request info
       * \param cou32DeviceHandle : [IN] device handle
       * \retval t_Void
       *************************************************************************
      virtual t_Void vSetRoleSwitchRequestedInfo(const t_U32 cou32DeviceHandle);

      virtual t_Void vSetDeviceSwitchInfo(trDeviceSwitchInfo &rfrDeviceSwitchInfo);*/

   protected:

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarConnMngr::vPostOnCarSessionErrorMsg()
      ***************************************************************************/
      /*!
      * \fn      virtual vPostOnCarSessionErrorMsg()
      * \brief   Invoked to provide information about OnCar session error
      * \param   enOnCarSinkError: OnCar session error
      **************************************************************************/
      t_Void vPostOnCarSessionErrorMsg(const tenOnCarSinkError enOnCarSinkError);

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarConnMngr::vPostOnCarSessionStateMsg()
      ***************************************************************************/
      /*!
      * \fn      virtual vPostOnCarSessionStateMsg()
      * \brief   Invoked to provide information about OnCar session state
      * \param   enOnCarSessionState: OnCar session state
      **************************************************************************/
      t_Void vPostOnCarSessionStateMsg(const tenOnCarSessionState enOnCarSessionState);
   private:
      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarConnMngr::vStartOnCarSessionStatusTimer
      ***************************************************************************/
      /*!
      * \fn     vStartOnCarSessionStatusTimer
      * \brief  Starts timer to monitor OnCar Session status
      **************************************************************************/
      t_Void vStartOnCarSessionStatusTimer();
      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarConnMngr::vStopOnCarSessionStatusTimer
      ***************************************************************************/
      /*!
      * \fn     vStopOnCarSessionStatusTimer
      * \brief  Stops timer to monitor OnCar Session status
      **************************************************************************/
      t_Void vStopOnCarSessionStatusTimer();
      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarConnMngr::bOnCarSessionStatusTimerCb
      ***************************************************************************/
      /*!
      * \fn     bOnCarSessionStatusTimerCb
      * \brief  called on expiry of component response timer
      * \param  rTimerID: ID of the timer which has expired
      * \param  pvObject: pointer to object passed while starting the timer
      * \param  pvUserData: data passed during start of the timer
      **************************************************************************/
      static t_Bool bOnCarSessionStatusTimerCb(timer_t rTimerID, t_Void *pvObject,
                     const t_Void *pvUserData);

      /***************************************************************************
      ** FUNCTION: spi_tclOnCarConnMngr(const spi_tclOnCarConnMngr &corfobjRhs)
      ***************************************************************************/
      /*!
      * \fn      spi_tclOnCarConnMngr(const spi_tclOnCarConnMngr &corfobjRhs)
      * \brief   Copy constructor not implemented hence made protected to prevent
      *          misuse
      **************************************************************************/
      spi_tclOnCarConnMngr(const spi_tclOnCarConnMngr &corfobjRhs);

      /***************************************************************************
      ** FUNCTION: const spi_tclOnCarConnMngr & operator=(const spi_tclOnCarConnMngr &corfobjRhs);
      ***************************************************************************/
      /*!
      * \fn      const spi_tclOnCarConnMngr & operator=(const spi_tclOnCarConnMngr &corfobjRhs);
      * \brief   assignment operator not implemented hence made protected to
      *          prevent misuse
      **************************************************************************/
      const spi_tclOnCarConnMngr & operator=(const spi_tclOnCarConnMngr &corfobjRhs);

      //! Call baclk structure for connection
      trConnCallbacks m_rConnCbs;
      //! selected device handle
      t_U32 m_u32SelDevID;

      //! Store head unit information
      trHeadUnitInfo m_rHeadUnitInfo;
      //! OnCar Session status timer
      timer_t m_rSessionStatusTimerID;
/*

      //@todo - thread safe mechanism to be implemented
      std::map<t_U32, trMySPINDeviceInfo> m_mapDevInfo;

      // list of devices with OTG Support
      std::map<t_U32, t_Bool> m_mapOTGDevice;

      //! TODO use a map
      trDeviceSwitchInfo m_rDeviceSwitchInfo;*/

};

#endif /* SPI_TCL_ONCARCONNMNGR_H_ */
