/**
 *******************************************************************************
 * \file              OnCarEndPointBase.h
 * \brief             Base class for all the endoints
 *******************************************************************************/

#ifndef ONCAR_ENDPOINT_BASE_HPP
#define ONCAR_ENDPOINT_BASE_HPP
 
#include "OnCarTypes.h"

/**
 *
 * This class forms the base for all 'endpoints' advertised by the head unit.
 * All standard endpoints must inherit from this base class. 
 */
class OnCarEndPointBase
{
	private:
	   ONCARENDPOINTID onCarEndpointID;
	   
	public:
    /**
     * Constructor for OnCarEndPointBase
	 * @param endpointID endPoint ID of the endpoint being created
     */
	  OnCarEndPointBase(ONCARENDPOINTID endpointID):onCarEndpointID(endpointID){}
	  virtual ~OnCarEndPointBase() { }
	  
    /**
     * Initialize the endpoint. All configuration items must be set. resources, threads can be initialized in this method.
	 * Endpoint needs to override the default implementation if they want specific handling. Default implementation always return true.
     * @return true if success else false
     */
	  virtual bool init() = 0;
	  
    /**
     * Uninitialize the endpoint. resources, threads can be released in this method.
	 * Endpoint needs to override the default implementation if they want specific handling. Default implementation always return true.
     * @return true if success else false
     */
	  virtual bool deinit() = 0;
	  
	/**
     * Get the endpoint ID of the endpoint
     * @return ONCARENDPOINTID
     */
      ONCARENDPOINTID getEndpointID()
	  {
         return onCarEndpointID;
	  }
	
};

#endif //ONCAR_ENDPOINT_BASE_HPP