/*!
*******************************************************************************
* \file             spi_tclResourceMngrResp.h
* \brief            Response to HMI from Resource manager class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Response  to HMI  from Resource manager class.
AUTHOR:         Priju K Padiyath
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
05.04.2014 |  Priju K Padiyath            | Initial Version
26.04.2014 |  Shihabudheen P M            | added vPostDeviceAudioContext
19.06.2014 |  Shihabudheen P M            | added vPostDeviceAppState
25.10.2014 |  Shihabudheen P M            | added vUpdateSessionStatusInfo
29.11.2016 |  Noopur R K                  | HMI Synchronization

\endverbatim
******************************************************************************/

#ifndef SPI_TCLRSRCMNGRRESP_H_
#define SPI_TCLRSRCMNGRRESP_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "SPITypes.h"

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/*!
* \class spi_tclConnSettings
* \brief Response  to HMI  from ConnMngr class
*/
class spi_tclResourceMngrResp
{

public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclResourceMngrResp::spi_tclResourceMngrResp
   ***************************************************************************/
   /*!
   * \fn     spi_tclResourceMngrResp()
   * \brief  Default Constructor
   * \sa      ~spi_tclResourceMngrResp()
   **************************************************************************/
   spi_tclResourceMngrResp()
   {
   }

   /***************************************************************************
   ** FUNCTION:  spi_tclResourceMngrResp::~spi_tclResourceMngrResp
   ***************************************************************************/
   /*!
   * \fn     ~spi_tclResourceMngrResp()
   * \brief  Virtual Destructor
   * \sa     spi_tclResourceMngrResp()
   **************************************************************************/
   virtual ~spi_tclResourceMngrResp()
   {
   }


   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrResp::vPostDeviceDisplayContext
   **                   (t_U32 u32DeviceHandle, t_Bool bDisplayFlag,..)
   ***************************************************************************/
   /*!
   * \fn     vPostDeviceDisplayContext(t_U32 u32DeviceHandle, t_Bool bDisplayFlag,
   *         tenDisplayContextReason enDisplayContextReason, const trUserContext rcUsrCntxt);
   * \brief  This interface is used by Mirror Link/DiPO device to inform the client
   *              about its current display con-text.
   * \param  u32DeviceHandle  : [IN] Uniquely identifies the target Device.
   * \param  bDisplayFlag     : [IN] TRUE – Start Display Projection, FALSE – Stop Display Projection.
   * \param  enDisplayContextReason : [IN] Reason for device display context update.
   * \param  enPermScreen     : [IN] Permanent owner of the display resource
   * \param  rcUsrCntxt       : [IN] User Context Details.
   **************************************************************************/
   virtual t_Void vPostDeviceDisplayContext(t_U32 /*u32DeviceHandle*/,
      t_Bool /*bDisplayFlag*/,
      tenDisplayContextReason /*enDisplayContextReason*/,
      tenDiPOEntity /*enPermScreen*/,
      const trUserContext /*rcUsrCntxt*/)
   {
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrResp::vPostDeviceAudioContext
   **                   (t_U32 u32DeviceHandle, t_Bool bPlayFlag,..)
   ***************************************************************************/
   /*!
   * \fn     vPostDeviceAudioContext()
   * \brief  This function used to update HMI about the audio context changes
   * \param  u32DeviceHandle  : [IN] Uniquely identifies the target Device.
   * \param  bPlayFlag        : [IN] TRUE – Start Display Projection playback,
   *                                 FALSE – Stop Display Projection playback.
   * \param  u8AudioContext   : [IN] Audio context of the projected device.
   * \param  enPermMainAudio  : [IN] Permanent owner of the main audio resource
   * \param  rcUsrCntxt       : [IN] User Context Details.
   **************************************************************************/
   virtual t_Void vPostDeviceAudioContext(t_U32 /*u32DeviceHandle*/,
      t_Bool /*bPlayFlag*/, t_U8 /*u8AudioContext*/,
      tenDiPOEntity /*enPermMainAudio*/, const trUserContext /*rcUsrCntxt*/)
   {
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrResp::vPostDeviceAppState
   **                   (tenSpeechAppState enSpeechAppState,...)
   ***************************************************************************/
   /*!
   * \fn     vPostDeviceAppState()
   * \brief  This function used to update HMI about the App state changes
   * \param  enSpeechAppState : [IN] Speech app state
   * \param  enPhoneAppState  : [IN] Phone App state
   * \param  enNavAppState    : [IN] Navigation App state
   * \param  rcUsrCntxt       : [IN] User Context Details.
   **************************************************************************/
   virtual t_Void vPostDeviceAppState(tenSpeechAppState /*enSpeechAppState*/,
      tenPhoneAppState /*enPhoneAppState*/,  tenNavAppState /*enNavAppState*/,
      const trUserContext /*rcUsrCntxt*/)
   {
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrResp::vPostDeviceSpmSubState
   **                   (tenSpmSubState enSpmSubState,t_Bool m_bSubStateData)
   ***************************************************************************/
   /*!
   * \fn     vPostDeviceSpmSubState()
   * \brief  This function used to update LCM about the SPM substate changes
   * \param  enSpmSubState  : [IN] Spm SubState type
   * \param  m_bSubStateData  : [IN] Spm SubState data
   **************************************************************************/
   virtual t_Void vPostDeviceSpmSubState(tenSpmSubState /*enSpmSubState*/, t_Bool /*m_bSubStateData*/)
   {
   }

  /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrResp::vUpdateSessionStatusInfo
   **                   (t_U32 u32DeviceHandle,...)
   ***************************************************************************/
   /*!
   * \fn     vUpdateSessionStatusInfo()
   * \brief  Used to update the session status to HMI.
   * \param  u32DeviceHandle  : [IN] Device handle
   * \param  enDevCat         : [IN] Device category
   * \param  enSessionStatus  : [IN] Session status.
   **************************************************************************/
   virtual t_Void vUpdateSessionStatusInfo(t_U32 /*u32DeviceHandle*/,
      tenDeviceCategory /*enDevCat*/,
      tenSessionStatus /*enSessionStatus*/)
   {
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrResp::vUpdateDevAuthAndAccessInfo()
   ***************************************************************************/
   /*!
   * \fn     virtual t_Void vUpdateDevAuthAndAccessInfo(const t_U32 cou32DeviceHandle,
   *             const tenHandsetInteractionStatus coenHandsetInteractionReqd)
   * \brief  Notifies the authorization and access to AAP projection device.
   * \param  u32DeviceHandle            : [IN] Uniquely identifies the target Device.
   * \param  coenHandsetInteractionReqd : [IN] Handset/user interaction requirement status.
   **************************************************************************/
   virtual t_Void vUpdateDevAuthAndAccessInfo(const t_U32 /*cou32DeviceHandle*/,
            const tenHandsetInteractionStatus /*coenHandsetInteractionReqd*/){}

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclResourceMngrResp::vPostInitiateCallInfo
    **                   (t_U32 u32DeviceHandle,...)
    ***************************************************************************/
    /*!
    * \fn     vPostInitiateCallInfo()
    * \brief  Used to update the session status to HMI.
    * \param  [IN] u32DeviceHandle  : Device handle
    * \param  [IN] enDevCat         : Device category
    * \param  [IN] enSessionStatus  : Session status.
    **************************************************************************/
    virtual t_Void vPostInitiateCallInfo(t_U32 /*u32DeviceHandle*/,
             t_String /*szTelePhoneNumber*/,
             t_String /*szDisplayText*/)
    {
    }

    /***************************************************************************
     ** FUNCTION: t_Void spi_tclResourceMngrResp::vPostInitiateCallInfo
     **                   (t_U32 u32DeviceHandle,...)
     ***************************************************************************/
     /*!
     * \fn     vPostInitiateCallInfo()
     * \brief  Used to update the session status to HMI.
     * \param  [IN] u32DeviceHandle  : Device handle
     * \param  [IN] enDevCat         : Device category
     * \param  [IN] enSessionStatus  : Session status.
     **************************************************************************/
     virtual t_Void vPostMySPINVoiceSessionReq(t_U32 /*u32DeviceHandle*/,
                                               t_U8 /*u8VoiceSessionReq*/)
     {
     }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrResp::vUpdateProjectionVideoRenderingStatus()
   ***************************************************************************/
   /*!
   * \fn     virtual t_Void vUpdateProjectionVideoRenderingStatus(tenProjVideoRenderingStatus enProjVideoRenderingStatus)
   * \brief  When SPI Projection is ON or OFF
   * \param  enProjVideoRenderingStatus  : TRUE when SPI projection is ON
   *                                       FALSE when SPI projection is OFF
   **************************************************************************/
   virtual t_Void vUpdateProjectionVideoRenderingStatus(tenProjVideoRenderingStatus /*enProjVideoRenderingStatus*/)
   {}

   /***************************************************************************
   *****************************END OF PUBLIC*************************************
   ***************************************************************************/

};
#endif // SPI_TCLRSRCMNGRRESP_H_
