/*!
*******************************************************************************
* \file              spi_tclExtCmdWiFiIntf.h
* \brief             WiFi Adapter Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to register/un-register
                with WiFi data provider.
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
11.01.2017 |  Unmukt Jain                 | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDWIFIINTF_H_
#define _SPI_TCLEXTCMDWIFIINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_WifiTypedefs.h"

/**
* \brief   WiFi Intf class
*/
class spi_tclExtCmdWiFiIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdWiFiIntf::~spi_tclExtCmdWiFiIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdWiFiIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdWiFiIntf(){}

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclExtCmdWiFiIntf::vInitiateWirelessDiscovery()
    ***************************************************************************/
   /*!
    * \fn      vInitiateWirelessDiscovery()
    * \brief   vInitiateWirelessDiscovery Method. Invoked by HMI to start CPW session.
    **************************************************************************/
   virtual t_Void vInitiateWirelessDiscovery(tenDeviceCategory enDevCategory) = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdWiFiIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdWiFiIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;
   
    /***************************************************************************
    ** FUNCTION: t_Void spi_tclExtCmdWiFiIntf::vSetWiFiLimitationMode()
    ***************************************************************************/
   /*!
    * \fn      vSetWiFiLimitationMode()
    * \brief   This is to enable/disable restrictions on WiFi feature set when a SPI session is active
    * \param   enDevCategory: Device Category
    * \param   bActivate: TRUE - Activate. FALSE -Deactivate
    **************************************************************************/
    virtual t_Void vSetWiFiLimitationMode(tenDeviceCategory enDevCategory,t_Bool bActivate) = 0;

   /***************************************************************************
   ** FUNCTION:  tenWifiFrequency spi_tclExtCmdWiFi::enGetPreferredFrequency(...)
   ***************************************************************************/
   /*!
   * \fn      enGetPreferredFrequency()
   * \brief   Fetches the preferred frequency for the device category
   * \param   [IN]  enCategory: Device category
   * \param   [OUT] enFrequency: Preferred frequency for the device category
   * \retval  None
   **************************************************************************/
   virtual tenWifiFrequency enGetPreferredFrequency(tenDeviceCategory enCategory) = 0;

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDWIFIINTF_H_

