/*!
 * \file  spi_tclExtTelephoneDispatcher.cpp
 * \brief Message Dispatcher for Telephone Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Telephone Messages
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                   | Modification
 10.04.2018  | BDU6KOR(Dhanya)          | Initial Version

 \endverbatim
**************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtTelephoneDispatcher.h"
#include "spi_tclExtRespTelephone.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtTelephoneDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleTelephoneMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  TelephoneMsgBase::TelephoneMsgBase
 ***************************************************************************/
TelephoneMsgBase::TelephoneMsgBase()
{
   ETG_TRACE_USR1(("TelephoneMsgBase::TelephoneMsgBase entered"));
   vSetServiceID(e32MODULEID_TELEPHONE);
}

//!class TelephoneCallActivityMsg
/***************************************************************************
 ** FUNCTION:  TelephoneCallActivityMsg::TelephoneCallActivityMsg
 ***************************************************************************/
TelephoneCallActivityMsg::TelephoneCallActivityMsg(t_Bool bCallActive): m_bCallActive(bCallActive)
{
   ETG_TRACE_USR1(("TelephoneCallActivityMsg::TelephoneCallActivityMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  TelephoneCallActivityMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(TelephoneCallActivityMsg, spi_tclExtTelephoneDispatcher);

/***************************************************************************
 ** FUNCTION:  TelephoneCallActivityMsg::vAllocateMsg
 ***************************************************************************/
t_Void TelephoneCallActivityMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("TelephoneCallActivityMsg::vAllocateMsg entered"));
}

/***************************************************************************
 ** FUNCTION:  TelephoneCallActivityMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void TelephoneCallActivityMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("TelephoneCallActivityMsg::vDeAllocateMsg entered"));
}

//!class TelephoneCallStatusMsg
/***************************************************************************
 ** FUNCTION:  TelephoneCallStatusMsg::TelephoneCallStatusMsg
 ***************************************************************************/
TelephoneCallStatusMsg::TelephoneCallStatusMsg(const std::vector<trTelCallStatusInfo> &rTelCallStatusInfo)
{
   ETG_TRACE_USR1(("TelephoneCallStatusMsg::TelephoneCallStatusMsg entered "));
   vAllocateMsg();
      if (NULL !=m_pTelCallStatusInfoList)
      {
         (*m_pTelCallStatusInfoList) = rTelCallStatusInfo;
      }
}

/***************************************************************************
 ** FUNCTION:  TelephoneCallStatusMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(TelephoneCallStatusMsg, spi_tclExtTelephoneDispatcher);

/***************************************************************************
 ** FUNCTION:  TelephoneCallStatusMsg::vAllocateMsg
 ***************************************************************************/
t_Void TelephoneCallStatusMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("TelephoneCallStatusMsg::vAllocateMsg entered"));
   m_pTelCallStatusInfoList = new std::vector<trTelCallStatusInfo>;
}

/***************************************************************************
 ** FUNCTION:  TelephoneCallStatusMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void TelephoneCallStatusMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("TelephoneCallStatusMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_pTelCallStatusInfoList);
}

//!class ExtVRStateUpdateMsg
/***************************************************************************
 ** FUNCTION:  ExtVRStateUpdateMsg::ExtVRStateUpdateMsg
 ***************************************************************************/
ExtVRStateUpdateMsg::ExtVRStateUpdateMsg(t_String szBTAddr,
                                         tenExtVRState enExtVRState,
                                         tenVRErrorCode enVRErrorCode): 
                     m_pszBTAddr(NULL),
                     m_enExtVRState(enExtVRState),
                     m_enVRErrorCode(enVRErrorCode)

{
   ETG_TRACE_USR1(("ExtVRStateUpdateMsg::ExtVRStateUpdateMsg entered "));
   vAllocateMsg();
   if (NULL != m_pszBTAddr)
   {
      (*m_pszBTAddr) = szBTAddr;
   }   
}

/***************************************************************************
 ** FUNCTION:  ExtVRStateUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(ExtVRStateUpdateMsg, spi_tclExtTelephoneDispatcher);

/***************************************************************************
 ** FUNCTION:  ExtVRStateUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void ExtVRStateUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("ExtVRStateUpdateMsg::vAllocateMsg entered"));
   m_pszBTAddr = new t_String;
   SPI_NORMAL_ASSERT(NULL == m_pszBTAddr);   
}

/***************************************************************************
 ** FUNCTION:  ExtVRStateUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void ExtVRStateUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("ExtVRStateUpdateMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_pszBTAddr);
}

//!class spi_tclExtTelephoneDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtTelephoneDispatcher::spi_tclExtTelephoneDispatcher
 ***************************************************************************/
spi_tclExtTelephoneDispatcher::spi_tclExtTelephoneDispatcher()
{
   ETG_TRACE_USR1(("spi_tclExtTelephoneDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtTelephoneDispatcher::~spi_tclExtTelephoneDispatcher
 ***************************************************************************/
spi_tclExtTelephoneDispatcher::~spi_tclExtTelephoneDispatcher()
{
   ETG_TRACE_USR1(("~spi_tclExtTelephoneDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtTelephoneDispatcher::TelephoneCallActivityMsg(TelephoneCallActivityMsg...)
 ***************************************************************************/
t_Void spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg(TelephoneCallActivityMsg* poTelephoneCallActivityMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg entered "));
   if (NULL != poTelephoneCallActivityMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespTelephone,
               e16EXT_TELEPHONE_REGID,
               vPostTelephoneCallActivityMsg((poTelephoneCallActivityMsg)->m_bCallActive));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtTelephoneDispatcher::TelephoneCallStatusMsg(TelephoneCallStatusMsg...)
 ***************************************************************************/
t_Void spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg(TelephoneCallStatusMsg* poTelephoneCallStatusMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg entered "));
   if ((NULL != poTelephoneCallStatusMsg) && (NULL != poTelephoneCallStatusMsg->m_pTelCallStatusInfoList))
   {
      CALL_REG_OBJECTS(spi_tclExtRespTelephone,
               e16EXT_TELEPHONE_REGID,
               vPostTelephoneCallStatusMsg(*(poTelephoneCallStatusMsg->m_pTelCallStatusInfoList)));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtTelephoneDispatcher::ExtVRStateUpdateMsg(ExtVRStateUpdateMsg...)
 ***************************************************************************/
t_Void spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg(ExtVRStateUpdateMsg* poExtVRStateUpdateMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg entered "));
   if (NULL != poExtVRStateUpdateMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespTelephone,
               e16EXT_TELEPHONE_REGID,
               vPostExtVRStateUpdateMsg(*((poExtVRStateUpdateMsg)->m_pszBTAddr),
                                        (poExtVRStateUpdateMsg)->m_enExtVRState,
                                        (poExtVRStateUpdateMsg)->m_enVRErrorCode));
   }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
