/***********************************************************************/
/*!
 * \file  spi_tclExtTelephoneDispatcher.h
 * \brief Message Dispatcher for Telephone Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Telephone Messages
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                   | Modification
 10.4.2018  | BDU6KOR(Dhanya)          | Initial Version

 \endverbatim
 ***************************************************************************/
#ifndef _SPI_TCLEXTTELEPHONEDISPATCHER_H_
#define _SPI_TCLEXTTELEPHONEDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"
#include "spi_BluetoothTypedefs.h"

/**************Forward Declarations******************************************/
class spi_tclExtTelephoneDispatcher;

/****************************************************************************/
/*!
 * \class TelephoneMsgBase
 * \brief Base Message type for all Telephone messages
 ****************************************************************************/
class TelephoneMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  TelephoneMsgBase::TelephoneMsgBase
    ***************************************************************************/
   /*!
    * \fn      TelephoneMsgBase()
    * \brief   Default constructor
    **************************************************************************/
      TelephoneMsgBase();

   /***************************************************************************
    ** FUNCTION:  TelephoneMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   pTelephoneDispatcher : pointer to Message dispatcher for Telephone
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  TelephoneMsgBase::~TelephoneMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~TelephoneMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~TelephoneMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class TelephoneCallActivityMsg
 * \brief Telephone Connection Result msg
 ****************************************************************************/
class TelephoneCallActivityMsg: public TelephoneMsgBase
{
   public:

      t_Bool m_bCallActive;
   /***************************************************************************
    ** FUNCTION:  TelephoneCallActivityMsg::TelephoneCallActivityMsg
    ***************************************************************************/
   /*!
    * \fn      TelephoneCallActivityMsg(t_Bool bCallActive)
    * \brief   Parameterized  constructor
    * \param   [IN] bCallActive : call is active or not checking
    **************************************************************************/
      TelephoneCallActivityMsg(t_Bool bCallActive);

   /***************************************************************************
    ** FUNCTION:  TelephoneCallActivityMsg::~TelephoneCallActivityMsg
    ***************************************************************************/
   /*!
    * \fn      ~TelephoneCallActivityMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~TelephoneCallActivityMsg(){}

   /***************************************************************************
    ** FUNCTION:  TelephoneCallActivityMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poTelephoneDispatcher : pointer to Message dispatcher for Telephone
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher);

   /***************************************************************************
    ** FUNCTION:  TelephoneCallActivityMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  TelephoneCallActivityMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class TelephoneCallStatusMsg
 * \brief Telephone Connection Result msg
 ****************************************************************************/
class TelephoneCallStatusMsg: public TelephoneMsgBase
{
   public:

      std::vector<trTelCallStatusInfo> *m_pTelCallStatusInfoList;
   /***************************************************************************
    ** FUNCTION:  TelephoneCallStatusMsg::TelephoneCallStatusMsg
    ***************************************************************************/
   /*!
    * \fn      TelephoneCallStatusMsg(trTelCallStatusInfo m_poTelCallStatusInfo)
    * \brief   Parameterized  constructor
    * \param   [IN] m_poTelCallStatusInfo : structure of call status
    **************************************************************************/
      TelephoneCallStatusMsg(const std::vector<trTelCallStatusInfo> &rTelCallStatusInfo);

   /***************************************************************************
    ** FUNCTION:  TelephoneCallStatusMsg::~TelephoneCallStatusMsg
    ***************************************************************************/
   /*!
    * \fn      ~TelephoneCallStatusMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~TelephoneCallStatusMsg(){}

   /***************************************************************************
    ** FUNCTION:  TelephoneCallStatusMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poTelephoneDispatcher : pointer to Message dispatcher for Telephone
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher);

   /***************************************************************************
    ** FUNCTION:  TelephoneCallStatusMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  TelephoneCallStatusMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class ExtVRStateUpdateMsg
 * \brief Telephone External VR state update msg for Myspin
 ****************************************************************************/
class ExtVRStateUpdateMsg: public TelephoneMsgBase
{
   public:
          t_String *m_pszBTAddr;
          tenExtVRState m_enExtVRState;
          tenVRErrorCode m_enVRErrorCode;
          
   /***************************************************************************
    ** FUNCTION:  ExtVRStateUpdateMsg::ExtVRStateUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ExtVRStateUpdateMsg(t_String szBTAddress,
    *                          tenExtVRState e8ExtVRState,
    *                          tenVRErrorCode enVRErrorCode)
    * \brief   Parameterized  constructor
    * \param   [IN] e8ExtVRState : External VR state 
    * \param   szBTAddress : BT address
    * \param   enVRErrorCode : VR error codes    
    **************************************************************************/
    ExtVRStateUpdateMsg(t_String szBTAddr,
                        tenExtVRState enExtVRState,
                        tenVRErrorCode enVRErrorCode);

   /***************************************************************************
    ** FUNCTION:  ExtVRStateUpdateMsg::~ExtVRStateUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ~ExtVRStateUpdateMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~ExtVRStateUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  ExtVRStateUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poTelephoneDispatcher : pointer to Message dispatcher for Telephone
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtTelephoneDispatcher* poTelephoneDispatcher);

   /***************************************************************************
    ** FUNCTION:  ExtVRStateUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  ExtVRStateUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclExtTelephoneDispatcher
 * \brief Message Dispatcher for Telephone Messages
 ****************************************************************************/
class spi_tclExtTelephoneDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtTelephoneDispatcher::spi_tclExtTelephoneDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtTelephoneDispatcher()
    * \brief   Default constructor
    **************************************************************************/
   spi_tclExtTelephoneDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtTelephoneDispatcher::~spi_tclExtTelephoneDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtTelephoneDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtTelephoneDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg(TelephoneCallActivityMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleTelephoneMsg(TelephoneCallActivityMsg* poTelephoneCallActivityMsg)
    * \brief   Handles Messages of TelephoneCallActivityMsg type
    * \param   poTelephoneCallActivityMsg : pointer to TelephoneCallActivityMsg.
    **************************************************************************/
   t_Void vHandleTelephoneMsg(TelephoneCallActivityMsg* poTelephoneCallActivityMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg(TelephoneCallStatusMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleTelephoneMsg(TelephoneCallStatusMsg* poTelephoneCallStatusMsg)
    * \brief   Handles Messages of TelephoneCallStatusMsg type
    * \param   poTelephoneCallStatusMsg : pointer to TelephoneCallStatusMsg.
    **************************************************************************/
   t_Void vHandleTelephoneMsg(TelephoneCallStatusMsg* poTelephoneCallStatusMsg) const;
   
   /***************************************************************************
    ** FUNCTION:  spi_tclExtTelephoneDispatcher::vHandleTelephoneMsg(ExtVRStateUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleTelephoneMsg(ExtVRStateUpdateMsg* poExtVRStateUpdateMsg)
    * \brief   Handles Messages of ExtVRStateUpdateMsg type
    * \param   poExtVRStateUpdateMsg : pointer to ExtVRStateUpdateMsg.
    **************************************************************************/
   t_Void vHandleTelephoneMsg(ExtVRStateUpdateMsg* poExtVRStateUpdateMsg) const;   

};

#endif /* _SPI_TCLEXTTELEPHONEDISPATCHER_H_ */
