/*!
*******************************************************************************
* \file              spi_tclExtCmdTelephone.h
* \brief             Telephone Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Telephone Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
10/04/2018 |  BDU6KOR(Dhanya)             | Initial Version
\endverbatim
******************************************************************************/
#ifndef SPI_TCLEXTCMDTELEPHONE_H_
#define SPI_TCLEXTCMDTELEPHONE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdTelephoneIntf.h"
#include "spi_BluetoothTypedefs.h"

class spi_tclTelephoneClient;

class spi_tclExtCmdTelephone: public spi_tclExtCmdTelephoneIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdTelephone::spi_tclExtCmdTelephone()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdTelephone()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
	spi_tclExtCmdTelephone();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdTelephone::~spi_tclExtCmdTelephone()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdTelephone)
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdTelephone();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdTelephone::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdTelephone::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerAcceptCall(
              t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerAcceptCall(t_U16 u16CallInstance)
   * \brief   Method to trigger call accept.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   t_Void vTriggerAcceptCall(t_U16 u16CallInstance);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerHangUpCall(
   t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerHangUpCall(t_U16 u16CallInstance)
   * \brief   Method to trigger call hangup.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   t_Void vTriggerHangUpCall(t_U16 u16CallInstance);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerRejectCall(
   t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerRejectCall(t_U16 u16CallInstance)
   * \brief   Method to trigger call reject.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   t_Void  vTriggerRejectCall(t_U16 u16CallInstance);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerCancelCall(
   t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerCancelCall(t_U16 u16CallInstance)
   * \brief   Method to trigger call cancel.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   t_Void  vTriggerCancelCall(t_U16 u16CallInstance);
   
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vActivateExtVR(t_String szBTAddress)
   ***************************************************************************/
   /*!
   * \fn      vActivateExtVR(t_String szBTAddress)
   * \brief   Method to request activation of myspin VR.
   * \param   szBTAddress: [IN] BT address
   * \retval  NONE
   **************************************************************************/   
   t_Void vActivateExtVR(t_String szBTAddress);
   
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vDeActivateExtVR(t_String szBTAddress)
   ***************************************************************************/
   /*!
   * \fn      vDeActivateExtVR(t_String szBTAddress)
   * \brief   Method to request deactivation of myspin VR.
   * \param   szBTAddress: [IN] BT address
   * \retval  NONE
   **************************************************************************/   
   t_Void vDeActivateExtVR(t_String szBTAddress);
   
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vDialExtended(...
   ***************************************************************************/
   /*!
   * \fn      vDialExtended(t_String szTelephoneNumber,
   *                        t_String szName,
   *                        tenEcnrSetting enEcnrSetting)
   * \brief   Method to deactivate external VR
   * \param   szTelephoneNumber: [IN]Telephone number
   * \param   szName: [IN]Contact name
   * \param   enEcnrSetting: [IN]Ecnr setting   
   * \retval  NONE
   **************************************************************************/   
   t_Void vDialExtended(t_String szTelephoneNumber,
                        t_String szName,
                        tenEcnrSetting enEcnrSetting);    

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tVoid spi_tclExtCmdTelephone::vOnTelephoneCallActivity()
   ***************************************************************************/
   /*!
   * \fn      vOnTelephoneCallActivity(t_Bool bCallActive)
   * \brief   Interface to receive Telephone call activity info
   * \param   bCallActive : [IN] true - If any call is active, else false.
   **************************************************************************/
   t_Void vOnTelephoneCallActivity(t_Bool bCallActive);

   /***************************************************************************
   ** FUNCTION:  tVoid spi_tclExtCmdTelephone::vOnTelephoneCallStatus()
   ***************************************************************************/
   /*!
   * \fn      vOnTelephoneCallStatus(trTelCallStatusInfo rTelCallStatusInfo)
   * \brief   Interface to receive Telephone call activity info
   * \param   rTelCallStatusInfo :Call info structure
   **************************************************************************/
   t_Void vOnTelephoneCallStatus(const std::vector<trTelCallStatusInfo>& rTelCallStatusInfo);
   
   /***************************************************************************
   ** FUNCTION:  tVoid spi_tclExtCmdTelephone::vOnExtVRStateUpdate()
   ***************************************************************************/
   /*!
   * \fn      vOnExtVRStateUpdate(t_String szBTAddress,
   *                           tenExtVRState e8ExtVRState,
   *                           tenVRErrorCode enVRErrorCode)
   * \brief   Property update which provides Myspin VR state
   * \param   enExtVRState : Myspin VR state
   * \param   szBTAddress : BT address
   * \param   enVRErrorCode : VR error codes
   **************************************************************************/   
   t_Void vOnExtVRStateUpdate(t_String szBTAddress,
                              tenExtVRState enExtVRState,
                              tenVRErrorCode enVRErrorCode);

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephone::vRegisterTelCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterTelCallbacks()
   * \brief   register for Telephone callbacks.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterTelCallbacks();

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   //! Telephone client handler pointer
   spi_tclTelephoneClient* m_poTelClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif /* SPI_TCLEXTCMDTELEPHONE_H_ */
