/***********************************************************************/
/*!
 * \file  spi_tclExtSensorDataDispatcher.h
 * \brief Message Dispatcher for Sensor Messages.Implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Sensor Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  |Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTSENSORDATADISPATCHER_H_
#define _SPI_TCLEXTSENSORDATADISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclExtSensorDataDispatcher;

/****************************************************************************/
/*!
 * \class SensorMsgBase
 * \brief Base Message type for all Sensor messages
 ****************************************************************************/
class SensorMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  SensorMsgBase::SensorMsgBase
    ***************************************************************************/
   /*!
    * \fn      SensorMsgBase()
    * \brief   Default constructor
    **************************************************************************/
   SensorMsgBase();

   /***************************************************************************
    ** FUNCTION:  SensorMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poSensorDispatcher : pointer to Message dispatcher for Sensor
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  SensorMsgBase::~SensorMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~SensorMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~SensorMsgBase()
   {

   }
};


/****************************************************************************/
/*!
 * \class SensorDataMsg
 * \brief Configure Sensor Result msg
 ****************************************************************************/
class SensorDataMsg: public SensorMsgBase
{
   public:

      trSensorData m_rSensorData;
   /***************************************************************************
    ** FUNCTION:  SensorDataMsg::SensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      SensorDataMsg()
    * \brief   Default constructor
    **************************************************************************/
   SensorDataMsg();

   /***************************************************************************
    ** FUNCTION:  SensorDataMsg::SensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      SensorDataMsg(trSensorData rSensorData)
    * \brief   Paramaterized constructor
    **************************************************************************/
   SensorDataMsg(trSensorData rSensorData);

   /***************************************************************************
    ** FUNCTION:  SensorDataMsg::~SensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~SensorDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~SensorDataMsg(){}

   /***************************************************************************
    ** FUNCTION:  SensorDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poSensorDispatcher : pointer to Message dispatcher for Sensor
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher);

   /***************************************************************************
    ** FUNCTION:  SensorDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  SensorDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class AccSensorDataMsg
 * \brief Configure Sensor Result msg
 ****************************************************************************/
class AccSensorDataMsg: public SensorMsgBase
{
   public:

      std::vector<trAccSensorData> *m_poVecrAccSensorData;
   /***************************************************************************
    ** FUNCTION:  AccSensorDataMsg::AccSensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      AccSensorDataMsg()
    * \brief   Default constructor
    **************************************************************************/
      AccSensorDataMsg();

   /***************************************************************************
    ** FUNCTION:  AccSensorDataMsg::AccSensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      AccSensorDataMsg(std::vector<trAccSensorData> &corfVecrAccSensorData)
    * \brief   Paramaterized constructor
    **************************************************************************/
      AccSensorDataMsg(const std::vector<trAccSensorData> &corfVecrAccSensorData);

   /***************************************************************************
    ** FUNCTION:  AccSensorDataMsg::~AccSensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~AccSensorDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AccSensorDataMsg(){}

   /***************************************************************************
    ** FUNCTION:  AccSensorDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poSensorDispatcher : pointer to Message dispatcher for Sensor
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher);

   /***************************************************************************
    ** FUNCTION:  AccSensorDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AccSensorDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class GyroSensorDataMsg
 * \brief Configure Sensor Result msg
 ****************************************************************************/
class GyroSensorDataMsg: public SensorMsgBase
{
   public:

      std::vector<trGyroSensorData> *m_poVecrGyroSensorData;
   /***************************************************************************
    ** FUNCTION:  GyroSensorDataMsg::GyroSensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      GyroSensorDataMsg()
    * \brief   Default constructor
    **************************************************************************/
      GyroSensorDataMsg();

   /***************************************************************************
    ** FUNCTION:  GyroSensorDataMsg::GyroSensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      GyroSensorDataMsg(std::vector<trGyroSensorData> &corfVecrGyroSensorData)
    * \brief   Paramaterized constructor
    **************************************************************************/
      GyroSensorDataMsg(const std::vector<trGyroSensorData> &corfVecrGyroSensorData);

   /***************************************************************************
    ** FUNCTION:  GyroSensorDataMsg::~GyroSensorDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~GyroSensorDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~GyroSensorDataMsg(){}

   /***************************************************************************
    ** FUNCTION:  GyroSensorDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poSensorDispatcher : pointer to Message dispatcher for Sensor
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtSensorDataDispatcher* poSensorDispatcher);

   /***************************************************************************
    ** FUNCTION:  GyroSensorDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  GyroSensorDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class spi_tclExtSensorDataDispatcher
 * \brief Message Dispatcher for Sensor Messages
 ****************************************************************************/
class spi_tclExtSensorDataDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtSensorDataDispatcher::spi_tclExtSensorDataDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtSensorDataDispatcher()
    * \brief   Default constructor
    **************************************************************************/
      spi_tclExtSensorDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtSensorDataDispatcher::~spi_tclExtSensorDataDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtSensorDataDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtSensorDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtSensorDataDispatcher::vHandleSensorMsg(SensorDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleSensorMsg(SensorDataMsg* poSensorDataMsg)
    * \brief   Handles Messages of SensorDataMsg type
    * \param   poSensorDataMsg : pointer to SensorDataMsg.
    **************************************************************************/
   t_Void vHandleSensorMsg(SensorDataMsg* poSensorDataMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtSensorDataDispatcher::vHandleSensorMsg(SensorDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleSensorMsg(AccSensorDataMsg *poAccSensorDataMsg)
    * \brief   Handles Messages of AccSensorDataMsg type
    * \param   poAccSensorDataMsg : pointer to AccSensorDataMsg.
    **************************************************************************/
   t_Void vHandleSensorMsg(AccSensorDataMsg *poAccSensorDataMsg)const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtSensorDataDispatcher::vHandleSensorMsg(SensorDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleSensorMsg(GyroSensorDataMsg *poGyroSensorDataMsg)
    * \brief   Handles Messages of GyroSensorDataMsg type
    * \param   poGyroSensorDataMsg : pointer to GyroSensorDataMsg.
    **************************************************************************/
   t_Void vHandleSensorMsg(GyroSensorDataMsg *poGyroSensorDataMsg)const;

};
#endif /* _SPI_TCLEXTSENSORDATADISPATCHER_H_ */
