/***********************************************************************/
/*!
 * \file  spi_tclExtRoleSwitchDispatcher.cpp
 * \brief Message Dispatcher for Role Switch Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Role Switch Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 20.01.2017  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtRoleSwitchDispatcher.h"
#include "spi_tclExtRespRoleSwitch.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtRoleSwitchDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleRoleSwitchCompleteMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  RoleSwitchCompleteMsgBase::RoleSwitchCompleteMsgBase
 ***************************************************************************/
RoleSwitchCompleteMsgBase::RoleSwitchCompleteMsgBase()
{
   ETG_TRACE_USR1(("RoleSwitchCompleteMsgBase::RoleSwitchCompleteMsgBase entered\n"));
   vSetServiceID(e32MODULEID_ROLESWITCH);
}

//!class RoleSwitchCompleteMsg
/***************************************************************************
 ** FUNCTION:  RoleSwitchCompleteMsg::RoleSwitchCompleteMsg
 ***************************************************************************/
RoleSwitchCompleteMsg::RoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus):
                                             m_cou32DeviceHandle(cou32DeviceHandle),
                                             m_bSwitchStatus(bSwitchStatus)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  RoleSwitchCompleteMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(RoleSwitchCompleteMsg, spi_tclExtRoleSwitchDispatcher);

/***************************************************************************
 ** FUNCTION:  RoleSwitchCompleteMsg::vAllocateMsg
 ***************************************************************************/
t_Void RoleSwitchCompleteMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]RoleSwitchCompleteMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  RoleSwitchCompleteMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void RoleSwitchCompleteMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]RoleSwitchCompleteMsg::vDeAllocateMsg entered\n"));
}


//!class spi_tclExtRoleSwitchDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtRoleSwitchDispatcher::spi_tclExtRoleSwitchDispatcher
 ***************************************************************************/
spi_tclExtRoleSwitchDispatcher::spi_tclExtRoleSwitchDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtRoleSwitchDispatcher::spi_tclExtRoleSwitchDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtRoleSwitchDispatcher::~spi_tclExtRoleSwitchDispatcher
 ***************************************************************************/
spi_tclExtRoleSwitchDispatcher::~spi_tclExtRoleSwitchDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtRoleSwitchDispatcher::~spi_tclExtRoleSwitchDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtRoleSwitchDispatcher::vHandleRoleSwitchCompleteMsg(RoleSwitchCompleteMsg...)
 ***************************************************************************/
t_Void spi_tclExtRoleSwitchDispatcher::vHandleRoleSwitchCompleteMsg(RoleSwitchCompleteMsg *poRoleSwitchCompleteMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtRoleSwitchDispatcher::vHandleRoleSwitchCompleteMsg entered "));
   if (NULL != poRoleSwitchCompleteMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespRoleSwitch,
               e16EXT_ROLESWITCH_REGID,
               vPostRoleSwitchCompleteMsg((poRoleSwitchCompleteMsg->m_cou32DeviceHandle),poRoleSwitchCompleteMsg->m_bSwitchStatus ));
   }
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
