/*!
*******************************************************************************
* \file              spi_tclExtCmdRoleSwitch.cpp
* \brief             Role Switch Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Role Switch Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
20.01.2017  |  Dhiraj Asopa                 | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "Trace.h"
#include "ExtInterfacesTypes.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtCompMsgQInterface.h"
#include "spi_tclExtRoleSwitchDispatcher.h"
#include "spi_tclExtCmdRoleSwitch.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdRoleSwitch.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdRoleSwitch:: spi_tclExtCmdRoleSwitch(t_Void)
*******************************************************************************/

spi_tclExtCmdRoleSwitch::spi_tclExtCmdRoleSwitch() : m_poMPlayClientHandler(NULL)
{
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdRoleSwitch::~spi_tclExtCmdRoleSwitch(t_Void)
*******************************************************************************/
spi_tclExtCmdRoleSwitch::~spi_tclExtCmdRoleSwitch()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdRoleSwitch::~spi_tclExtCmdRoleSwitch destructor entered "));
   m_poMPlayClientHandler  = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdRoleSwitch::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdRoleSwitch::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdRoleSwitch::bInitialize entered "));
   t_Bool bInit = false;
   spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
   if(NULL != poExtClientFactory)
   {
      m_poMPlayClientHandler = poExtClientFactory->poGetMPlayClientHandlerInstance();
      SPI_NORMAL_ASSERT(NULL == m_poMPlayClientHandler);
   }
   bInit = (NULL != m_poMPlayClientHandler);
   vRegisterRoleSwitchCallbacks();

   ETG_TRACE_USR1(("[DESC]spi_tclExtCmdRoleSwitch::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
   return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdRoleSwitch::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdRoleSwitch::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdRoleSwitch::bUnInitialize entered "));
   t_Bool bUninitSuccess = true;

   m_poMPlayClientHandler = NULL;

   ETG_TRACE_USR2(("[DESC]spi_tclExtCmdRoleSwitch::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
   return bUninitSuccess;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtCmdRoleSwitch::bRoleSwitchRequest()
 ***************************************************************************/
t_Bool spi_tclExtCmdRoleSwitch::bRoleSwitchRequest(t_U32 u32DeviceTag, tenDeviceConnectionReq enDevConnReq,trEAPAppInfo rEAPAppInfo,
                                tenDeviceCategory endDeviceCat)
{
   t_Bool bRoleSwitchRequestSuccess = false;
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdRoleSwitch::bRoleSwitchRequest entered "));
   if (NULL != m_poMPlayClientHandler)
   {
      bRoleSwitchRequestSuccess=m_poMPlayClientHandler->bRoleSwitchRequest(u32DeviceTag,enDevConnReq,rEAPAppInfo,endDeviceCat);
   }
   return bRoleSwitchRequestSuccess;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdRoleSwitch::vRegisterRoleSwitchCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdRoleSwitch::vRegisterRoleSwitchCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdRoleSwitch::vRegisterRoleSwitchCallbacks() entered "));
   trDeviceSwitcherCbs rDeviceSwitcherCbs;
   rDeviceSwitcherCbs.fvDeviceSwitchCompleteCb = std::bind(&spi_tclExtCmdRoleSwitch::vOnRoleSwitchCompleteCb,
            this,
            SPI_FUNC_PLACEHOLDERS_2);
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRegisterCallbacks(rDeviceSwitcherCbs);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdRoleSwitch::vOnRoleSwitchCompleteCb(...)
***************************************************************************/
t_Void spi_tclExtCmdRoleSwitch::vOnRoleSwitchCompleteCb(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdRoleSwitch::vOnRoleSwitchCompleteCb() entered "));
   RoleSwitchCompleteMsg oRoleSwitchCompleteMsg(cou32DeviceHandle, bSwitchStatus);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oRoleSwitchCompleteMsg,sizeof(oRoleSwitchCompleteMsg));
   }//if (NULL != poExtMsgQinterface)
}
//lint –restore

