/*!
*******************************************************************************
* \file              spi_tclExtCmdRoleSwitchIntf.h
* \brief             Role Switch Adapter Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to register/un-register
                with Role Switch data provider.
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
20.01.2017 |  Dhiraj Asopa                | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDROLESWITCHINTF_H_
#define _SPI_TCLEXTCMDROLESWITCHINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
/**
* \brief  Role Switch Intf class
*/
class spi_tclExtCmdRoleSwitchIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdRoleSwitchIntf::
   **                      ~spi_tclExtCmdRoleSwitchIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdRoleSwitchIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdRoleSwitchIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdRoleSwitchIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdRoleSwitchIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdRoleSwitchIntf::bRoleSwitchRequest()
    ***************************************************************************/
   /*!
    * \fn      bRoleSwitchRequest()
    * \brief   Function to activate the dipo device
    * \sa      bRoleSwitchRequest()
    **************************************************************************/

   virtual t_Bool bRoleSwitchRequest(t_U32 u32DeviceTag, tenDeviceConnectionReq enDevConnReq, trEAPAppInfo rEAPAppInfo, tenDeviceCategory endDeviceCat = e8DEV_TYPE_DIPO)=0;

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDRoleSwitchIntf_H_

