
/***********************************************************************/
/*!
 * \file  spi_tclExtPositionDataDispatcher.cpp
 * \brief Message Dispatcher for Position Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Position Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  | Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtPositionDataDispatcher.h"
#include "spi_tclExtRespPositionData.h"
//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtPositionDataDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandlePositionMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  PositionMsgBase::PositionMsgBase
 ***************************************************************************/
PositionMsgBase::PositionMsgBase()
{
   ETG_TRACE_USR1(("[FUNC]PositionMsgBase::PositionMsgBase entered\n"));
   vSetServiceID(e32MODULEID_EXTPOSITION);
}

//!class PositionDataMsg
/***************************************************************************
 ** FUNCTION:  PositionDataMsg::PositionDataMsg
 ***************************************************************************/
PositionDataMsg::PositionDataMsg()
{
   ETG_TRACE_USR1(("[FUNC]PositionDataMsg::PositionDataMsg constructor entered \n"));
}

/***************************************************************************
 ** FUNCTION:  PositionDataMsg::PositionDataMsg
 ***************************************************************************/
PositionDataMsg::PositionDataMsg(trDeadReckoningData rDeadReckoningData):
         m_rDeadReckoningData(rDeadReckoningData)
{
   vAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  PositionDataMsg::~PositionDataMsg()
 ***************************************************************************/
PositionDataMsg::~PositionDataMsg()
{
   ETG_TRACE_USR1(("[FUNC]PositionDataMsg::~PositionDataMsg entered "));
   vAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  PositionDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(PositionDataMsg, spi_tclExtPositionDataDispatcher);

/***************************************************************************
 ** FUNCTION:  PositionDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void PositionDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]PositionDataMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  PositionDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void PositionDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]PositionDataMsg::vDeAllocateMsg entered\n"));
}

//!class spi_tclExtPositionDataDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtPositionDataDispatcher::spi_tclExtPositionDataDispatcher
 ***************************************************************************/
spi_tclExtPositionDataDispatcher::spi_tclExtPositionDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]pi_tclExtPositionDispatcher::spi_tclExtPositionDataDispatcher constructor entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtPositionDataDispatcher::~spi_tclExtPositionDataDispatcher
 ***************************************************************************/
spi_tclExtPositionDataDispatcher::~spi_tclExtPositionDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]pi_tclExtPositionDispatcher::~spi_tclExtPositionDataDispatcher destructor entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtPositionDataDispatcher::vHandlePositionMsg()
 ***************************************************************************/
t_Void spi_tclExtPositionDataDispatcher::vHandlePositionMsg(PositionDataMsg *poPosDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtPositionDataDispatcher::vHandlePositionMsg entered "));
   if (NULL != poPosDataMsg)
     {
        CALL_REG_OBJECTS(spi_tclExtRespPositionData,
                 e16EXT_POSITION_REGID,
                 vPostPositionDataResult(poPosDataMsg->m_rDeadReckoningData));
     }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
