/*!
*******************************************************************************
* \file              spi_tclExtCmdPositionDataIntf.h
* \brief             Position Data Adapter Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to register/un-register
                with position data provider.
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
09.01.2017 |  Dhiraj Asopa                | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCL_EXT_CMD_POSITION_DATA_INTF_H_
#define _SPI_TCL_EXT_CMD_POSITION_DATA_INTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
/**
* \brief   Position Data class
*/
class spi_tclExtCmdPositionDataIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdPositionDataIntf::~spi_tclExtCmdPositionDataIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdPositionDataIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdPositionDataIntf(){}
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdPositionDataIntf::vStartLocData(tenSensorDataType enDataType)
   ***************************************************************************/
   /*!
   * \fn      vStartLocData()
   * \brief   This function is called to start location data
   * \param   enDataType: [IN] Identifies type of data to be registered
   * \sa
   **************************************************************************/
   virtual t_Void vStartLocData(tenSensorDataType enDataType)=0;
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdPositionDataIntf:: vStopLocData(tenSensorDataType enDataType)
   ***************************************************************************/
   /*!
   * \fn      vStopLocData()
   * \brief   This function is called for stop location data.
   * \param   enDataType: [IN] Identifies type of data to be registered
   * \sa
   **************************************************************************/
   virtual t_Void vStopLocData(tenSensorDataType enDataType)=0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdPositionDataIntf:: spi_tclExtCmdPositionDataIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize()=0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdPositionDataIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize()=0;



   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // _SPI_TCL_EXT_CMD_POSITION_DATA_INTF_H_

