/*!
*******************************************************************************
* \file              spi_tclExtCmdPositionData.h
* \brief             Position Data Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Pos Data Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
29.09.2016 |  Dhiraj Asopa                | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDPOSITIONDATA_H_
#define _SPI_TCLEXTCMDPOSITIONDATA_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdPositionDataIntf.h"

class spi_tclSensorPVDataClientHandler;
class spi_tclExtCmdPositionData: public spi_tclExtCmdPositionDataIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdPositionData::spi_tclExtCmdPositionData()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdPositionData()
   * \brief   Default constructor
   * \sa
   **************************************************************************/

   spi_tclExtCmdPositionData();
   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdPositionData::~spi_tclExtCmdPositionData()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdPositionData()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdPositionData();

   /***************************************************************************
   * Application specific methods.
   ***************************************************************************/
   /***************************************************************************
      ** FUNCTION:  t_Void spi_tclExtCmdPositionData::vStartLocData(tenSensorDataType enDataType)
      ***************************************************************************/
      /*!
      * \fn      vStartLocData(tenSensorDataType enDataType)
      * \brief   This function is called for start sensor
      * \param   enDataType: [IN] Identifies type of data to be registered
      * \sa
      **************************************************************************/
   /**************************************************************************/
    t_Void vStartLocData(tenSensorDataType enDataType);
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdPositionData::vStopSensorData()
   ***************************************************************************/
   /*!
   * \fn      vStopSensorData(tenSensorDataType enDataType,const trSensorDataCallbacks& rfcorSensorDataCb)
   * \brief   This function is called for stop sensor
   * \param   enDataType: [IN] Identifies type of data to be registered
   *             to be called when subscribed data is received by client handler.
   * \sa
   **************************************************************************/
   t_Void vStopLocData(tenSensorDataType enDataType);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdPositionData::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdPositionData::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdPositionData::vOnDeadReckoningData()
    ***************************************************************************/
   /*!
    * \fn      vOnDeadReckoningData()
    * \brief   Method to get Dead Reckoning Data
    * \[PARAM] trDeadReckoningData:Structure for holding DeadReckoning data
    * \sa      bInitialize()
    **************************************************************************/
   t_Void vOnDeadReckoningData(trDeadReckoningData rDeadReckoningData);


   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   spi_tclSensorPVDataClientHandler *m_poPosDataClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // _SPI_TCLEXTCMDPOSITIONDATA_H_



