/*!
*******************************************************************************
* \file              spi_tclExtCmdNavData.cpp
* \brief             Nav Data Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Nav Data Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
24.01.2017  | Dhiraj Asopa                  | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdNavData.h"
#include "Trace.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtCompMsgQInterface.h"
#include "spi_tclExtNavDataDispatcher.h"
#include "spi_tclDeviceIDDataIntf.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdNavData.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNavData:: spi_tclExtCmdNavData(t_Void)
*******************************************************************************/

spi_tclExtCmdNavData::spi_tclExtCmdNavData() : m_poMPlayClientHandler(NULL)
{
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNavData::~spi_tclExtCmdNavData(t_Void)
*******************************************************************************/
spi_tclExtCmdNavData::~spi_tclExtCmdNavData()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::~spi_tclExtCmdNavData destructor entered "));
   m_poMPlayClientHandler  = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNavData::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdNavData::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::bInitialize entered "));
   t_Bool bInit = false;
   spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
   if(NULL != poExtClientFactory)
   {
      m_poMPlayClientHandler = poExtClientFactory->poGetMPlayClientHandlerInstance();
      SPI_NORMAL_ASSERT(NULL == m_poMPlayClientHandler);
   }

   bInit = (NULL != m_poMPlayClientHandler);

   vRegisterNavDataCallbacks();
   vRegisterTBTCallbacks();

   if(NULL != m_poMPlayClientHandler)
   {
       m_poMPlayClientHandler->vRegisterForNavigationProperties();
   }

   ETG_TRACE_USR1(("[DESC]spi_tclExtCmdNavData::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
   return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNavData::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdNavData::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::bUnInitialize entered "));
   t_Bool bUninitSuccess = true;

   m_poMPlayClientHandler = NULL;

   ETG_TRACE_USR2(("[DESC]spi_tclExtCmdNavData::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
   return bUninitSuccess;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdNavData::bTransferGPSData(...)
***************************************************************************/
t_Bool spi_tclExtCmdNavData::bTransferGPSData(t_U32 u32DeviceHandle, t_String szDeviceSerialNo,
         t_String szGPGGAData, t_String szGPRMCData,
         t_String szGPGSVData, t_String szGPHDTData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::bTransferGPSData entered "));
   t_Bool bResult = false;
   if(NULL != m_poMPlayClientHandler)
   {
      bResult = m_poMPlayClientHandler->bTransferGPSData(u32DeviceHandle,szDeviceSerialNo,szGPGGAData,szGPRMCData,szGPGSVData,szGPHDTData);
   }
   return bResult;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdNavData::bTransferDrData(...)
***************************************************************************/
t_Bool spi_tclExtCmdNavData::bTransferDrData(t_U32 u32DeviceHandle, t_String szDeviceSerialNo,
         t_String szPASCDData, t_String szPAGCDData, t_String szPAACDData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::bGetDiPOAlbumArt entered "));
   t_Bool bResult = false;
   if(NULL != m_poMPlayClientHandler)
   {
      bResult = m_poMPlayClientHandler->bTransferDrData(u32DeviceHandle,szDeviceSerialNo,szPASCDData,szPAGCDData,szPAACDData);
   }
   return bResult;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vRegisterForNavDataProperties()
**************************************************************************/
t_Void spi_tclExtCmdNavData::vRegisterForNavDataProperties()
{
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRegisterForProperties();
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vUnregisterForNavDataProperties()
**************************************************************************/
t_Void spi_tclExtCmdNavData::vUnregisterForNavDataProperties()
{
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vUnregisterForProperties();
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vRegisterNavDataCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdNavData::vRegisterNavDataCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::vRegisterNavDataCallbacks() entered "));
   trDipoLocationInfoCallbacks rDipoLocationInfoCallbacks;
   rDipoLocationInfoCallbacks.fvOnDipoLocationInfo = std::bind(&spi_tclExtCmdNavData::vOnDipoLocationInfo, this,
                                                SPI_FUNC_PLACEHOLDERS_3);
   rDipoLocationInfoCallbacks.fvOnDipoGPRMCDataStatusValues = std::bind(&spi_tclExtCmdNavData::vOnDipoGPRMCDataStatusValues, this,
                                                SPI_FUNC_PLACEHOLDERS_2);
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRegisterDipoLocationCallbacks(rDipoLocationInfoCallbacks);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vRegisterTBTCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdNavData::vRegisterTBTCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::vRegisterTBTCallbacks() entered "));
   trTBTCallbacks rTBTCallbacks;
   rTBTCallbacks.fvOnDiPORouteGuidanceUpdateCallback = std::bind(&spi_tclExtCmdNavData::vOnDiPORouteGuidanceUpdateCallback, this,
                                                                 SPI_FUNC_PLACEHOLDERS_1);
   rTBTCallbacks.fvOnDiPORouteGuidanceManeuverUpdateCallback = std::bind(&spi_tclExtCmdNavData::vOnDiPORouteGuidanceManeuverUpdateCallback,
                                                                         this, SPI_FUNC_PLACEHOLDERS_1);

   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRegisterTBTCallback(rTBTCallbacks);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnDipoLocationInfo()
***************************************************************************/
t_Void spi_tclExtCmdNavData::vOnDipoLocationInfo(t_Bool bStartLocData,const std::vector<tenNmeaSentenceType>& rfcoNmeaSentencesList,t_U8 u8RequestedBy)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::vOnDipoLocationInfo() entered "));
   DipoLocationInfoMsg oDipoLocationInfoMsg(bStartLocData,rfcoNmeaSentencesList,u8RequestedBy);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oDipoLocationInfoMsg,sizeof(oDipoLocationInfoMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnDipoGPRMCDataStatusValues()
***************************************************************************/
t_Void spi_tclExtCmdNavData::vOnDipoGPRMCDataStatusValues(t_U32 u32DeviceId,t_U8 u8GPRMCDataStatusValues)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::vOnDipoGPRMCDataStatusValues() entered "));
   DipoGPRMCDataStatusValuesInfoMsg oDipoGPRMCDataStatusValuesInfoMsg(u32DeviceId, u8GPRMCDataStatusValues);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oDipoGPRMCDataStatusValuesInfoMsg,sizeof(oDipoGPRMCDataStatusValuesInfoMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnDiPORouteGuidanceUpdateCallback()
***************************************************************************/
t_Void spi_tclExtCmdNavData::vOnDiPORouteGuidanceUpdateCallback(const trDiPORouteGuidanceUpdate& corfrDiPORouteGuidanceUpdate)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vOnDiPORouteGuidanceUpdateCallback() entered "));
    DiPORouteGuidanceUpdateMsg oDiPORouteGuidanceUpdateMsg(corfrDiPORouteGuidanceUpdate);
    spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
    if (NULL != poExtMsgQinterface)
    {
       poExtMsgQinterface->bWriteMsgToQ(&oDiPORouteGuidanceUpdateMsg,sizeof(oDiPORouteGuidanceUpdateMsg));
    }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnDiPORouteGuidanceManeuverUpdateCallback()
***************************************************************************/
t_Void spi_tclExtCmdNavData::vOnDiPORouteGuidanceManeuverUpdateCallback(
                        const trDiPORouteGuidanceManeuverUpdate& corfrDiPORouteGuidanceManeuverUpdate)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vOnDiPORouteGuidanceManeuverUpdateCallback() entered "));
    DiPORouteGuidanceManeuverUpdateMsg oDiPORouteGuidanceManeuverUpdateMsg(corfrDiPORouteGuidanceManeuverUpdate);
    spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
    if (NULL != poExtMsgQinterface)
    {
       poExtMsgQinterface->bWriteMsgToQ(&oDiPORouteGuidanceManeuverUpdateMsg,sizeof(oDiPORouteGuidanceManeuverUpdateMsg));
    }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vDipoStartRouteGuidanceUpdate()
**************************************************************************/
t_Void spi_tclExtCmdNavData::vDipoStartRouteGuidanceUpdate(const t_U32 cou32DevHandle)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vDipoStartRouteGuidanceUpdate() entered "));
    spi_tclDeviceIDDataIntf oDeviceIDDataIntf;
    t_String szDeviceSerialNumber;
    oDeviceIDDataIntf.vGetSerialNumber(szDeviceSerialNumber,cou32DevHandle);
    if(NULL != m_poMPlayClientHandler)
    {
        m_poMPlayClientHandler->vDipoStartRouteGuidanceUpdate(szDeviceSerialNumber);
    }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdNavData::vDipoStopRouteGuidanceUpdate()
**************************************************************************/
t_Void spi_tclExtCmdNavData::vDipoStopRouteGuidanceUpdate(const t_U32 cou32DevHandle)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vDipoStopRouteGuidanceUpdate() entered "));
    spi_tclDeviceIDDataIntf oDeviceIDDataIntf;
    t_String szDeviceSerialNumber;
    oDeviceIDDataIntf.vGetSerialNumber(szDeviceSerialNumber,cou32DevHandle);
    if(NULL != m_poMPlayClientHandler)
    {
        m_poMPlayClientHandler->vDipoStopRouteGuidanceUpdate(szDeviceSerialNumber);
    }
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdNavData::bOnRegRouteGuidanceDisplayConf()
**************************************************************************/
t_Bool spi_tclExtCmdNavData::bOnRegRouteGuidanceDisplayConf(const std::vector<trDiPORouteGuidanceDisplayComponent>& corfvecRouteGuidanceDisplayComponent)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::vDipoStartRouteGuidanceUpdate() entered "));
	t_Bool bResult = false;
    if(NULL != m_poMPlayClientHandler)
    {
        bResult = m_poMPlayClientHandler->bOnRegRouteGuidanceDisplayConf(corfvecRouteGuidanceDisplayComponent);
    }
	return bResult;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdNavData::bOnStartRouteGuidanceUpdates()
**************************************************************************/
t_Bool spi_tclExtCmdNavData::bOnStartRouteGuidanceUpdates(const t_U32 cou32DevHandle, trStartRouteGuidanceUpdates& rStartRouteGuidanceUpdates)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::bOnStartRouteGuidanceUpdates() entered "));
    spi_tclDeviceIDDataIntf oDeviceIDDataIntf;
    t_String szDevSerialNumber;
    oDeviceIDDataIntf.vGetSerialNumber(szDevSerialNumber,cou32DevHandle);
    rStartRouteGuidanceUpdates.szDeviceSerialNumber = szDevSerialNumber;
    t_Bool bResult = false;

    if(NULL != m_poMPlayClientHandler)
    {
        bResult = m_poMPlayClientHandler->bOnStartRouteGuidanceUpdates(rStartRouteGuidanceUpdates);
    }
    return bResult;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdNavData::bOnStopRouteGuidanceUpdates()
**************************************************************************/
t_Bool spi_tclExtCmdNavData::bOnStopRouteGuidanceUpdates(const t_U32 cou32DevHandle, trStopRouteGuidanceUpdates& rStopRouteGuidanceUpdates)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNavData::bOnStopRouteGuidanceUpdates() entered "));
    spi_tclDeviceIDDataIntf oDeviceIDDataIntf;
    t_String szDevSerialNumber;
    oDeviceIDDataIntf.vGetSerialNumber(szDevSerialNumber,cou32DevHandle);
    rStopRouteGuidanceUpdates.szDeviceSerialNumber = szDevSerialNumber;
    t_Bool bResult = false;

    if(NULL != m_poMPlayClientHandler)
    {
        bResult = m_poMPlayClientHandler->bOnStopRouteGuidanceUpdates(rStopRouteGuidanceUpdates);
    }
    return bResult;
}
//lint restore

