/***********************************************************************/
/*!
 * \file  spi_tclExtNavDataDispatcher.h
 * \brief Message Dispatcher for NavData Messages.Implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for NavData Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 30.01.2017  |Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTNAVDATADISPATCHER_H_
#define _SPI_TCLEXTNAVDATADISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"
#include "spi_TBTTypes.h"

/**************Forward Declarations******************************************/
class spi_tclExtNavDataDispatcher;

/****************************************************************************/
/*!
 * \class NavDataMsgBase
 * \brief Base Message type for all NavData messages
 ****************************************************************************/
class NavDataMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  NavDataMsgBase::NavDataMsgBase
    ***************************************************************************/
   /*!
    * \fn      NavDataMsgBase()
    * \brief   Default constructor
    **************************************************************************/
   NavDataMsgBase();

   /***************************************************************************
    ** FUNCTION:  NavDataMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poNavDataDispatcher : pointer to Message dispatcher for NavData
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  NavDataMsgBase::~NavDataMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~NavDataMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~NavDataMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class DipoLocationInfoMsg
 * \brief Configure NavData Result msg
 ****************************************************************************/
class DipoLocationInfoMsg: public NavDataMsgBase
{
   public:
    t_Bool m_bStartLocData;
    t_U8 m_u8RequestedBy;
    std::vector<tenNmeaSentenceType> *m_poVecrNmeaSentenceType;

   /***************************************************************************
    ** FUNCTION:  DipoLocationInfoMsg::DipoLocationInfoMsg
    ***************************************************************************/
   /*!
    * \fn      DipoLocationInfoMsg(const std::vector<tenNmeaSentenceType> &cocorfVecrNmeaSentenceType)
    * \brief   Paramaterized constructor
    **************************************************************************/
   DipoLocationInfoMsg(t_Bool bStartLocData,const std::vector<tenNmeaSentenceType> &cocorfVecrNmeaSentenceType,t_U8 u8RequestedBy);

   /***************************************************************************
    ** FUNCTION:  DipoLocationInfoMsg::~DipoLocationInfoMsg
    ***************************************************************************/
   /*!
    * \fn      ~DipoLocationInfoMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~DipoLocationInfoMsg(){}

   /***************************************************************************
    ** FUNCTION:  DipoLocationInfoMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poNavDataDispatcher : pointer to Message dispatcher for NavData
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  DipoLocationInfoMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  DipoLocationInfoMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class DipoGPRMCDataStatusValuesInfoMsg
 * \brief Configure GPRMCDataStatusValues msg
 ****************************************************************************/
class DipoGPRMCDataStatusValuesInfoMsg: public NavDataMsgBase
{
   public:
      t_U32 m_u32DeviceId;
      t_U8 m_u8GPRMCDataStatusValues;

   /***************************************************************************
    ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::DipoGPRMCDataStatusValuesInfoMsg
    ***************************************************************************/
   /*!
    * \fn      DipoGPRMCDataStatusValuesInfoMsg(...)
    * \brief   Paramaterized constructor
    **************************************************************************/
    DipoGPRMCDataStatusValuesInfoMsg(t_U32 u32DeviceId,t_U8 u8GPRMCDataStatusValues);

   /***************************************************************************
    ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::~DipoGPRMCDataStatusValuesInfoMsg
    ***************************************************************************/
   /*!
    * \fn      ~DipoGPRMCDataStatusValuesInfoMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~DipoGPRMCDataStatusValuesInfoMsg(){}

   /***************************************************************************
    ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poNavDataDispatcher : pointer to Message dispatcher for NavData
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class DiPORouteGuidanceUpdateMsg
 * \brief DiPORouteGuidanceUpdateMsg Msg
 ****************************************************************************/
class DiPORouteGuidanceUpdateMsg: public NavDataMsgBase
{
   public:
    trDiPORouteGuidanceUpdate *m_porDiPORouteGuidanceUpdate;

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceUpdateMsg::DiPORouteGuidanceUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      DiPORouteGuidanceUpdateMsg(const trDiPORouteGuidanceUpdate &corfrDiPORouteGuidanceUpdate)
    * \brief   Paramaterized constructor
    **************************************************************************/
    DiPORouteGuidanceUpdateMsg(const trDiPORouteGuidanceUpdate &corfrDiPORouteGuidanceUpdate);

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceUpdateMsg::~DiPORouteGuidanceUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ~DiPORouteGuidanceUpdateMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~DiPORouteGuidanceUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poNavDataDispatcher : pointer to Message dispatcher for NavData
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class DiPORouteGuidanceManeuverUpdateMsg
 * \brief DiPORouteGuidanceManeuverUpdateMsg Msg
 ****************************************************************************/
class DiPORouteGuidanceManeuverUpdateMsg: public NavDataMsgBase
{
   public:
    trDiPORouteGuidanceManeuverUpdate *m_porDiPORouteGuidanceManeuverUpdate;

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::DiPORouteGuidanceManeuverUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      DiPORouteGuidanceManeuverUpdateMsg(const trDiPORouteGuidanceManeuverUpdate &corfrDiPORouteGuidanceManeuverUpdate)
    * \brief   Paramaterized constructor
    **************************************************************************/
    DiPORouteGuidanceManeuverUpdateMsg(const trDiPORouteGuidanceManeuverUpdate &corfrDiPORouteGuidanceManeuverUpdate);

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::~DiPORouteGuidanceManeuverUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ~DiPORouteGuidanceManeuverUpdateMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~DiPORouteGuidanceManeuverUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poNavDataDispatcher : pointer to Message dispatcher for NavData
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtNavDataDispatcher* poNavDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclExtNavDataDispatcher
 * \brief Message Dispatcher for NavData Messages
 ****************************************************************************/
class spi_tclExtNavDataDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtNavDataDispatcher::spi_tclExtNavDataDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtNavDataDispatcher()
    * \brief   Default constructor
    **************************************************************************/
      spi_tclExtNavDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNavDataDispatcher::~spi_tclExtNavDataDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtNavDataDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtNavDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DipoLocationInfoMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleNavDataMsg(DipoLocationInfoMsg* poDipoLocationInfoMsg)
    * \brief   Handles Messages of DipoLocationInfoMsg type
    * \param   poDipoLocationInfoMsg : pointer to DipoLocationInfoMsg.
    **************************************************************************/
   t_Void vHandleNavDataMsg(DipoLocationInfoMsg* poDipoLocationInfoMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DipoGPRMCDataStatusValuesInfoMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleNavDataMsg(DipoGPRMCDataStatusValuesInfoMsg* poDipoGPRMCDataStatusValuesInfoMsg)
    * \brief   Handles Messages of DipoGPRMCDataStatusValuesInfoMsg type
    * \param   poDipoGPRMCDataStatusValuesInfoMsg : pointer to DipoGPRMCDataStatusValuesInfoMsg.
    **************************************************************************/
   t_Void vHandleNavDataMsg(DipoGPRMCDataStatusValuesInfoMsg* poDipoGPRMCDataStatusValuesInfoMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DiPORouteGuidanceUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleNavDataMsg(DiPORouteGuidanceUpdateMsg* poDiPORouteGuidanceUpdateMsg)
    * \brief   Handles Messages of DiPORouteGuidanceUpdateMsg type
    * \param   poDiPORouteGuidanceUpdateMsg : pointer to DiPORouteGuidanceUpdateMsg.
    **************************************************************************/
   t_Void vHandleNavDataMsg(DiPORouteGuidanceUpdateMsg* poDiPORouteGuidanceUpdateMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DiPORouteGuidanceManeuverUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleNavDataMsg(DiPORouteGuidanceManeuverUpdateMsg* poDiPORouteGuidanceManeuverUpdateMsg)
    * \brief   Handles Messages of DiPORouteGuidanceManeuverUpdateMsg type
    * \param   poDiPORouteGuidanceManeuverUpdateMsg : pointer to DiPORouteGuidanceManeuverUpdateMsg.
    **************************************************************************/
   t_Void vHandleNavDataMsg(DiPORouteGuidanceManeuverUpdateMsg* poDiPORouteGuidanceManeuverUpdateMsg) const;

};
#endif /* _SPI_TCLEXTNAVDATADISPATCHER_H_ */

