/*
 * spi_tclExtNativeTransportDispatcher.cpp
 *
 *  Created on: Jan 27, 2017
 *      Author: dao8kor
 */


/***********************************************************************/
/*!
 * \file  spi_tclExtNativeTransportDispatcher.cpp
 * \brief Message Dispatcher for Sensor Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Native Transport Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  | Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtNativeTransportDispatcher.h"
#include "spi_tclExtRespNativeTransport.h"
//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtNativeTransportDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleNativeTransportMsg(this);        \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  NativeTransportMsgBase::NativeTransportMsgBase
 ***************************************************************************/
   NativeTransportMsgBase::NativeTransportMsgBase()
{
   ETG_TRACE_USR1(("[FUNC]NativeTransportMsgBase::NativeTransportMsgBase constructor entered\n"));
   vSetServiceID(e32MODULEID_NATIVETRANSPORT);
}

//!class NativeTransportStartMsg
/***************************************************************************
 ** FUNCTION:  NativeTransportStartMsg::NativeTransportStartMsg
 ***************************************************************************/
NativeTransportStartMsg::NativeTransportStartMsg(t_U32 u32DeviceId):
		m_u32DeviceId(u32DeviceId)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  NativeTransportStartMsg::vDispatchMsg
 ***************************************************************************/
 DEFINE_DISPATCH_MESSAGE_FUNCTION(NativeTransportStartMsg, spi_tclExtNativeTransportDispatcher);

/***************************************************************************
 ** FUNCTION:  NativeTransportStartMsg::vAllocateMsg
 ***************************************************************************/
t_Void NativeTransportStartMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]NativeTransportStartMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  NativeTransportStartMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void NativeTransportStartMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]NativeTransportStartMsg::vDeAllocateMsg entered\n"));
}

//!class NativeTransportStopMsg
/***************************************************************************
 ** FUNCTION:  NativeTransportStopMsg::NativeTransportStopMsg
 ***************************************************************************/
  NativeTransportStopMsg::NativeTransportStopMsg(t_U32 u32DeviceId):
		m_u32DeviceId(u32DeviceId)
{
   vAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  NativeTransportStopMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(NativeTransportStopMsg, spi_tclExtNativeTransportDispatcher);

/***************************************************************************
 ** FUNCTION:  NativeTransportStopMsg::vAllocateMsg
 ***************************************************************************/
t_Void NativeTransportStopMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]NativeTransportStopMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  NativeTransportStopMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void NativeTransportStopMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]NativeTransportStopMsg::vDeAllocateMsg entered\n"));
}

//!class BTProfileInfoMsg
/***************************************************************************
 ** FUNCTION:  BTProfileInfoMsg::BTProfileInfoMsg
 ***************************************************************************/
BTProfileInfoMsg::BTProfileInfoMsg(const t_U32 cou32DeviceHandle, t_Bool bIsHFP, t_Bool bIsA2DP, t_String szFriendlyName)
    : m_u32DeviceHandle(cou32DeviceHandle),
      m_bIsHFP(bIsHFP),
      m_bIsA2DP(bIsA2DP),
      m_poszFriendlyName(NULL)
{
   vAllocateMsg();
   if(NULL != m_poszFriendlyName)
   {
	   *m_poszFriendlyName = szFriendlyName;
   }
}
/***************************************************************************
 ** FUNCTION:  BTProfileInfoMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTProfileInfoMsg, spi_tclExtNativeTransportDispatcher);

/***************************************************************************
 ** FUNCTION:  BTProfileInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTProfileInfoMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]BTProfileInfoMsg::vAllocateMsg entered\n"));
   m_poszFriendlyName = new t_String;
}

/***************************************************************************
 ** FUNCTION:  BTProfileInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTProfileInfoMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]BTProfileInfoMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_poszFriendlyName);
}

//!class spi_tclExtNativeTransportDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtNativeTransportDispatcher::spi_tclExtNativeTransportDispatcher
 ***************************************************************************/
spi_tclExtNativeTransportDispatcher::spi_tclExtNativeTransportDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNativeTransportDispatcher constructor entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtNativeTransportDispatcher::~spi_tclExtNativeTransportDispatcher
 ***************************************************************************/
spi_tclExtNativeTransportDispatcher::~spi_tclExtNativeTransportDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNativeTransportDispatcher::~spi_tclExtNativeTransportDispatcher destructor entered "));
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg()
 ***************************************************************************/
t_Void spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg(NativeTransportStartMsg *poNativeTransportStartMsg) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg entered "));
   if (NULL != poNativeTransportStartMsg)
     {
        CALL_REG_OBJECTS(spi_tclExtRespNativeTransport,
        		e16EXT_NATIVETRANSPORT_REGID,
                 vPostNativeTransportStartResult(poNativeTransportStartMsg->m_u32DeviceId));
     }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg()
 ***************************************************************************/
t_Void spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg(NativeTransportStopMsg *poNativeTransportStopMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg entered "));
   if (NULL != poNativeTransportStopMsg)
   {
           CALL_REG_OBJECTS(spi_tclExtRespNativeTransport,
        		    e16EXT_NATIVETRANSPORT_REGID,
                    vPostNativeTransportStopResult(poNativeTransportStopMsg->m_u32DeviceId));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg()
 ***************************************************************************/
t_Void spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg(BTProfileInfoMsg *poBTProfileInfoMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNativeTransportDispatcher::vHandleNativeTransportMsg entered "));
   if (NULL != poBTProfileInfoMsg && NULL != poBTProfileInfoMsg->m_poszFriendlyName)
     {
        CALL_REG_OBJECTS(spi_tclExtRespNativeTransport,
        		 e16EXT_NATIVETRANSPORT_REGID,
        		 vPostBTProfileInfo(poBTProfileInfoMsg->m_u32DeviceHandle, poBTProfileInfoMsg->m_bIsHFP,
        				            poBTProfileInfoMsg->m_bIsA2DP, *(poBTProfileInfoMsg->m_poszFriendlyName)));
     }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
