/*
 * spi_tclExtCmdNativeTransport.cpp
 *
 *  Created on: Jan 27, 2017
 *      Author: dao8kor
 */

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdNativeTransport.h"
#include "Trace.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtCompMsgQInterface.h"
#include "spi_tclExtNativeTransportDispatcher.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdNativeTransport.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport:: spi_tclExtCmdNativeTransport(t_Void)
*******************************************************************************/

spi_tclExtCmdNativeTransport::spi_tclExtCmdNativeTransport() : m_poMPlayClientHandler(NULL)
{
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::~spi_tclExtCmdNativeTransport(t_Void)
*******************************************************************************/
spi_tclExtCmdNativeTransport::~spi_tclExtCmdNativeTransport()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::~spi_tclExtCmdNativeTransport destructor entered "));
   m_poMPlayClientHandler  = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdNativeTransport::bInitialize()
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::bInitialize entered "));
	t_Bool bInit = false;
	spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
	if(NULL != poExtClientFactory)
	{
		m_poMPlayClientHandler = poExtClientFactory->poGetMPlayClientHandlerInstance();
		SPI_NORMAL_ASSERT(NULL == m_poMPlayClientHandler);
	}

	bInit = (NULL != m_poMPlayClientHandler);

	vRegisterIAPCallbacks();

    if(NULL != m_poMPlayClientHandler)
    {
        m_poMPlayClientHandler->vRegisterForNativeTransportProperties();
    }

	ETG_TRACE_USR1(("[DESC]spi_tclExtCmdNativeTransport::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
	return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdNativeTransport::bUnInitialize()
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::bUnInitialize entered "));
	t_Bool bUninitSuccess = true;

	m_poMPlayClientHandler = NULL;

	ETG_TRACE_USR2(("[DESC]spi_tclExtCmdNativeTransport::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
	return bUninitSuccess;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::bLaunchApp()
*******************************************************************************/
t_Bool spi_tclExtCmdNativeTransport::bLaunchApp(const t_U32 cou32DevId, const tenDeviceCategory enDevcat,trEAPAppInfo rEAPAppInfo)
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::bLaunchApp entered "));
	t_Bool bResult = false;

	if(NULL != m_poMPlayClientHandler)
	{
		bResult = m_poMPlayClientHandler->bLaunchApp(cou32DevId, enDevcat,rEAPAppInfo);
	}

	return bResult;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::bSendPlayBackCtrlEvent()
*******************************************************************************/
t_Bool spi_tclExtCmdNativeTransport::bSendPlayBackCtrlEvent(const t_U32 cou32DevId, tenKeyCode enKeyCode, tenKeyMode enKeyMode)
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::bSendPlayBackCtrlEvent entered "));
	t_Bool bResult = false;

	if(NULL != m_poMPlayClientHandler)
	{
		bResult = m_poMPlayClientHandler->bSendPlayBackCtrlEvent(cou32DevId,enKeyCode,enKeyMode);
	}

	return bResult;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::vRegisterIAPCallbacks()
*******************************************************************************/
t_Void  spi_tclExtCmdNativeTransport::vRegisterIAPCallbacks()
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::vRegisterIAPCallbacks entered "));
	trIAPDevInfoCallbacks rAPDevInfoCbs;
	rAPDevInfoCbs.fvOnNativeTransportStart = std::bind(&spi_tclExtCmdNativeTransport::vOnNativeTransportStart,this,
			                                            SPI_FUNC_PLACEHOLDERS_1);
	rAPDevInfoCbs.fvOnNativeTransportStop = std::bind(&spi_tclExtCmdNativeTransport::vOnNativeTransportStop,this,
				                                            SPI_FUNC_PLACEHOLDERS_1);
	tfvBTProfileCallback fvBTProfileCallback = NULL;
	fvBTProfileCallback = std::bind(&spi_tclExtCmdNativeTransport::vBTProfileInfoCb,
	                                this,
	                                SPI_FUNC_PLACEHOLDERS_4);

	if(NULL != m_poMPlayClientHandler)
	{
		m_poMPlayClientHandler->vRegisterIAPCallbacks(rAPDevInfoCbs,fvBTProfileCallback);
	}
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::vOnNativeTransportStartCb()
*******************************************************************************/
t_Void spi_tclExtCmdNativeTransport::vOnNativeTransportStart(t_U32 u32DeviceId)
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::vOnNativeTransportStartCb entered "));
	NativeTransportStartMsg oNativeTransportStartMsg(u32DeviceId);
	spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
	 if (NULL != poExtMsgQinterface)
	 {
		   poExtMsgQinterface->bWriteMsgToQ(&oNativeTransportStartMsg,sizeof(oNativeTransportStartMsg));
	 }
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::vOnNativeTransportStopCb()
*******************************************************************************/
t_Void spi_tclExtCmdNativeTransport::vOnNativeTransportStop(t_U32 u32DeviceId)
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::vOnNativeTransportStopCb entered "));
	NativeTransportStopMsg oNativeTransportStopMsg(u32DeviceId);
	spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
	 if (NULL != poExtMsgQinterface)
	 {
		   poExtMsgQinterface->bWriteMsgToQ(&oNativeTransportStopMsg,sizeof(oNativeTransportStopMsg));
	 }
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdNativeTransport::vGetSelectedDevSerialCb()
*******************************************************************************/
t_Void spi_tclExtCmdNativeTransport::vBTProfileInfoCb(const t_U32 cou32DeviceHandle, t_Bool bIsHFP, t_Bool bIsA2DP, t_String szFriendlyName)
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::vBTProfileInfoCb entered "));
	BTProfileInfoMsg oBTProfileInfoMsg(cou32DeviceHandle,bIsHFP,bIsA2DP,szFriendlyName);
	spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
	if (NULL != poExtMsgQinterface)
	{
		poExtMsgQinterface->bWriteMsgToQ(&oBTProfileInfoMsg,sizeof(oBTProfileInfoMsg));
	}
}

t_Void spi_tclExtCmdNativeTransport::vRegisterGetSelectedDevSerialCb(
                       const tfvGetSelectedDevSerialCallback cofvGetSelectedDevSerialCallback)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdNativeTransport::vRegisterGetSelectedDevSerialCb entered "));
    if(NULL != m_poMPlayClientHandler)
    {
        m_poMPlayClientHandler->vRegisterGetSelectedDevSerialCb(cofvGetSelectedDevSerialCallback);
    }
}
//lint restore
