/*!
 *******************************************************************************
 * \file              spi_tclExtRespNativeTransport.h
 * \brief             External Interfaces Wrapper Response class for Native Transport
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for Native Transport
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 30.01.2017 | Unmukt Jain           | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEXTRESPNATIVETRANSPORT_H_
#define _SPI_TCLEXTRESPNATIVETRANSPORT_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespNativeTransport: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespNativeTransport::spi_tclExtRespNativeTransport()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespNativeTransport()
    * \brief   Constructor
    * \sa      spi_tclExtRespNativeTransport()
    **************************************************************************/
	spi_tclExtRespNativeTransport(): RespBase(e16EXT_NATIVETRANSPORT_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespNativeTransport::~spi_tclExtRespNativeTransport()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespNativeTransport()
    * \brief   Destructor
    * \sa      spi_tclExtRespNativeTransport()
    **************************************************************************/
   virtual ~spi_tclExtRespNativeTransport() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespNativeTransport::vPostNativeTransportStartResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostNativeTransportStartResult()
    * \brief   Called by MPlay client handler to inform native transport has started
    * \param   [IN] u32DeviceId: Device ID
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostNativeTransportStartResult(t_U32 /*u32DeviceId*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespNativeTransport::vPostNativeTransportStopResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostNativeTransportStopResult()
    * \brief   Called by MPlay client handler to inform native transport has stoppped
    * \param   [IN] u32DeviceId: Device ID
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostNativeTransportStopResult(t_U32 /*u32DeviceId*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespNativeTransport::vPostBTProfileInfo()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTProfileInfo()
    * \brief   Informs the current state of App Transition
    * \param   bIsHFP :
    * \param   bIsA2DP :
    * \param   szFriendlyName:
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTProfileInfo(const t_U32 /*cou32DeviceHandle*/, t_Bool /*bIsHFP*/, t_Bool /*bIsA2DP*/, t_String /*szFriendlyName*/){}

};

#endif /* _SPI_TCLEXTRESPNATIVETRANSPORT_H_ */
