/*
 * spi_tclExtNativeTransportDispatcher.h
 *
 *  Created on: Jan 27, 2017
 *      Author: dao8kor
 */

/*!
 * \file  spi_tclExtNativeTransportDispatcher.h
 * \brief Message Dispatcher for Native Transport Messages.Implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Native Transport Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  |Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLEXTCMDNATIVETRANSPORTDISPATCHER_H_
#define _SPI_TCLEXTCMDNATIVETRANSPORTDISPATCHER_H_

/*************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclExtNativeTransportDispatcher;

/****************************************************************************/
/*!
 * \class NativeTransportMsgBase
 * \brief Base Message type for all Native Transport messages
 ****************************************************************************/
class NativeTransportMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  NativeTransportMsgBase::NativeTransportMsgBase
    ***************************************************************************/
   /*!
    * \fn      NativeTransportMsgBase()
    * \brief   Default constructor
    **************************************************************************/
	NativeTransportMsgBase();

   /***************************************************************************
    ** FUNCTION:  NativeTransportMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poNativeTransportDispatcher : pointer to Message dispatcher for Native Trnsport
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  NativeTransportMsgBase::~NativeTransportMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~NativeTransportMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~NativeTransportMsgBase()
   {

   }
};


/****************************************************************************/
/*!
 * \class NativeTransportStartMsg
 * \brief Configure Native Transport Result msg
 ****************************************************************************/
class NativeTransportStartMsg: public NativeTransportMsgBase
{
   public:

    t_U32 m_u32DeviceId;

   /***************************************************************************
    ** FUNCTION:  NativeTransportStartMsg::NativeTransportStartMsg
    ***************************************************************************/
   /*!
    * \fn      NativeTransportStartMsg(trSensorData rSensorData)
    * \brief   Paramaterized constructor
    **************************************************************************/
      NativeTransportStartMsg(t_U32 u32DeviceId);

   /***************************************************************************
    ** FUNCTION:  NativeTransportStartMsg::~NativeTransportStartMsg
    ***************************************************************************/
   /*!
    * \fn      ~NativeTransportStartMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~NativeTransportStartMsg(){}

   /***************************************************************************
    ** FUNCTION:  NativeTransportStartMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poNativeTransportDispatcher : pointer to Message dispatcher for Native Transport
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher);

   /***************************************************************************
    ** FUNCTION:  NativeTransportStartMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  NativeTransportStartMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class NativeTransportStopMsg
 * \brief Configure Native Transport Result msg
 ****************************************************************************/
class NativeTransportStopMsg: public NativeTransportMsgBase
{
   public:

	t_U32 m_u32DeviceId;

   /***************************************************************************
    ** FUNCTION:  NativeTransportStopMsg::NativeTransportStopMsg
    ***************************************************************************/
   /*!
    * \fn      AccSensorDataMsg(t_U32 cou32DevId)
    * \brief   Paramaterized constructor
    **************************************************************************/
	NativeTransportStopMsg(t_U32 u32DeviceId);

   /***************************************************************************
    ** FUNCTION:  NativeTransportStopMsg::~NativeTransportStopMsg
    ***************************************************************************/
   /*!
    * \fn      ~NativeTransportStopMsg()
    * \brief   Destructor
    **************************************************************************/
    virtual ~NativeTransportStopMsg(){}

   /***************************************************************************
    ** FUNCTION:  NativeTransportStopMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poNativeTransportDispatcher : pointer to Message dispatcher for Native Transport
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher);

   /***************************************************************************
    ** FUNCTION:  NativeTransportStopMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  NativeTransportStopMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BTProfileInfoMsg
 * \brief BT Profile info msg
 ****************************************************************************/
class BTProfileInfoMsg: public NativeTransportMsgBase
{
   public:

	t_U32 m_u32DeviceHandle;
	t_Bool m_bIsHFP;
	t_Bool m_bIsA2DP;
	t_String *m_poszFriendlyName;

   /***************************************************************************
    ** FUNCTION:  BTProfileInfoMsg::BTProfileInfoMsg
    ***************************************************************************/
   /*!
    * \fn      GyroSensorDataMsg(t_U32 cou32DevId, t_String szDeviceId)
    * \brief   Paramaterized constructor
    **************************************************************************/
	BTProfileInfoMsg(const t_U32 cou32DeviceHandle, t_Bool bIsHFP, t_Bool bIsA2DP, t_String szFriendlyName);

   /***************************************************************************
    ** FUNCTION:  BTProfileInfoMsg::~BTProfileInfoMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTProfileInfoMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTProfileInfoMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTProfileInfoMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poNativeTransportDispatcher : pointer to Message dispatcher for Native Transport
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtNativeTransportDispatcher* poNativeTransportDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTProfileInfoMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTProfileInfoMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclExtNativeTransportDispatcher
 * \brief Message Dispatcher for Sensor Messages
 ****************************************************************************/
class spi_tclExtNativeTransportDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtNativeTransportDispatcher::spi_tclExtNativeTransportDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtNativeTransportDispatcher()
    * \brief   Default constructor
    **************************************************************************/
	spi_tclExtNativeTransportDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNativeTransportDispatcher::~spi_tclExtNativeTransportDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtNativeTransportDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtNativeTransportDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNativeTransportDispatcher::vHandleSensorMsg(NativeTransportStartMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleSensorMsg(NativeTransportStartMsg* poNativeTransportStartMsg)
    * \brief   Handles Messages of NativeTransportStartMsg type
    * \param   poNativeTransportStartMsg : pointer to NativeTransportStartMsg.
    **************************************************************************/
   t_Void vHandleNativeTransportMsg(NativeTransportStartMsg *poNativeTransportStartMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNativeTransportDispatcher::vHandleSensorMsg(NativeTransportStopMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleSensorMsg(NativeTransportStopMsg *poNativeTransportStopMsg)
    * \brief   Handles Messages of NativeTransportStopMsg type
    * \param   poNativeTransportStopMsg : pointer to NativeTransportStopMsg.
    **************************************************************************/
   t_Void vHandleNativeTransportMsg(NativeTransportStopMsg *poNativeTransportStopMsg)const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtNativeTransportDispatcher::vHandleSensorMsg(BTProfileInfoMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleSensorMsg(BTProfileInfoMsg *poBTProfileInfoMsg)
    * \brief   Handles Messages of BTProfileInfoMsg type
    * \param   poBTProfileInfoMsg : pointer to BTProfileInfoMsg.
    **************************************************************************/
   t_Void vHandleNativeTransportMsg(BTProfileInfoMsg *poBTProfileInfoMsg)const;

};
#endif /* _SPI_TCLEXTCMDNATIVETRANSPORTDISPATCHER_H_ */

