/*
 * spi_tclExtCmdNativeTransportIntf.h
 *
 *  Created on: Jan 27, 2017
 *      Author: dao8kor
 */


#ifndef _SPI_TCLEXTCMDNATIVETRANSPORTINTF_H_
#define _SPI_TCLEXTCMDNATIVETRANSPORTINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
/**
* \brief   Native Transport Intf class
*/
class spi_tclExtCmdNativeTransportIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdNativeTransportIntf::~spi_tclExtCmdNativeTransportIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdNativeTransportIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdNativeTransportIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdNativeTransportIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdNativeTransportIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdNativeTransportIntf::bLaunchApp(const t_U32 cou32DevId,const tenDeviceCategory enDevcat,trEAPAppInfo rEAPAppInfo)
   ***************************************************************************/
   /*!
   * \fn     bLaunchApp(const t_U32 cou32DevId, const tenDeviceCategory enDevcat)
   * \brief  Function to connect and launch a particular app
   * \retval bool : true if succees, false otherwise
   **************************************************************************/
   virtual t_Bool bLaunchApp(const t_U32 cou32DevId, const tenDeviceCategory enDevcat,trEAPAppInfo rEAPAppInfo) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNativeTransportIntf::bSendPlayBackCtrlEvent()
   ***************************************************************************/
   /*!
   * \fn      bSendPlayBackCtrlEvent()
   * \brief   This method is used to send media playback control events
   * \retval  bool : true if succees, false otherwise
   **************************************************************************/
   virtual t_Bool bSendPlayBackCtrlEvent(const t_U32 cou32DevId, tenKeyCode enKeyCode, tenKeyMode enKeyMode) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNativeTransportIntf::vRegisterGetSelectedDevSerialCb()
   **************************************************************************/
   /*!
   * \fn      vRegisterGetSelectedDevSerialCb()
   * \brief   Registers for all callbacks properties to respective service
   * \sa      vUnregisterForProperties()
   **************************************************************************/
   virtual t_Void vRegisterGetSelectedDevSerialCb(
                     const tfvGetSelectedDevSerialCallback cofvGetSelectedDevSerialCallback) = 0;


   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDNATIVETRANSPORTINTF_H_

