/***********************************************************************/
/*!
 * \file  spi_tclExtMetaDataDispatcher.cpp
 * \brief Message Dispatcher for Meta Data Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Meta Data Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 25.01.2017  | Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtMetaDataDispatcher.h"
#include "spi_tclExtRespMetaData.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtMetaDataDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleMetaDataMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  MetaDataMsgBase::MetaDataMsgBase
 ***************************************************************************/
MetaDataMsgBase::MetaDataMsgBase()
{
   ETG_TRACE_USR1(("MetaDataMsgBase::MetaDataMsgBase entered\n"));
   vSetServiceID(e32MODULEID_METADATA);
}

//!class AppMediaMetaDataMsg
/***************************************************************************
 ** FUNCTION:  AppMediaMetaDataMsg::AppMediaMetaDataMsg
 ***************************************************************************/
AppMediaMetaDataMsg::AppMediaMetaDataMsg(const trAppMediaMetaData &rfcoAppMediaMetaData, const trUserContext &rfcoUserContext):
         m_prAppMediaMetaData(NULL),m_prUserContext(NULL)
{
   vAllocateMsg();
   if(NULL != m_prAppMediaMetaData)
   {
    (*m_prAppMediaMetaData) = rfcoAppMediaMetaData;
   }
   if(NULL != m_prUserContext)
   {
    (*m_prUserContext) = rfcoUserContext;
   }
}

/***************************************************************************
 ** FUNCTION:  AppMediaMetaDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AppMediaMetaDataMsg, spi_tclExtMetaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  AppMediaMetaDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void AppMediaMetaDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppMediaMetaDataMsg::vAllocateMsg entered\n"));
   m_prAppMediaMetaData = new trAppMediaMetaData();
   m_prUserContext      = new trUserContext();
}

/***************************************************************************
 ** FUNCTION:  AppMediaMetaDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AppMediaMetaDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppMediaMetaDataMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prAppMediaMetaData);
   RELEASE_MEM(m_prUserContext);
}

//!class AppMediaAlbumArtMsg
/***************************************************************************
 ** FUNCTION:  AppMediaAlbumArtMsg::AppMediaAlbumArtMsg
 ***************************************************************************/
AppMediaAlbumArtMsg::AppMediaAlbumArtMsg(const trAppMediaAlbumArt &rfcoAppMediaAlbumArt, const trUserContext &rfcoUserContext):
         m_prAppMediaAlbumArt(NULL),m_prUserContext(NULL)
{
   vAllocateMsg();
   if(NULL != m_prAppMediaAlbumArt)
   {
    (*m_prAppMediaAlbumArt) = rfcoAppMediaAlbumArt;
   }
   if(NULL != m_prUserContext)
   {
    (*m_prUserContext) = rfcoUserContext;
   }
}

/***************************************************************************
 ** FUNCTION:  AppMediaAlbumArtMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AppMediaAlbumArtMsg, spi_tclExtMetaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  AppMediaAlbumArtMsg::vAllocateMsg
 ***************************************************************************/
t_Void AppMediaAlbumArtMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppMediaAlbumArtMsg::vAllocateMsg entered\n"));
   m_prAppMediaAlbumArt = new trAppMediaAlbumArt();
   m_prUserContext      = new trUserContext();
}

/***************************************************************************
 ** FUNCTION:  AppMediaAlbumArtMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AppMediaAlbumArtMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppMediaAlbumArtMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prAppMediaAlbumArt);
   RELEASE_MEM(m_prUserContext);
}

//!class AppMediaPlaytimeMsg
/***************************************************************************
 ** FUNCTION:  AppMediaPlaytimeMsg::AppMediaPlaytimeMsg
 ***************************************************************************/
AppMediaPlaytimeMsg::AppMediaPlaytimeMsg(const trAppMediaPlaytime &rfcoAppMediaPlaytime, const trUserContext &rfcoUserContext):
         m_prAppMediaPlaytime(NULL),m_prUserContext(NULL)
{
   vAllocateMsg();
   if(NULL != m_prAppMediaPlaytime)
   {
    (*m_prAppMediaPlaytime) = rfcoAppMediaPlaytime;
   }
   if(NULL != m_prUserContext)
   {
    (*m_prUserContext) = rfcoUserContext;
   }
}

/***************************************************************************
 ** FUNCTION:  AppMediaPlaytimeMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AppMediaPlaytimeMsg, spi_tclExtMetaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  AppMediaPlaytimeMsg::vAllocateMsg
 ***************************************************************************/
t_Void AppMediaPlaytimeMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppMediaPlaytimeMsg::vAllocateMsg entered\n"));
   m_prAppMediaPlaytime = new trAppMediaPlaytime();
   m_prUserContext      = new trUserContext();
}

/***************************************************************************
 ** FUNCTION:  AppMediaPlaytimeMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AppMediaPlaytimeMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppMediaPlaytimeMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prAppMediaPlaytime);
   RELEASE_MEM(m_prUserContext);
}

//!class AppPhoneDataMsg
/***************************************************************************
 ** FUNCTION:  AppPhoneDataMsg::AppPhoneDataMsg
 ***************************************************************************/
AppPhoneDataMsg::AppPhoneDataMsg(const trAppPhoneData& rfcorAppPhoneData, const trUserContext &rfcoUserContext):
         m_prAppPhoneData(NULL),m_prUserContext(NULL)
{
   vAllocateMsg();
   if(NULL != m_prAppPhoneData)
   {
    (*m_prAppPhoneData) = rfcorAppPhoneData;
   }
   if(NULL != m_prUserContext)
   {
    (*m_prUserContext) = rfcoUserContext;
   }
}

/***************************************************************************
 ** FUNCTION:  AppPhoneDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AppPhoneDataMsg, spi_tclExtMetaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  AppPhoneDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void AppPhoneDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppPhoneDataMsg::vAllocateMsg entered\n"));
   m_prAppPhoneData = new trAppPhoneData();
   m_prUserContext  = new trUserContext();
}

/***************************************************************************
 ** FUNCTION:  AppPhoneDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AppPhoneDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppPhoneDataMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prAppPhoneData);
   RELEASE_MEM(m_prUserContext);
}

//!class AppPhoneCallDataMsg
/***************************************************************************
 ** FUNCTION:  AppPhoneCallDataMsg::AppPhoneCallDataMsg
 ***************************************************************************/
AppPhoneCallDataMsg::AppPhoneCallDataMsg(const trAppPhoneCallData& rfcorAppPhoneCallData, const trUserContext &rfcoUserContext):
         m_prAppPhoneCallData(NULL),m_prUserContext(NULL)
{
   vAllocateMsg();
   if(NULL != m_prAppPhoneCallData)
   {
    (*m_prAppPhoneCallData) = rfcorAppPhoneCallData;
   }
   if(NULL != m_prUserContext)
   {
    (*m_prUserContext) = rfcoUserContext;
   }
}

/***************************************************************************
 ** FUNCTION:  AppPhoneCallDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AppPhoneCallDataMsg, spi_tclExtMetaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  AppPhoneCallDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void AppPhoneCallDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppPhoneCallDataMsg::vAllocateMsg entered\n"));
   m_prAppPhoneCallData = new trAppPhoneCallData();
   m_prUserContext  = new trUserContext();
}

/***************************************************************************
 ** FUNCTION:  AppPhoneCallDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AppPhoneCallDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppPhoneCallDataMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prAppPhoneCallData);
   RELEASE_MEM(m_prUserContext);
}


//!class AppDeviceTimeUpdateMsg
/***************************************************************************
 ** FUNCTION:  AppDeviceTimeUpdateMsg::AppDeviceTimeUpdateMsg
 ***************************************************************************/
AppDeviceTimeUpdateMsg::AppDeviceTimeUpdateMsg(const trDeviceTime& corDeviceTime):
         m_prDeviceTime(NULL)
{
   vAllocateMsg();
   if(NULL != m_prDeviceTime)
   {
    (*m_prDeviceTime) = corDeviceTime;
   }
}

/***************************************************************************
 ** FUNCTION:  AppDeviceTimeUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AppDeviceTimeUpdateMsg, spi_tclExtMetaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  AppDeviceTimeUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void AppDeviceTimeUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppDeviceTimeUpdateMsg::vAllocateMsg entered\n"));
   m_prDeviceTime = new trDeviceTime();
}

/***************************************************************************
 ** FUNCTION:  AppDeviceTimeUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AppDeviceTimeUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AppDeviceTimeUpdateMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prDeviceTime);
}

//!class spi_tclExtMetaDataDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::spi_tclExtMetaDataDispatcher
 ***************************************************************************/
spi_tclExtMetaDataDispatcher::spi_tclExtMetaDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::spi_tclExtMetaDataDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::~spi_tclExtMetaDataDispatcher
 ***************************************************************************/
spi_tclExtMetaDataDispatcher::~spi_tclExtMetaDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::~spi_tclExtMetaDataDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg(AppMediaMetaDataMsg...)
 ***************************************************************************/
t_Void spi_tclExtMetaDataDispatcher::
       vHandleMetaDataMsg(AppMediaMetaDataMsg *poAppMediaMetaDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg entered "));
   if (NULL != poAppMediaMetaDataMsg && NULL != poAppMediaMetaDataMsg->m_prAppMediaMetaData && NULL != poAppMediaMetaDataMsg->m_prUserContext)
   {
      CALL_REG_OBJECTS(spi_tclExtRespMetaData,
           e16EXT_METADATA_REGID,vPostAppMediaMetaDataMsg(*(poAppMediaMetaDataMsg->m_prAppMediaMetaData),*(poAppMediaMetaDataMsg->m_prUserContext)));
   }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg(AppMediaAlbumArtMsg...)
 ***************************************************************************/
t_Void spi_tclExtMetaDataDispatcher::
       vHandleMetaDataMsg(AppMediaAlbumArtMsg *poAppMediaAlbumArtMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg entered "));
      if (NULL != poAppMediaAlbumArtMsg && NULL != poAppMediaAlbumArtMsg->m_prAppMediaAlbumArt && NULL != poAppMediaAlbumArtMsg->m_prUserContext)
      {
         CALL_REG_OBJECTS(spi_tclExtRespMetaData,
                  e16EXT_METADATA_REGID,vPostAppMediaAlbumArtMsg(*(poAppMediaAlbumArtMsg->m_prAppMediaAlbumArt),*(poAppMediaAlbumArtMsg->m_prUserContext)));
      }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg(AppMediaPlaytimeMsg...)
 ***************************************************************************/
t_Void spi_tclExtMetaDataDispatcher::
       vHandleMetaDataMsg(AppMediaPlaytimeMsg *poAppMediaPlaytimeMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg entered "));
      if (NULL != poAppMediaPlaytimeMsg && NULL != poAppMediaPlaytimeMsg->m_prAppMediaPlaytime && NULL != poAppMediaPlaytimeMsg->m_prUserContext)
      {
         CALL_REG_OBJECTS(spi_tclExtRespMetaData,
                  e16EXT_METADATA_REGID,vPostAppMediaPlaytimeMsg(*(poAppMediaPlaytimeMsg->m_prAppMediaPlaytime),*(poAppMediaPlaytimeMsg->m_prUserContext)));
      }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg(AppPhoneDataMsg...)
 ***************************************************************************/
t_Void spi_tclExtMetaDataDispatcher::
       vHandleMetaDataMsg(AppPhoneDataMsg *poAppPhoneDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg entered "));
      if (NULL != poAppPhoneDataMsg && NULL != poAppPhoneDataMsg->m_prAppPhoneData && NULL != poAppPhoneDataMsg->m_prUserContext)
      {
         CALL_REG_OBJECTS(spi_tclExtRespMetaData,
                  e16EXT_METADATA_REGID,vPostAppPhoneDataMsg(*(poAppPhoneDataMsg->m_prAppPhoneData),*(poAppPhoneDataMsg->m_prUserContext)));
      }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg(AppPhoneCallDataMsg*...)
 ***************************************************************************/
t_Void spi_tclExtMetaDataDispatcher::
      vHandleMetaDataMsg(AppPhoneCallDataMsg *poAppPhoneCallDataMsg) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg entered "));
       if (NULL != poAppPhoneCallDataMsg && NULL != poAppPhoneCallDataMsg->m_prAppPhoneCallData && NULL != poAppPhoneCallDataMsg->m_prUserContext)
       {
          CALL_REG_OBJECTS(spi_tclExtRespMetaData,
                   e16EXT_METADATA_REGID,vPostAppPhoneCallDataMsg(*(poAppPhoneCallDataMsg->m_prAppPhoneCallData),*(poAppPhoneCallDataMsg->m_prUserContext)));
       }

}



/***************************************************************************
 ** FUNCTION:  spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg(AppDeviceTimeUpdateMsg*...)
 ***************************************************************************/
t_Void spi_tclExtMetaDataDispatcher::
      vHandleMetaDataMsg(AppDeviceTimeUpdateMsg *poAppDeviceTimeUpdateMsg) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtMetaDataDispatcher::vHandleMetaDataMsg entered "));
       if (NULL != poAppDeviceTimeUpdateMsg && poAppDeviceTimeUpdateMsg->m_prDeviceTime)
       {
          CALL_REG_OBJECTS(spi_tclExtRespMetaData,
                   e16EXT_METADATA_REGID,vPostAppDeviceTimeUpdateMsg(*(poAppDeviceTimeUpdateMsg->m_prDeviceTime)));
       }
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
