/*!
*******************************************************************************
* \file              spi_tclExtCmdMetaDataIntf.h
* \brief             Meta Data Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to register/un-register
                with Meta Data provider.
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
23.01.2017 |  Unmukt Jain                 | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDMETADATAINTF_H_
#define _SPI_TCLEXTCMDMETADATAINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
/**
* \brief   Meta Data Intf class
*/
class spi_tclExtCmdMetaDataIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdMetaDataIntf::~spi_tclExtCmdMetaDataIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdMetaDataIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdMetaDataIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMetaDataIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMetaDataIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdMetaDataIntf::bDiPOGetAlbumArtInfo(t_String sAlbumArt)
   ***************************************************************************/
   /*!
   * \fn      bDiPOGetAlbumArtInfo(t_String sAlbumArt)
   * \brief   Function to get album art info
   * \param   sAlbumArt : [IN] Album art
   * \retval  bool : true if succees, false otherwise
   **************************************************************************/
   virtual t_Bool bDiPOGetAlbumArtInfo(t_String sAlbumArt) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdMetaDataIntf::bDiPOGetAlbumArt(t_String sUrl)
   ***************************************************************************/
   /*!
   * \fn     bDiPOGetAlbumArt(t_String sUrl)
   * \brief  Function to get album art
   * \param  sAlbumArt : [IN] Album art
   * \retval bool : true if succees, false otherwise
   **************************************************************************/
   virtual t_Bool bGetDiPOAlbumArt(t_String szAlbumArtUrl, const trUserContext& corfrUsrCntxt) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaDataIntf::vRegisterForMetadataProperties()
   **************************************************************************/
   /*!
   * \fn      vRegisterForMetadataProperties()
   * \brief   Registers for all interested properties to Metadata
   **************************************************************************/
   virtual t_Void vRegisterForMetadataProperties() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaDataIntf::vUnregisterForMetadataProperties()
   **************************************************************************/
   /*!
   * \fn      vUnregisterForMetadataProperties()
   * \brief   Un-registers all subscribed properties to Metadata
   **************************************************************************/
   virtual t_Void vUnregisterForMetadataProperties() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaDataIntf::vTriggerNowPlayingStatus()
   **************************************************************************/
   /*!
   * \fn      vTriggerNowPlayingStatus()
   * \brief   Method to trigger Get DiPo Now Playing Status updates
   **************************************************************************/
   virtual t_Void vTriggerNowPlayingStatus() = 0;

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDMETADATAINTF_H_

