/*!
*******************************************************************************
* \file              spi_tclExtCmdMetaData.h
* \brief             Meta Data Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Meta Data Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
24.01.2017 |  Unmukt Jain                 | Initial Version
\endverbatim
******************************************************************************/

#ifndef SPI_TCLEXTCMDMETADATA_H_
#define SPI_TCLEXTCMDMETADATA_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdMetaDataIntf.h"
#include "spi_tclAppMngrDefines.h"

class spi_tclMPlayClientHandler;

class spi_tclExtCmdMetaData: public spi_tclExtCmdMetaDataIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdMetaData::spi_tclExtCmdMetaData()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdMetaData()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
	spi_tclExtCmdMetaData();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdMetaData::~spi_tclExtCmdMetaData()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdMetaData()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdMetaData();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMetaData::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMetaData::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdMetaData::bDiPOGetAlbumArtInfo(t_String sAlbumArt)
   ***************************************************************************/
   /*!
   * \fn      bDiPOGetAlbumArtInfo(t_String sAlbumArt)
   * \brief   Function to get album art info
   * \param   sAlbumArt : [IN] Album art
   * \retval  bool : true if succees, false otherwise
   **************************************************************************/
   t_Bool bDiPOGetAlbumArtInfo(t_String sAlbumArt);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdMetaData::bDiPOGetAlbumArt(t_String sUrl)
   ***************************************************************************/
   /*!
   * \fn     bDiPOGetAlbumArt(t_String sUrl)
   * \brief  Function to get album art
   * \param  sAlbumArt : [IN] Album art
   * \retval bool : true if succees, false otherwise
   **************************************************************************/
   t_Bool bGetDiPOAlbumArt(t_String szAlbumArtUrl, const trUserContext& corfrUsrCntxt);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vRegisterForMetadataProperties()
   **************************************************************************/
   /*!
   * \fn      vRegisterForMetadataProperties()
   * \brief   Registers for all interested properties to Metadata
   **************************************************************************/
   virtual t_Void vRegisterForMetadataProperties();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vUnregisterForMetadataProperties()
   **************************************************************************/
   /*!
   * \fn      vUnregisterForMetadataProperties()
   * \brief   Un-registers all subscribed properties to Metadata
   **************************************************************************/
   virtual t_Void vUnregisterForMetadataProperties();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaDataIntf::vTriggerNowPlayingStatus()
   **************************************************************************/
   /*!
   * \fn      vTriggerNowPlayingStatus()
   * \brief   Method to trigger Get DiPo Now Playing Status updates
   * \retval  None
   **************************************************************************/
   t_Void vTriggerNowPlayingStatus();

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppMediaAlbumArtCb(...)
   ***************************************************************************/
   /*!
   * \fn      vAppMediaAlbumArtCb()
   * \brief   Called by MPlay client handler when Media Album Art data is available
   * \param   rAppMediaAlbumArt: a trAppMediaAlbumArt type structure
   * \param   rUserContext: User context info
   * \retval  None
   **************************************************************************/
   t_Void vAppMediaAlbumArtCb(const trAppMediaAlbumArt& rAppMediaAlbumArt, const trUserContext& rUserContext);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppMediaMetaDataCb(...)
   ***************************************************************************/
   /*!
   * \fn      vAppMediaMetaDataCb()
   * \brief   Called by MPlay client handler when App Media Data is available
   * \param   rAppMediaMetaData: a trAppMediaMetaData type structure
   * \param   rUserContext: User context info
   * \retval  None
   **************************************************************************/
   t_Void vAppMediaMetaDataCb(const trAppMediaMetaData &rAppMediaMetaData, const trUserContext &rUserContext);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppMediaPlaytimeCb(...)
   ***************************************************************************/
   /*!
   * \fn      vAppMediaPlaytimeCb()
   * \brief   Called by MPlay client handler when Media Playtime Data is available
   * \param   rfcorAppMediaPlaytime: a trAppMediaPlaytime type structure
   * \param   rfcorUsrCntxt: User context info
   * \retval  None
   **************************************************************************/
   t_Void vAppMediaPlaytimeCb(const trAppMediaPlaytime& rfcorAppMediaPlaytime, const trUserContext& rfcorUsrCntxt);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppPhoneDataCb(...)
   ***************************************************************************/
   /*!
   * \fn      vAppPhoneDataCb()
   * \brief   Called by MPlay client handler when Phone Data is available
   * \param   rfcorApplicationPhoneData: a trAppPhoneData type structure
   * \param   rfcorUsrCntxt: User context info
   * \retval  None
   **************************************************************************/
   t_Void vAppPhoneDataCb(const trAppPhoneData& rfcorApplicationPhoneData, const trUserContext& rfcorUsrCntxt);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppPhoneCallDataCb(...)
   ***************************************************************************/
   /*!
   * \fn      vAppPhoneCallDataCb()
   * \brief   Called by MPlay client handler when Phone Call Data is available
   * \param   rfcorApplicationPhoneCallData: a trAppPhoneCallData type structure
   * \param   rfcorUsrCntxt: User context info
   * \retval  None
   **************************************************************************/
   t_Void vAppPhoneCallDataCb(const trAppPhoneCallData& rfcorApplicationPhoneCallData, const trUserContext& rfcorUsrCntxt);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vPostAppDeviceTimeUpdateCb(...)
   ***************************************************************************/
   /*!
   * \fn      vPostAppDeviceTimeUpdateCb()
   * \brief   Called by MPlay client handler when DiPO Device Time message arrives
   * \param   rfcoDeviceTime: start time of phone call with reference to device time
   * \retval  None
   **************************************************************************/
   t_Void vPostAppDeviceTimeUpdateCb(const trDeviceTime& rfcoDeviceTime);

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vRegisterMetaDataCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterMetaDataCallbacks()
   * \brief   Registers MetaData callbacks to MediaPlayer client.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterMetaDataCallbacks();

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   //! MediaPlayer client handler pointer
   spi_tclMPlayClientHandler *m_poMPlayClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define SPI_TCLEXTCMDMETADATA_H_


