/*!
*******************************************************************************
* \file              spi_tclExtCmdInput.h
* \brief             Input Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to send input information to media
                player
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
23.08.2019 |  Ram Chaithanya S A          | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDINPUT_H_
#define _SPI_TCLEXTCMDINPUT_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdInputIntf.h"
/**
* \brief
*/
class spi_tclMPlayClientHandler;
class spi_tclExtCmdInput:public spi_tclExtCmdInputIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION: spi_tclExtCmdInput::spi_tclExtCmdInput()
   ***************************************************************************/
   /*!
   * \fn      spi_tclExtCmdInput()
   * \brief   Constructor
   * \sa
   **************************************************************************/

   spi_tclExtCmdInput();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdInput::~spi_tclExtCmdInput()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdInput()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   ~spi_tclExtCmdInput();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdInput::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdInput::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdInput::bSetCallControlConfig()
    ***************************************************************************/
   /*!
    * \fn      bSetCallControlConfig()
    * \brief   Method to set call controlconfiguration
    * \param   rfrsetKeyCodes  : [IN] Supported Key Codes
    * \sa      vSetCallControlConfig()
    **************************************************************************/
   t_Bool bSetCallControlConfig(const std::set<tenKeyCode>& rfrsetKeyCodes);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdInput::bDiPOAcceptCall(...)
   **************************************************************************/
   /*!
   * \fn      bDiPOAcceptCall(const t_U32 cou32DeviceHandle,
   *           const tenPhoneCallAcceptAction coenCallAcceptAction) const
   * \brief   Function to accept phone call on AcceptCall softkey press
   * \param   cou32DevHandle       : [IN] Device handle of the device
   * \param   coenCallAcceptAction : [IN] Accepting phone call action 
   * \retval  t_Bool
   **************************************************************************/
   t_Bool bDiPOAcceptCall(const t_U32 cou32DeviceHandle,
      const tenPhoneCallAcceptAction coenCallAcceptAction) const override ;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdInput::bDiPOEndCall(...)
   **************************************************************************/
   /*!
   * \fn      bDiPOEndCall(const t_U32 cou32DeviceHandle,
   *           const tenPhoneCallEndAction coenCallEndAction) const
   * \brief   Function to end phone call on EndCall softkey press
   * \param   cou32DevHandle    : [IN] Device handle of the device
   * \param   coenCallEndAction : [IN] Ending phone call action 
   * \retval  t_Bool
   **************************************************************************/
   t_Bool bDiPOEndCall(const t_U32 cou32DeviceHandle,
      const tenPhoneCallEndAction coenCallEndAction) const override ;

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

      //! MediaPlayer client handler pointer
   spi_tclMPlayClientHandler *m_poMPlayClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDINPUT_H

