/***********************************************************************/
/*!
 * \file  spi_tclExtCompMsgQThreadable.cpp
 * \brief implements threading based on MsgQthreader for External Interface
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    implements threading based on MsgQthreader for External Interface
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                	| Modification
 06.01.2017  |  Unmukt Jain (RBEI/ECP2)  | Initial Version

 \endverbatim
 *************************************************************************/

#include "spi_tclExtCompMsgQThreadable.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCompMsgQThreadable.cpp.trc.h"
#endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompMsgQThreadable::spi_tclExtCompMsgQThreadable()
 ***************************************************************************/

spi_tclExtCompMsgQThreadable::spi_tclExtCompMsgQThreadable():
    m_poExtPositionDispatcher(NULL),
    m_poExtSensorDispatcher(NULL),
    m_poExtWiFiDispatcher(NULL),
    m_poExtAppleDiscovererDispatcher(NULL),
    m_poExtRoleSwitchDispatcher(NULL),
    m_poExtMetaDataDispatcher(NULL),

    m_poExtNativeTransportDispatcher(NULL),
    m_poExtNavDataDispatcher(NULL),
    m_poExtBluetoothDispatcher(NULL),
    m_poExtTelephoneDispatcher(NULL),
    m_poExtOOBTDispatcher(NULL),
    m_poExtMediaDevInfoDispatcher(NULL),
    m_poExtClockDispatcher(NULL)

{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompMsgQThreadable::spi_tclExtCompMsgQThreadable entered \n"));
   m_poExtPositionDispatcher = new spi_tclExtPositionDataDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtPositionDispatcher);
   m_poExtSensorDispatcher = new spi_tclExtSensorDataDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtSensorDispatcher);
   m_poExtWiFiDispatcher = new spi_tclExtWiFiDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtWiFiDispatcher);
   m_poExtAppleDiscovererDispatcher = new spi_tclExtAppleDiscovererDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtAppleDiscovererDispatcher);
   m_poExtRoleSwitchDispatcher = new spi_tclExtRoleSwitchDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtRoleSwitchDispatcher);
   m_poExtMetaDataDispatcher = new spi_tclExtMetaDataDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtMetaDataDispatcher);
   m_poExtNavDataDispatcher = new spi_tclExtNavDataDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtNavDataDispatcher);
   m_poExtNativeTransportDispatcher = new spi_tclExtNativeTransportDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtNativeTransportDispatcher);
   m_poExtBluetoothDispatcher = new spi_tclExtBluetoothDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtBluetoothDispatcher);
   m_poExtTelephoneDispatcher = new spi_tclExtTelephoneDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtTelephoneDispatcher);
   m_poExtOOBTDispatcher = new spi_tclExtOOBTDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtOOBTDispatcher);

   m_poExtMediaDevInfoDispatcher = new spi_tclExtMediaDevInfoDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtMediaDevInfoDispatcher);
   m_poExtClockDispatcher = new spi_tclExtClockDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poExtClockDispatcher);

}

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompMsgQThreadable::~spi_tclExtCompMsgQThreadable()
 ***************************************************************************/

spi_tclExtCompMsgQThreadable::~spi_tclExtCompMsgQThreadable()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompMsgQThreadable::~spi_tclExtCompMsgQThreadable entered \n"));
   RELEASE_MEM(m_poExtPositionDispatcher);
   RELEASE_MEM(m_poExtSensorDispatcher);
   RELEASE_MEM(m_poExtWiFiDispatcher);
   RELEASE_MEM(m_poExtAppleDiscovererDispatcher);
   RELEASE_MEM(m_poExtRoleSwitchDispatcher);
   RELEASE_MEM(m_poExtMetaDataDispatcher);
   RELEASE_MEM(m_poExtNavDataDispatcher);
   RELEASE_MEM(m_poExtNativeTransportDispatcher);
   RELEASE_MEM(m_poExtBluetoothDispatcher);
   RELEASE_MEM(m_poExtTelephoneDispatcher);
   RELEASE_MEM(m_poExtOOBTDispatcher);
   RELEASE_MEM(m_poExtMediaDevInfoDispatcher);
   RELEASE_MEM(m_poExtClockDispatcher);
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompMsgQThreadable::vExecute
 ***************************************************************************/

t_Void spi_tclExtCompMsgQThreadable::vExecute(tShlMessage *poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompMsgQThreadable::vExecute entered \n"));
   if ((NULL != poMessage) && (NULL != poMessage->pvBuffer))
   {
      trMsgBase *prMsgBase = static_cast<trMsgBase*>(poMessage->pvBuffer);
      if (NULL != prMsgBase)
      {
         t_U32 u32ServiceID = prMsgBase->u32GetServiceID();
         ETG_TRACE_USR2(("[DESC]:Dispatch External Interface message with ServiceID = %d \n", u32ServiceID));

         //! Handle message to corresponding dispatcher based on Service ID
         switch (u32ServiceID)
         {
            case e32MODULEID_EXTPOSITION:
            {
               PositionMsgBase *poPositionMsgBase = static_cast<PositionMsgBase*>(poMessage->pvBuffer);
               if (NULL != poPositionMsgBase)
               {
                  poPositionMsgBase->vDispatchMsg(m_poExtPositionDispatcher);
               } // if (NULL != poPositionMsgBase)
            }
               break;

            case e32MODULEID_EXTSENSOR:
            {
               SensorMsgBase *poSensorMsgBase = static_cast<SensorMsgBase*>(poMessage->pvBuffer);
               if (NULL != poSensorMsgBase)
               {
                  poSensorMsgBase->vDispatchMsg(m_poExtSensorDispatcher);
               } // if (NULL != poSensorMsgBase)
            }
               break;

            case e32MODULEID_EXTWIFI:
            {
               WiFiMsgBase *poWiFiMsgBase = static_cast<WiFiMsgBase*>(poMessage->pvBuffer);
               if (NULL != poWiFiMsgBase)
               {
                  poWiFiMsgBase->vDispatchMsg(m_poExtWiFiDispatcher);
               } // if (NULL != poWiFiMsgBase)
            }
               break;

            case e32MODULEID_APPLEDISCOVERER:
            {
               AppleDiscovererMsgBase *poAppleDiscovererMsgBase =
                        static_cast<AppleDiscovererMsgBase*>(poMessage->pvBuffer);
               if (NULL != poAppleDiscovererMsgBase)
               {
                  poAppleDiscovererMsgBase->vDispatchMsg(m_poExtAppleDiscovererDispatcher);
               } // if (NULL != poAppleDiscovererMsgBase)
            }
               break;

            case e32MODULEID_ROLESWITCH:
            {
               RoleSwitchCompleteMsgBase *poRoleSwitchCompleteMsgBase =
                        static_cast<RoleSwitchCompleteMsgBase*>(poMessage->pvBuffer);
               if (NULL != poRoleSwitchCompleteMsgBase)
               {
                  poRoleSwitchCompleteMsgBase->vDispatchMsg(m_poExtRoleSwitchDispatcher);
               } // if (NULL != poRoleSwitchCompleteMsgBase)
            }
               break;

            case e32MODULEID_METADATA:
            {
               MetaDataMsgBase *poMetaDataMsgBase = static_cast<MetaDataMsgBase*>(poMessage->pvBuffer);
               if (NULL != poMetaDataMsgBase)
               {
                  poMetaDataMsgBase->vDispatchMsg(m_poExtMetaDataDispatcher);
               } // if (NULL != poMetaDataMsgBase)
            }
               break;

            case e32MODULEID_NATIVETRANSPORT:
            {
               NativeTransportMsgBase *poNativeTransportMsgBase =
                        static_cast<NativeTransportMsgBase*>(poMessage->pvBuffer);
               if (NULL != poNativeTransportMsgBase)
               {
                  poNativeTransportMsgBase->vDispatchMsg(m_poExtNativeTransportDispatcher);
               } // if (NULL != poNativeTransportMsgBase)
            }
               break;

            case e32MODULEID_NAVDATA:
            {
               NavDataMsgBase *poNavDataMsgBase = static_cast<NavDataMsgBase*>(poMessage->pvBuffer);
               if (NULL != poNavDataMsgBase)
               {
                  poNavDataMsgBase->vDispatchMsg(m_poExtNavDataDispatcher);
               } // if (NULL != poNavDataMsgBase)
            }
               break;

            case e32MODULEID_BLUETOOTH:
            {
               BluetoothMsgBase *poBluetoothMsgBase = static_cast<BluetoothMsgBase*>(poMessage->pvBuffer);
               if (NULL != poBluetoothMsgBase)
               {
                  poBluetoothMsgBase->vDispatchMsg(m_poExtBluetoothDispatcher);
               } // if (NULL != poBluetoothMsgBase)
            }
               break;

            case e32MODULEID_OOBT:
            {
               OOBTMsgBase *poOOBTMsgBase = static_cast<OOBTMsgBase*>(poMessage->pvBuffer);
               if (NULL != poOOBTMsgBase)
               {
                  poOOBTMsgBase->vDispatchMsg(m_poExtOOBTDispatcher);
               } // if (NULL != poBluetoothMsgBase)
            }
               break;

            case e32MODULEID_TELEPHONE:
            {
               TelephoneMsgBase *poTelephoneMsgBase = static_cast<TelephoneMsgBase*>(poMessage->pvBuffer);
               if (NULL != poTelephoneMsgBase)
               {
                  poTelephoneMsgBase->vDispatchMsg(m_poExtTelephoneDispatcher);
               } // if (NULL != poTelephoneMsgBase)
            }
               break;
            case e32MODULEID_MEDIADEVINFO:
            {
               MediaDevInfoMsgBase *poMediaDevInfoMsgBase = static_cast<MediaDevInfoMsgBase*>(poMessage->pvBuffer);
               if (NULL != poMediaDevInfoMsgBase)
               {
                  poMediaDevInfoMsgBase->vDispatchMsg(m_poExtMediaDevInfoDispatcher);
               }
            }
               break;
            case e32MODULEID_CLOCK:
            {
               ClockMsgBase *poClockMsgBase = static_cast<ClockMsgBase*>(poMessage->pvBuffer);
               if (NULL != poClockMsgBase)
               {
                  poClockMsgBase->vDispatchMsg(m_poExtClockDispatcher);
               } // if (NULL != poClockMsgBase)
            }
               break;

            default:
            {
               ETG_TRACE_ERR(("[ERR]:spi_tclExtCompMsgQThreadable::vExecute Unknown ServiceID %d \n", u32ServiceID));
            }
               break;
         } // switch (u32ServiceID)
      } // if (NULL != prMsgBase)

      t_U8 *pu8Buffer = static_cast<t_PU8>(poMessage->pvBuffer);
      RELEASE_ARRAY_MEM(pu8Buffer);
   }
   RELEASE_MEM(poMessage);
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompMsgQThreadable::~poGetMsgBuffer()
 ***************************************************************************/
tShlMessage* spi_tclExtCompMsgQThreadable::poGetMsgBuffer(size_t siBuffer)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompMsgQThreadable::poGetMsgBuffer entered \n"));
   tShlMessage* poMessage = new tShlMessage;

   if (NULL != poMessage)
   {
      if (0 < siBuffer)
      {
         //! Allocate the requested memory
         poMessage->pvBuffer = new (std::nothrow) t_U8[siBuffer];
      }
      else
      {
         poMessage->pvBuffer = NULL;
      } // if(0 < siBuffer)

      if (NULL != poMessage->pvBuffer)
      {
         poMessage->size = (siBuffer);
      }
      else
      {
         //! Free the message as internal allocation failed.
         delete poMessage;
         poMessage = NULL;
      } //   if (NULL != poMessage->pvBuffer)
   } // if (NULL != poMessage)
   return poMessage;
}
