/***********************************************************************/
/*!
 * \file  spi_tclExtCompMsgQInterface.cpp
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for External Interface
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
                 threading model for External Interface
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                		| Modification
 06.01.2017  |  Unmukt Jain (RBEI/ECP2)     | Initial Version

 \endverbatim
 *************************************************************************/


/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclExtCompMsgQInterface.h"
#include "MessageQueue.h"
#include "SPITypes.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtCompMsgQInterface.cpp.trc.h"
   #endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompMsgQInterface::spi_tclExtCompMsgQInterface()
 ***************************************************************************/
spi_tclExtCompMsgQInterface::spi_tclExtCompMsgQInterface():
m_poExtCompMsgQThreadable(NULL),
m_poExtCompMsgQThreader(NULL)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompMsgQInterface::spi_tclAAPMsgQInterface entered \n"));
   m_poExtCompMsgQThreadable = new spi_tclExtCompMsgQThreadable();
   SPI_NORMAL_ASSERT(NULL == m_poExtCompMsgQThreadable);
   m_poExtCompMsgQThreader = new MsgQThreader(m_poExtCompMsgQThreadable);
   SPI_NORMAL_ASSERT(NULL == m_poExtCompMsgQThreader);
   if(NULL != m_poExtCompMsgQThreader)
   {
      m_poExtCompMsgQThreader->bRunThread();
	   m_poExtCompMsgQThreader->vSetThreadName("ExtIntfQ");
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompMsgQInterface::~spi_tclExtCompMsgQInterface()
 ***************************************************************************/
spi_tclExtCompMsgQInterface::~spi_tclExtCompMsgQInterface()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompMsgQInterface::~spi_tclExtCompMsgQInterface entered \n"));

   if (NULL != m_poExtCompMsgQThreader)
   {
      //Terminate the Message Queue threader before deleting it.
      MessageQueue *poMsgQ = m_poExtCompMsgQThreader->poGetMessageQueu();
      trMsgBase oMsgQTermMsg;
      poMsgQ->s16Push(static_cast<t_Void*> (&oMsgQTermMsg), 0, 1, e8_TCL_THREAD_TERMINATE_MESSAGE);

      //Wait for the message queue thread to join.
      Threader::vWaitForTermination(m_poExtCompMsgQThreader->pGetThreadID());
   }

   RELEASE_MEM(m_poExtCompMsgQThreader);
   RELEASE_MEM(m_poExtCompMsgQThreadable);
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompMsgQInterface::bWriteMsgToQ
 ***************************************************************************/
t_Bool spi_tclExtCompMsgQInterface::bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompMsgQInterface::bWriteMsgToQ entered \n"));
   t_Bool bRetQ = false;

   if (NULL != m_poExtCompMsgQThreader)
   {
      //! Get the MsgQ form threader and push the message to Q
      MessageQueue *poMsgQ = m_poExtCompMsgQThreader->poGetMessageQueu();
      if ((NULL != poMsgQ) && (NULL != prMsgBase))
      {
         t_S32 s32RetMsgQ = poMsgQ->s16Push(static_cast<t_Void*>(prMsgBase), u32MsgSize);
         bRetQ = (0 == s32RetMsgQ);
      } // if ((NULL != poMsgQ) && (NULL != prMsgBase))
   } //if (NULL != m_poExtCompMsgQThreader)

   if(false == bRetQ)
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclExtCompMsgQInterface::bWriteMsgToQ - Write to AAP MsgQ failed  \n"));
   }

   return bRetQ;
}
